import { BlockUIInstanceService } from './block-ui-instance.service';
export declare class BlockUIService {
    private blockUIInstance;
    constructor(blockUIInstance: BlockUIInstanceService);
    /**
    * Starts blocking for given BlockUI instance or instances
    */
    start(target: string | string[], message?: any): void;
    /**
    * Stops blocking for given BlockUI instance or instances
    */
    stop(target: string | string[]): void;
    /**
    * Unsubscribes for given BlockUI instance or instances
    */
    unsubscribe(target: string | string[]): void;
    /**
    * Checks if BlockUI is actively blocking
    */
    isActive(target?: string | string[]): boolean;
    private dispatch(target, type, message?);
    private toArray(target?);
}
