(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs/operators'), require('ng-block-ui'), require('@angular/common/http')) :
    typeof define === 'function' && define.amd ? define('ng-block-ui/http', ['exports', '@angular/core', 'rxjs/operators', 'ng-block-ui', '@angular/common/http'], factory) :
    (factory((global['ng-block-ui'] = global['ng-block-ui'] || {}, global['ng-block-ui'].http = {}),global.ng.core,global.rxjs.operators,global['ng-block-ui'],global.ng.common.http));
}(this, (function (exports,core,operators,ngBlockUi,http) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIHttpSettings = (function () {
        function BlockUIHttpSettings() {
            this.settings = {};
        }
        BlockUIHttpSettings.decorators = [
            { type: core.Injectable },
        ];
        return BlockUIHttpSettings;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIInterceptor = (function () {
        function BlockUIInterceptor(blockUIService, blockUIHttpSettings) {
            this.blockUIService = blockUIService;
            this.blockUIHttpSettings = blockUIHttpSettings;
            this.activeHttpRequests = 0;
        }
        /**
         * @param {?} request
         * @param {?} next
         * @return {?}
         */
        BlockUIInterceptor.prototype.intercept = /**
         * @param {?} request
         * @param {?} next
         * @return {?}
         */
            function (request, next) {
                var _this = this;
                var /** @type {?} */ active = false;
                if (this.shouldBlock(request)) {
                    active = true;
                    this.activeHttpRequests++;
                    this.blockUIService.start(ngBlockUi.BLOCKUI_DEFAULT);
                }
                return next.handle(request)
                    .pipe(operators.finalize(function () {
                    if (_this.shouldBlock(request)) {
                        _this.activeHttpRequests--;
                        var /** @type {?} */ stopBlockUI = false;
                        if (!!_this.blockUIHttpSettings.settings.blockAllRequestsInProgress && _this.activeHttpRequests <= 0) {
                            _this.activeHttpRequests = 0;
                            stopBlockUI = true;
                        }
                        else if (active) {
                            stopBlockUI = true;
                        }
                        if (stopBlockUI) {
                            _this.blockUIService.stop(ngBlockUi.BLOCKUI_DEFAULT);
                        }
                    }
                }));
            };
        /**
         * @param {?} request
         * @return {?}
         */
        BlockUIInterceptor.prototype.shouldBlock = /**
         * @param {?} request
         * @return {?}
         */
            function (request) {
                var method = request.method, urlWithParams = request.urlWithParams;
                var /** @type {?} */ settings = this.blockUIHttpSettings.settings;
                var /** @type {?} */ requestFilters = settings.requestFilters || [];
                return !requestFilters.some(function (f) {
                    if (f && f.method && f.url) {
                        return f.method.toUpperCase() === method && f.url.test(urlWithParams);
                    }
                    else if (typeof f === 'function') {
                        return f(request);
                    }
                    return f.test(urlWithParams);
                });
            };
        BlockUIInterceptor.decorators = [
            { type: core.Injectable },
        ];
        /** @nocollapse */
        BlockUIInterceptor.ctorParameters = function () {
            return [
                { type: ngBlockUi.BlockUIService },
                { type: BlockUIHttpSettings }
            ];
        };
        return BlockUIInterceptor;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    // Needed for AOT compiling
    var /** @type {?} */ BlockUIHttpModuleSettings = new core.InjectionToken('BlockUIHttpModuleSettings');
    /**
     * @param {?} settings
     * @return {?}
     */
    function provideSettingsInstance(settings) {
        return { settings: settings };
    }
    var BlockUIHttpModule = (function () {
        function BlockUIHttpModule() {
        }
        /**
         * @param {?=} settings
         * @return {?}
         */
        BlockUIHttpModule.forRoot = /**
         * @param {?=} settings
         * @return {?}
         */
            function (settings) {
                if (settings === void 0) {
                    settings = {};
                }
                return {
                    ngModule: BlockUIHttpModule,
                    providers: [
                        {
                            provide: BlockUIHttpModuleSettings,
                            useValue: settings
                        },
                        {
                            provide: BlockUIHttpSettings,
                            useFactory: provideSettingsInstance,
                            deps: [BlockUIHttpModuleSettings]
                        },
                        {
                            provide: http.HTTP_INTERCEPTORS,
                            useClass: BlockUIInterceptor,
                            multi: true
                        }
                    ]
                };
            };
        BlockUIHttpModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [ngBlockUi.BlockUIModule]
                    },] },
        ];
        return BlockUIHttpModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    exports.BlockUIHttpModule = BlockUIHttpModule;
    exports.ɵc = BlockUIHttpSettings;
    exports.ɵd = BlockUIInterceptor;
    exports.ɵa = BlockUIHttpModuleSettings;
    exports.ɵb = provideSettingsInstance;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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