"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BarePullRequestDetailView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactTabs = require("react-tabs");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _prChangedFilesContainer = _interopRequireDefault(require("../containers/pr-changed-files-container"));

var _prCheckoutController = require("../controllers/pr-checkout-controller");

var _prTimelineController = _interopRequireDefault(require("../controllers/pr-timeline-controller"));

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../views/github-dotcom-markdown"));

var _issueishBadge = _interopRequireDefault(require("../views/issueish-badge"));

var _checkoutButton = _interopRequireDefault(require("./checkout-button"));

var _prCommitsView = _interopRequireDefault(require("../views/pr-commits-view"));

var _prStatusesView = _interopRequireDefault(require("../views/pr-statuses-view"));

var _reviewsFooterView = _interopRequireDefault(require("../views/reviews-footer-view"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BarePullRequestDetailView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      refreshing: false
    });

    _defineProperty(this, "handleRefreshClick", e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    });

    _defineProperty(this, "recordOpenInBrowserEvent", () => {
      (0, _reporterProxy.addEvent)('open-pull-request-in-browser', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "onTabSelected", index => {
      this.props.onTabSelected(index);
      const eventName = ['open-pr-tab-overview', 'open-pr-tab-build-status', 'open-pr-tab-commits', 'open-pr-tab-files-changed'][index];
      (0, _reporterProxy.addEvent)(eventName, {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "refresh", () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({
        refreshing: true
      });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.pullRequest.id,
        timelineCount: _helpers.PAGE_SIZE,
        timelineCursor: null,
        commitCount: _helpers.PAGE_SIZE,
        commitCursor: null
      }, null, err => {
        if (err) {
          this.props.reportRelayError('Unable to refresh pull request details', err);
        }

        this.setState({
          refreshing: false
        });
      }, {
        force: true
      });
    });
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher["default"](BarePullRequestDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.pullRequest.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    }); // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderPrMetadata(pullRequest, repo) {
    const author = this.getAuthor(pullRequest);
    return _react["default"].createElement("span", {
      className: "github-IssueishDetailView-meta"
    }, _react["default"].createElement("code", {
      className: "github-IssueishDetailView-baseRefName"
    }, pullRequest.isCrossRepository ? `${repo.owner.login}/${pullRequest.baseRefName}` : pullRequest.baseRefName), ' ‹ ', _react["default"].createElement("code", {
      className: "github-IssueishDetailView-headRefName"
    }, pullRequest.isCrossRepository ? `${author.login}/${pullRequest.headRefName}` : pullRequest.headRefName));
  }

  renderPullRequestBody(pullRequest) {
    const onBranch = this.props.checkoutOp.why() === _prCheckoutController.checkoutStates.CURRENT;

    return _react["default"].createElement(_reactTabs.Tabs, {
      selectedIndex: this.props.selectedTab,
      onSelect: this.onTabSelected
    }, _react["default"].createElement(_reactTabs.TabList, {
      className: "github-tablist"
    }, _react["default"].createElement(_reactTabs.Tab, {
      className: "github-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "info",
      className: "github-tab-icon"
    }), "Overview"), _react["default"].createElement(_reactTabs.Tab, {
      className: "github-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "checklist",
      className: "github-tab-icon"
    }), "Build Status"), _react["default"].createElement(_reactTabs.Tab, {
      className: "github-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "git-commit",
      className: "github-tab-icon"
    }), "Commits", _react["default"].createElement("span", {
      className: "github-tab-count"
    }, pullRequest.countedCommits.totalCount)), _react["default"].createElement(_reactTabs.Tab, {
      className: "github-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "diff",
      className: "github-tab-icon"
    }), "Files", _react["default"].createElement("span", {
      className: "github-tab-count"
    }, pullRequest.changedFiles))), _react["default"].createElement(_reactTabs.TabPanel, null, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-overview"
    }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: pullRequest.bodyHTML || '<em>No description provided.</em>',
      switchToIssueish: this.props.switchToIssueish
    }), _react["default"].createElement(_emojiReactionsController["default"], {
      reactable: pullRequest,
      tooltips: this.props.tooltips,
      reportRelayError: this.props.reportRelayError
    }), _react["default"].createElement(_prTimelineController["default"], {
      onBranch: onBranch,
      openCommit: this.props.openCommit,
      pullRequest: pullRequest,
      switchToIssueish: this.props.switchToIssueish
    }))), _react["default"].createElement(_reactTabs.TabPanel, null, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-buildStatus"
    }, _react["default"].createElement(_prStatusesView["default"], {
      pullRequest: pullRequest,
      displayType: "full",
      switchToIssueish: this.props.switchToIssueish
    }))), _react["default"].createElement(_reactTabs.TabPanel, null, _react["default"].createElement(_prCommitsView["default"], {
      pullRequest: pullRequest,
      onBranch: onBranch,
      openCommit: this.props.openCommit
    })), _react["default"].createElement(_reactTabs.TabPanel, {
      className: "github-IssueishDetailView-filesChanged"
    }, _react["default"].createElement(_prChangedFilesContainer["default"], {
      localRepository: this.props.localRepository,
      owner: this.props.repository.owner.login,
      repo: this.props.repository.name,
      number: pullRequest.number,
      endpoint: this.props.endpoint,
      token: this.props.token,
      reviewCommentsLoading: this.props.reviewCommentsLoading,
      reviewCommentThreads: this.props.reviewCommentThreads,
      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      workdirPath: this.props.workdirPath,
      itemType: this.props.itemType,
      refEditor: this.props.refEditor,
      destroy: this.props.destroy,
      shouldRefetch: this.state.refreshing,
      switchToIssueish: this.props.switchToIssueish,
      pullRequest: this.props.pullRequest,
      initChangedFilePath: this.props.initChangedFilePath,
      initChangedFilePosition: this.props.initChangedFilePosition,
      onOpenFilesTab: this.props.onOpenFilesTab
    })));
  }

  render() {
    const repo = this.props.repository;
    const pullRequest = this.props.pullRequest;
    const author = this.getAuthor(pullRequest);
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView native-key-bindings"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-container"
    }, _react["default"].createElement("header", {
      className: "github-IssueishDetailView-header"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-avatar",
      href: author.url
    }, _react["default"].createElement("img", {
      className: "github-IssueishDetailView-avatarImage",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn is-flexible"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow is-fullwidth"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-title",
      href: pullRequest.url
    }, pullRequest.title)), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, _react["default"].createElement(_issueishBadge["default"], {
      className: "github-IssueishDetailView-headerBadge",
      type: pullRequest.__typename,
      state: pullRequest.state
    }), _react["default"].createElement(_octicon["default"], {
      icon: "repo-sync",
      className: (0, _classnames["default"])('github-IssueishDetailView-headerRefreshButton', {
        refreshing: this.state.refreshing
      }),
      onClick: this.handleRefreshClick
    }), _react["default"].createElement("a", {
      className: "github-IssueishDetailView-headerLink",
      title: "open on GitHub.com",
      href: pullRequest.url,
      onClick: this.recordOpenInBrowserEvent
    }, repo.owner.login, "/", repo.name, "#", pullRequest.number), _react["default"].createElement("span", {
      className: "github-IssueishDetailView-headerStatus"
    }, _react["default"].createElement(_prStatusesView["default"], {
      pullRequest: pullRequest,
      displayType: "check",
      switchToIssueish: this.props.switchToIssueish
    }))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, this.renderPrMetadata(pullRequest, repo))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react["default"].createElement(_checkoutButton["default"], {
      checkoutOp: this.props.checkoutOp,
      classNamePrefix: "github-IssueishDetailView-checkoutButton--",
      classNames: ['github-IssueishDetailView-checkoutButton']
    }))), this.renderPullRequestBody(pullRequest), _react["default"].createElement(_reviewsFooterView["default"], {
      commentsResolved: this.props.reviewCommentsResolvedCount,
      totalComments: this.props.reviewCommentsTotalCount,
      openReviews: this.props.openReviews,
      pullRequestURL: `${this.props.pullRequest.url}/files`
    })));
  }

  getAuthor(pullRequest) {
    return pullRequest.author || _helpers.GHOST_USER;
  }

}

exports.BarePullRequestDetailView = BarePullRequestDetailView;

_defineProperty(BarePullRequestDetailView, "propTypes", {
  // Relay response
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }),
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string
    })
  }),
  pullRequest: _propTypes["default"].shape({
    __typename: _propTypes["default"].string.isRequired,
    id: _propTypes["default"].string.isRequired,
    title: _propTypes["default"].string,
    countedCommits: _propTypes["default"].shape({
      totalCount: _propTypes["default"].number.isRequired
    }).isRequired,
    isCrossRepository: _propTypes["default"].bool,
    changedFiles: _propTypes["default"].number.isRequired,
    url: _propTypes["default"].string.isRequired,
    bodyHTML: _propTypes["default"].string,
    number: _propTypes["default"].number,
    state: _propTypes["default"].oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired,
      url: _propTypes["default"].string.isRequired
    })
  }).isRequired,
  // Local model objects
  localRepository: _propTypes["default"].object.isRequired,
  checkoutOp: _propTypes2.EnableableOperationPropType.isRequired,
  workdirPath: _propTypes["default"].string,
  // Review comment threads
  reviewCommentsLoading: _propTypes["default"].bool.isRequired,
  reviewCommentsTotalCount: _propTypes["default"].number.isRequired,
  reviewCommentsResolvedCount: _propTypes["default"].number.isRequired,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })).isRequired,
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action functions
  openCommit: _propTypes["default"].func.isRequired,
  openReviews: _propTypes["default"].func.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired,
  // Tab management
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  selectedTab: _propTypes["default"].number.isRequired,
  onTabSelected: _propTypes["default"].func.isRequired,
  onOpenFilesTab: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BarePullRequestDetailView, {
  repository: function () {
    const node = require("./__generated__/prDetailView_repository.graphql");

    if (node.hash && node.hash !== "3f3d61ddd6afa1c9e0811c3b5be51bb0") {
      console.error("The definition of 'prDetailView_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prDetailView_repository.graphql");
  },
  pullRequest: function () {
    const node = require("./__generated__/prDetailView_pullRequest.graphql");

    if (node.hash && node.hash !== "e427b865abf965b5693382d0c5611f2f") {
      console.error("The definition of 'prDetailView_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prDetailView_pullRequest.graphql");
  }
}, function () {
  const node = require("./__generated__/prDetailViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "f7acdb13531246546b24c4a1e4b193c8") {
    console.error("The definition of 'prDetailViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/prDetailViewRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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