"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filter = filter;
exports.MAX_PATCH_CHARS = void 0;
const MAX_PATCH_CHARS = 1024 * 1024;
exports.MAX_PATCH_CHARS = MAX_PATCH_CHARS;

function filter(original) {
  let accumulating = false;
  let accumulated = '';
  let includedChars = 0;
  const removed = new Set();
  const pathRx = /\n?diff --git (?:a|b)\/(\S+) (?:a|b)\/(\S+)/y;
  let index = 0;

  while (index !== -1) {
    let include = true;
    const result = original.indexOf('\ndiff --git ', index);
    const nextIndex = result !== -1 ? result + 1 : -1;
    const patchEnd = nextIndex !== -1 ? nextIndex : original.length; // Exclude this patch if its inclusion would cause the patch to become too large.

    const patchChars = patchEnd - index + 1;

    if (includedChars + patchChars > MAX_PATCH_CHARS) {
      include = false;
    }

    if (include) {
      // Avoid copying large buffers of text around if we're including everything anyway.
      if (accumulating) {
        accumulated += original.slice(index, patchEnd);
      }

      includedChars += patchChars;
    } else {
      // If this is the first excluded patch, start by copying everything before this into "accumulated."
      if (!accumulating) {
        accumulating = true;
        accumulated = original.slice(0, index);
      } // Extract the removed filenames from the "diff --git" line.


      pathRx.lastIndex = index;
      const pathMatch = pathRx.exec(original);

      if (pathMatch) {
        removed.add(pathMatch[1]);
        removed.add(pathMatch[2]);
      }
    }

    index = nextIndex;
  }

  return {
    filtered: accumulating ? accumulated : original,
    removed
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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