"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _gitTabContainer = _interopRequireDefault(require("../containers/git-tab-container"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitTabItem extends _react["default"].Component {
  static buildURI() {
    return this.uriPattern;
  }

  constructor(props) {
    super(props);
    this.refController = new _refHolder["default"]();
  }

  render() {
    return _react["default"].createElement(_gitTabContainer["default"], _extends({
      controllerRef: this.refController
    }, this.props));
  }

  serialize() {
    return {
      deserializer: 'GitDockItem',
      uri: this.getURI()
    };
  }

  getTitle() {
    return 'Git';
  }

  getIconName() {
    return 'git-commit';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getURI() {
    return this.constructor.uriPattern;
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  } // Forwarded to the controller instance when one is present


  rememberLastFocus(...args) {
    return this.refController.map(c => c.rememberLastFocus(...args));
  }

  restoreFocus(...args) {
    return this.refController.map(c => c.restoreFocus(...args));
  }

  hasFocus(...args) {
    return this.refController.map(c => c.hasFocus(...args));
  }

  focus() {
    return this.refController.map(c => c.restoreFocus());
  }

  focusAndSelectStagingItem(...args) {
    return this.refController.map(c => c.focusAndSelectStagingItem(...args));
  }

  focusAndSelectCommitPreviewButton() {
    return this.refController.map(c => c.focusAndSelectCommitPreviewButton());
  }

  quietlySelectItem(...args) {
    return this.refController.map(c => c.quietlySelectItem(...args));
  }

  focusAndSelectRecentCommit() {
    return this.refController.map(c => c.focusAndSelectRecentCommit());
  }

}

exports["default"] = GitTabItem;

_defineProperty(GitTabItem, "propTypes", {
  repository: _propTypes["default"].object.isRequired
});

_defineProperty(GitTabItem, "uriPattern", 'atom-github://dock-item/git');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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