"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCheckSuitesAccumulator = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../../helpers");

var _propTypes2 = require("../../prop-types");

var _checkRunsAccumulator = _interopRequireDefault(require("./check-runs-accumulator"));

var _accumulator = _interopRequireDefault(require("./accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCheckSuitesAccumulator extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderCheckSuites", (err, suites, loading) => {
      if (err) {
        return this.props.children({
          errors: [err],
          suites,
          runsBySuite: new Map(),
          loading
        });
      }

      return this.renderCheckSuite({
        errors: [],
        suites,
        runsBySuite: new Map(),
        loading
      }, suites);
    });
  }

  render() {
    const resultBatch = this.props.commit.checkSuites.edges.map(edge => edge.node);
    return _react["default"].createElement(_accumulator["default"], {
      relay: this.props.relay,
      resultBatch: resultBatch,
      onDidRefetch: this.props.onDidRefetch,
      pageSize: _helpers.PAGE_SIZE,
      waitTimeMs: _helpers.PAGINATION_WAIT_TIME_MS
    }, this.renderCheckSuites);
  }

  renderCheckSuite(payload, suites) {
    if (suites.length === 0) {
      return this.props.children(payload);
    }

    const [suite] = suites;
    return _react["default"].createElement(_checkRunsAccumulator["default"], {
      onDidRefetch: this.props.onDidRefetch,
      checkSuite: suite
    }, ({
      error,
      checkRuns,
      loading: runsLoading
    }) => {
      if (error) {
        payload.errors.push(error);
      }

      payload.runsBySuite.set(suite, checkRuns);
      payload.loading = payload.loading || runsLoading;
      return this.renderCheckSuite(payload, suites.slice(1));
    });
  }

}

exports.BareCheckSuitesAccumulator = BareCheckSuitesAccumulator;

_defineProperty(BareCheckSuitesAccumulator, "propTypes", {
  // Relay
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  commit: _propTypes["default"].shape({
    checkSuites: (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].object)
  }).isRequired,
  // Render prop. Called with (array of errors, array of check suites, map of runs per suite, loading)
  children: _propTypes["default"].func.isRequired,
  // Subscribe to an event that will fire just after a Relay refetch container completes a refetch.
  onDidRefetch: _propTypes["default"].func
});

_defineProperty(BareCheckSuitesAccumulator, "defaultProps", {
  onDidRefetch:
  /* istanbul ignore next */
  () => new _eventKit.Disposable()
});

var _default = (0, _reactRelay.createPaginationContainer)(BareCheckSuitesAccumulator, {
  commit: function () {
    const node = require("./__generated__/checkSuitesAccumulator_commit.graphql");

    if (node.hash && node.hash !== "582abc8127f0f2f19fb0a6a531af5e06") {
      console.error("The definition of 'checkSuitesAccumulator_commit' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkSuitesAccumulator_commit.graphql");
  }
}, {
  direction: 'forward',

  /* istanbul ignore next */
  getConnectionFromProps(props) {
    return props.commit.checkSuites;
  },

  /* istanbul ignore next */
  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread({}, prevVars, {
      totalCount
    });
  },

  /* istanbul ignore next */
  getVariables(props, {
    count,
    cursor
  }, fragmentVariables) {
    return {
      id: props.commit.id,
      checkSuiteCount: count,
      checkSuiteCursor: cursor,
      checkRunCount: fragmentVariables.checkRunCount
    };
  },

  query: function () {
    const node = require("./__generated__/checkSuitesAccumulatorQuery.graphql");

    if (node.hash && node.hash !== "b27827b6adb558a64ae6da715a8e438e") {
      console.error("The definition of 'checkSuitesAccumulatorQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkSuitesAccumulatorQuery.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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