"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var axios_1 = require("axios");
var content_type_1 = require("content-type");
var iconv_lite_1 = require("iconv-lite");
var open_graph_1 = require("open-graph");
var url_1 = require("url");
var getLogger_1 = require("../logging/getLogger");
var config_1 = require("../settings/config");
var logger = getLogger_1.getLogger(__filename);
axios_1.default.defaults.adapter = require('axios/lib/adapters/http');
var arrayify = function (value) {
    if (value === void 0) { value = []; }
    return (Array.isArray(value) ? value : [value]);
};
var bufferToBase64 = function (buffer, mimeType) {
    var bufferBase64encoded = Buffer.from(buffer).toString('base64');
    return "data:" + mimeType + ";base64," + bufferBase64encoded;
};
var fetchImageAsBase64 = function (url) { return __awaiter(_this, void 0, void 0, function () {
    var IMAGE_SIZE_LIMIT, parsedUrl, normalizedUrl, axiosConfig, response, error_1, contentType, isImageContentType;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                IMAGE_SIZE_LIMIT = 5e6;
                parsedUrl = url_1.parse(encodeURI(url));
                normalizedUrl = parsedUrl.protocol ? parsedUrl : url_1.parse("http://" + url);
                axiosConfig = {
                    headers: {
                        'User-Agent': config_1.config.userAgent,
                    },
                    maxContentLength: IMAGE_SIZE_LIMIT,
                    method: 'get',
                    responseType: 'arraybuffer',
                    url: normalizedUrl.href,
                };
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                return [4, exports.axiosWithCookie(axiosConfig)];
            case 2:
                response = _a.sent();
                return [3, 4];
            case 3:
                error_1 = _a.sent();
                logger.error(error_1);
                throw new Error("Request failed with status code \"" + error_1.response.status + "\": \"" + error_1.response.statusText + "\".");
            case 4:
                try {
                    contentType = content_type_1.parse(response.headers['content-type']);
                }
                catch (error) {
                    throw new Error("Could not parse content type: \"" + error.message + "\"");
                }
                isImageContentType = contentType.type.match(/.*image\/.*/);
                if (!isImageContentType) {
                    throw new Error("Unhandled format for open graph image ('" + contentType + "')");
                }
                return [2, bufferToBase64(response.data, contentType.type)];
        }
    });
}); };
exports.axiosWithCookie = function (config) { return __awaiter(_this, void 0, void 0, function () {
    var response, error_2, response, setCookie, Cookie;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 2, , 3]);
                return [4, axios_1.default.request(__assign({}, config, { maxRedirects: 0, withCredentials: true }))];
            case 1:
                response = _a.sent();
                return [2, response];
            case 2:
                error_2 = _a.sent();
                response = error_2.response;
                if (!response) {
                    throw error_2;
                }
                if (response.status === 301 || response.status === 302) {
                    setCookie = response.headers['set-cookie'];
                    if (setCookie) {
                        Cookie = Array.isArray(setCookie) ? setCookie.join('; ') : setCookie;
                        config.headers = __assign({}, config.headers, { Cookie: Cookie });
                    }
                }
                return [2, axios_1.default.request(config)];
            case 3: return [2];
        }
    });
}); };
exports.axiosWithContentLimit = function (config, contentLimit) {
    var CancelToken = axios_1.default.CancelToken;
    var cancelSource = CancelToken.source();
    config.responseType = 'stream';
    config.cancelToken = cancelSource.token;
    return new Promise(function (resolve, reject) {
        var partialBody = '';
        return exports.axiosWithCookie(config)
            .then(function (response) {
            var contentType;
            try {
                contentType = content_type_1.parse(response.headers['content-type']);
            }
            catch (error) {
                return reject(new Error("Could not parse content type: \"" + error.message + "\""));
            }
            if (!contentType.type.includes('text/html')) {
                return reject(new Error("Unhandled format for open graph generation ('" + contentType + "')"));
            }
            var charset = contentType.parameters.charset;
            response.data.on('data', function (buffer) {
                var chunk = buffer.toString('utf8');
                if (charset) {
                    try {
                        chunk = iconv_lite_1.decode(buffer, charset);
                    }
                    catch (error) {
                        logger.error("Could not decode content: \"" + error.message + ".\"");
                    }
                }
                partialBody += chunk;
                if (chunk.match('</head>') || partialBody.length > contentLimit) {
                    cancelSource.cancel();
                    resolve(partialBody);
                }
            });
            response.data.on('error', reject);
            response.data.on('end', function () { return resolve(partialBody); });
        })
            .catch(function (error) { return (axios_1.default.isCancel(error) ? Promise.resolve('') : Promise.reject(error)); });
    });
};
var fetchOpenGraphData = function (url) { return __awaiter(_this, void 0, void 0, function () {
    var CONTENT_SIZE_LIMIT, parsedUrl, normalizedUrl, axiosConfig, body, matches, openGraphTags;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                CONTENT_SIZE_LIMIT = 1e6;
                parsedUrl = url_1.parse(encodeURI(url));
                normalizedUrl = parsedUrl.protocol ? parsedUrl : url_1.parse("http://" + url);
                axiosConfig = {
                    headers: {
                        'User-Agent': config_1.config.userAgent,
                    },
                    method: 'get',
                    url: normalizedUrl.href,
                };
                return [4, exports.axiosWithContentLimit(axiosConfig, CONTENT_SIZE_LIMIT)];
            case 1:
                body = _a.sent();
                matches = body.match(/.*property=(["'])og:.+?\1.*/gim) || [''];
                if (!matches) {
                    throw new Error('No open graph tags found in website.');
                }
                openGraphTags = matches.join(' ');
                return [2, open_graph_1.parse(openGraphTags)];
        }
    });
}); };
var updateMetaDataWithImage = function (meta, imageData) {
    if (!meta.image) {
        meta.image = {};
    }
    if (imageData && typeof meta.image === 'object' && !Array.isArray(meta.image)) {
        meta.image.data = imageData;
    }
    else {
        delete meta.image;
    }
    return meta;
};
exports.getOpenGraphData = function (url, callback) { return __awaiter(_this, void 0, void 0, function () {
    var meta, _a, imageUrl, uri, error_3;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0:
                _b.trys.push([0, 6, , 7]);
                return [4, fetchOpenGraphData(url)];
            case 1:
                meta = _b.sent();
                if (!(typeof meta.image === 'object' && !Array.isArray(meta.image) && meta.image.url)) return [3, 4];
                _a = __read(arrayify(meta.image.url), 1), imageUrl = _a[0];
                return [4, fetchImageAsBase64(imageUrl)];
            case 2:
                uri = _b.sent();
                return [4, updateMetaDataWithImage(meta, uri)];
            case 3:
                meta = _b.sent();
                return [3, 5];
            case 4: throw new Error('OpenGraph metadata contains no image.');
            case 5:
                if (callback) {
                    callback(null, meta);
                }
                return [3, 7];
            case 6:
                error_3 = _b.sent();
                if (callback) {
                    callback(error_3);
                }
                else {
                    logger.info(error_3);
                }
                return [3, 7];
            case 7: return [2];
        }
    });
}); };
exports.getOpenGraphDataAsync = function (url) { return __awaiter(_this, void 0, void 0, function () {
    var metadata, _a, imageUrl, uri;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0: return [4, fetchOpenGraphData(url)];
            case 1:
                metadata = _b.sent();
                if (!(typeof metadata.image === 'object' && !Array.isArray(metadata.image) && metadata.image.url)) return [3, 3];
                _a = __read(arrayify(metadata.image.url), 1), imageUrl = _a[0];
                return [4, fetchImageAsBase64(imageUrl)];
            case 2:
                uri = _b.sent();
                return [2, updateMetaDataWithImage(metadata, uri)];
            case 3: throw new Error('OpenGraph metadata contains no image.');
        }
    });
}); };
//# sourceMappingURL=openGraph.js.map