/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Console
extends JTextArea {
    private StreamReader reader1;
    private StreamReader reader2;
    private boolean stopped;

    public void setStopped() {
        this.stopped = true;
    }

    public void stop() throws IOException {
        this.reader1.stream.close();
        this.reader2.stream.close();
    }

    public Console(Process process, String encoding) {
        try {
            this.init(process, encoding);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setEditable(false);
    }

    private void _append(final String line, boolean errorStream) {
        if (this.isEnabled() || errorStream) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Console.this.getText().length() > 0) {
                        Console.this.append("\n" + line);
                    } else {
                        Console.this.append(line);
                    }
                }
            });
        }
    }

    public void start() {
        new Thread(this.reader1).start();
        new Thread(this.reader2).start();
    }

    private void init(Process process, String encoding) throws UnsupportedEncodingException {
        BufferedReader r1 = new BufferedReader(new InputStreamReader(process.getInputStream(), encoding));
        BufferedReader r2 = new BufferedReader(new InputStreamReader(process.getErrorStream(), encoding));
        this.reader1 = new StreamReader(process.getInputStream(), r1, false);
        this.reader2 = new StreamReader(process.getErrorStream(), r2, true);
    }

    private class StreamReader
    implements Runnable {
        private InputStream stream;
        private BufferedReader bufferedReader;
        private boolean errorStream;

        StreamReader(InputStream stream, BufferedReader bufferedReader, boolean errorStream) {
            this.bufferedReader = bufferedReader;
            this.stream = stream;
            this.errorStream = errorStream;
            Console.this.setFont(Font.decode("Monospaced"));
        }

        @Override
        public void run() {
            block3: {
                try {
                    this._run();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    if (Console.this.stopped) break block3;
                    e.printStackTrace();
                }
            }
        }

        public void _run() throws IOException {
            try {
                String line = this.bufferedReader.readLine();
                while (line != null) {
                    Console.this._append(line, this.errorStream);
                    line = this.bufferedReader.readLine();
                }
            }
            finally {
                this.stream.close();
            }
        }
    }
}

