/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.RefInfo;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\u0003\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a$\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a$\u0010\u0017\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u001b"}, d2={"getDefaultLeftPanelTitleForBranch", "", "branchName", "getDefaultRightPanelTitleForBranch", "baseHash", "Lcom/intellij/vcs/log/Hash;", "getDescriptionForRebase", "rebasingBranch", "baseBranch", "getSingleCurrentBranchName", "roots", "", "Lgit4idea/repo/GitRepository;", "getSingleMergeBranchName", "resolveBranchName", "Lgit4idea/merge/RefInfo;", "repository", "hash", "resolveMergeBranch", "resolveMergeBranchOrCherryPick", "resolveRebaseOntoBranch", "tryResolveRef", "ref", "appendBranchName", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.vcs.git"})
public final class GitDefaultMergeDialogCustomizerKt {
    @NotNull
    public static final String getDescriptionForRebase(@Nullable String rebasingBranch, @Nullable String baseBranch, @Nullable Hash baseHash) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("<html>Rebasing ");
        if (rebasingBranch != null) {
            $this$buildString.append("branch <b>" + XmlStringUtil.escapeString((String)rebasingBranch) + "</b> ");
        }
        $this$buildString.append("onto ");
        GitDefaultMergeDialogCustomizerKt.appendBranchName($this$buildString, baseBranch, baseHash);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String getDefaultLeftPanelTitleForBranch(@NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        return "<html>" + XmlStringUtil.escapeString((String)DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0])) + ", branch <b>" + XmlStringUtil.escapeString((String)branchName) + "</b>";
    }

    @NotNull
    public static final String getDefaultRightPanelTitleForBranch(@Nullable String branchName, @Nullable Hash baseHash) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("<html>Changes from ");
        GitDefaultMergeDialogCustomizerKt.appendBranchName($this$buildString, branchName, baseHash);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final void appendBranchName(@NotNull StringBuilder $this$appendBranchName, String branchName, Hash hash) {
        if (branchName != null) {
            $this$appendBranchName.append("branch <b>" + XmlStringUtil.escapeString((String)branchName) + "</b>");
            if (hash != null) {
                $this$appendBranchName.append(", revision " + hash.toShortString());
            }
        } else if (hash != null) {
            $this$appendBranchName.append("<b>" + hash.toShortString() + "</b>");
        } else {
            $this$appendBranchName.append("diverging branches");
        }
    }

    private static final String resolveMergeBranchOrCherryPick(GitRepository repository) {
        RefInfo mergeBranch = GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
        if (mergeBranch != null) {
            return mergeBranch.getPresentable();
        }
        RefInfo rebaseOntoBranch = GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
        if (rebaseOntoBranch != null) {
            return rebaseOntoBranch.getPresentable();
        }
        Hash cherryHead = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "CHERRY_PICK_HEAD");
        if (cherryHead != null) {
            return "cherry-pick";
        }
        return null;
    }

    private static final RefInfo resolveMergeBranch(GitRepository repository) {
        Hash hash = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "MERGE_HEAD");
        if (hash == null) {
            return null;
        }
        Hash mergeHead = hash;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repository, mergeHead);
    }

    private static final RefInfo resolveRebaseOntoBranch(GitRepository repository) {
        String string;
        File file = GitRebaseUtils.getRebaseDir(repository.getProject(), repository.getRoot());
        if (file == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"GitRebaseUtils.getRebase\u2026tory.root) ?: return null");
        File rebaseDir = file;
        try {
            String string2 = FileUtil.loadFile((File)new File(rebaseDir, "onto"));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.loadFile(File(rebaseDir, \"onto\"))");
            string = string2;
            boolean bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }
        catch (IOException e) {
            return null;
        }
        String ontoHash = string;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(repository.getProject()).getRepositoryForRoot(repository.getRoot());
        if (gitRepository == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"GitRepositoryManager.get\u2026tory.root) ?: return null");
        GitRepository repo = gitRepository;
        Hash hash = HashImpl.build((String)ontoHash);
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"HashImpl.build(ontoHash)");
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repo, hash);
    }

    private static final RefInfo resolveBranchName(GitRepository repository, Hash hash) {
        Collection<GitLocalBranch> collection = repository.getBranches().findLocalBranchesByHash(hash);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repository.branches.findLocalBranchesByHash(hash)");
        Collection<GitBranch> branches2 = collection;
        if (branches2.isEmpty()) {
            Collection<GitRemoteBranch> collection2 = repository.getBranches().findRemoteBranchesByHash(hash);
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"repository.branches.findRemoteBranchesByHash(hash)");
            branches2 = collection2;
        }
        GitBranch gitBranch = (GitBranch)CollectionsKt.singleOrNull((Iterable)branches2);
        return new RefInfo(hash, gitBranch != null ? gitBranch.getName() : null);
    }

    private static final Hash tryResolveRef(GitRepository repository, String ref) {
        try {
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.resolve(repository.getProject(), repository.getRoot(), ref);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRevisionNumber, (String)"GitRevisionNumber.resolv\u2026ct, repository.root, ref)");
            GitRevisionNumber revision = gitRevisionNumber;
            return HashImpl.build((String)revision.asString());
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public static final String getSingleMergeBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        return (String)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)getSingleMergeBranchName.1.INSTANCE)));
    }

    @Nullable
    public static final String getSingleCurrentBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        return (String)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)getSingleCurrentBranchName.1.INSTANCE)));
    }

    public static final /* synthetic */ RefInfo access$resolveMergeBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
    }

    public static final /* synthetic */ RefInfo access$resolveRebaseOntoBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
    }

    public static final /* synthetic */ Hash access$tryResolveRef(GitRepository repository, String ref) {
        return GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, ref);
    }

    public static final /* synthetic */ String access$resolveMergeBranchOrCherryPick(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveMergeBranchOrCherryPick(repository);
    }
}

