/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsOptions;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.reset.GitResetMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Git.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<GitVcsOptions>,
DvcsSyncSettings,
DvcsCompareSettings,
ModificationTracker {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final GitVcsApplicationSettings myAppSettings;
    private GitVcsOptions myState = new GitVcsOptions();

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return this.myAppSettings;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)ServiceManager.getService((Project)project, GitVcsSettings.class);
    }

    @NotNull
    public UpdateMethod getUpdateMethod() {
        UpdateMethod updateMethod = this.myState.getUpdateMethod();
        if (updateMethod == null) {
            GitVcsSettings.$$$reportNull$$$0(0);
        }
        return updateMethod;
    }

    public void setUpdateMethod(UpdateMethod updateType) {
        this.myState.setUpdateMethod(updateType);
    }

    @NotNull
    public UpdateChangesPolicy updateChangesPolicy() {
        UpdateChangesPolicy updateChangesPolicy = this.myState.getUpdateChangesPolicy();
        if (updateChangesPolicy == null) {
            GitVcsSettings.$$$reportNull$$$0(1);
        }
        return updateChangesPolicy;
    }

    public void setUpdateChangesPolicy(UpdateChangesPolicy value) {
        this.myState.setUpdateChangesPolicy(value);
    }

    public void saveCommitAuthor(String author) {
        List<String> previousCommitAuthors = this.myState.getPreviousCommitAuthors();
        previousCommitAuthors.remove(author);
        while (previousCommitAuthors.size() >= 16) {
            previousCommitAuthors.remove(previousCommitAuthors.size() - 1);
        }
        previousCommitAuthors.add(0, author);
    }

    public String[] getCommitAuthors() {
        return ArrayUtilRt.toStringArray(this.myState.getPreviousCommitAuthors());
    }

    public long getModificationCount() {
        return this.myState.getModificationCount();
    }

    public GitVcsOptions getState() {
        return this.myState;
    }

    public void loadState(@NotNull GitVcsOptions state) {
        if (state == null) {
            GitVcsSettings.$$$reportNull$$$0(2);
        }
        this.myState = state;
        this.migrateUpdateIncomingBranchInfo(state);
    }

    private void migrateUpdateIncomingBranchInfo(@NotNull GitVcsOptions state) {
        if (state == null) {
            GitVcsSettings.$$$reportNull$$$0(3);
        }
        if (!state.isUpdateBranchesInfo()) {
            this.myState.setIncomingCheckStrategy(GitIncomingCheckStrategy.Never);
            this.myState.setUpdateBranchesInfo(true);
        }
    }

    @Nullable
    public String getPathToGit() {
        return this.myState.getPathToGit();
    }

    public void setPathToGit(@Nullable String value) {
        this.myState.setPathToGit(value);
    }

    public boolean autoUpdateIfPushRejected() {
        return this.myState.isPushAutoUpdate();
    }

    public void setAutoUpdateIfPushRejected(boolean value) {
        this.myState.setPushAutoUpdate(value);
    }

    public boolean shouldUpdateAllRootsIfPushRejected() {
        return this.myState.isPushUpdateAllRoots();
    }

    public void setUpdateAllRootsIfPushRejected(boolean value) {
        this.myState.setPushUpdateAllRoots(value);
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        DvcsSyncSettings.Value value = this.myState.getRootSync();
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(4);
        }
        return value;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value value) {
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(5);
        }
        this.myState.setRootSync(value);
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.getRecentGitRootPath();
    }

    public void setRecentRoot(@NotNull String value) {
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(6);
        }
        this.myState.setRecentGitRootPath(value);
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        Map<String, String> map2 = this.myState.getRecentBranchByRepository();
        if (map2 == null) {
            GitVcsSettings.$$$reportNull$$$0(7);
        }
        return map2;
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        if (repositoryPath == null) {
            GitVcsSettings.$$$reportNull$$$0(8);
        }
        if (branch == null) {
            GitVcsSettings.$$$reportNull$$$0(9);
        }
        this.myState.getRecentBranchByRepository().put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return this.myState.getRecentCommonBranch();
    }

    public void setRecentCommonBranch(@NotNull String value) {
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(10);
        }
        this.myState.setRecentCommonBranch(value);
    }

    public void setAutoCommitOnRevert(boolean value) {
        this.myState.setAutoCommitOnRevert(value);
    }

    public boolean isAutoCommitOnRevert() {
        return this.myState.isAutoCommitOnRevert();
    }

    public boolean warnAboutCrlf() {
        return this.myState.getWarnAboutCrlf();
    }

    public void setWarnAboutCrlf(boolean value) {
        this.myState.setWarnAboutCrlf(value);
    }

    public boolean warnAboutDetachedHead() {
        return this.myState.isWarnAboutDetachedHead();
    }

    public void setWarnAboutDetachedHead(boolean value) {
        this.myState.setWarnAboutDetachedHead(value);
    }

    @Nullable
    public GitResetMode getResetMode() {
        return this.myState.getResetMode();
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        if (mode == null) {
            GitVcsSettings.$$$reportNull$$$0(11);
        }
        this.myState.setResetMode(mode);
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return this.myState.getPushTags();
    }

    public void setPushTagMode(@Nullable GitPushTagMode value) {
        this.myState.setPushTags(value);
    }

    public boolean shouldSignOffCommit() {
        return this.myState.isSignOffCommit();
    }

    public void setSignOffCommit(boolean value) {
        this.myState.setSignOffCommit(value);
    }

    @NotNull
    public GitIncomingCheckStrategy getIncomingCheckStrategy() {
        GitIncomingCheckStrategy gitIncomingCheckStrategy = this.myState.getIncomingCheckStrategy();
        if (gitIncomingCheckStrategy == null) {
            GitVcsSettings.$$$reportNull$$$0(12);
        }
        return gitIncomingCheckStrategy;
    }

    public void setIncomingCheckStrategy(@NotNull GitIncomingCheckStrategy strategy) {
        if (strategy == null) {
            GitVcsSettings.$$$reportNull$$$0(13);
        }
        this.myState.setIncomingCheckStrategy(strategy);
    }

    public boolean shouldPreviewPushOnCommitAndPush() {
        return this.myState.isPreviewPushOnCommitAndPush();
    }

    public void setPreviewPushOnCommitAndPush(boolean value) {
        this.myState.setPreviewPushOnCommitAndPush(value);
    }

    public boolean isPreviewPushProtectedOnly() {
        return this.myState.isPreviewPushProtectedOnly();
    }

    public void setPreviewPushProtectedOnly(boolean value) {
        this.myState.setPreviewPushProtectedOnly(value);
    }

    public boolean isCommitRenamesSeparately() {
        return this.myState.isCommitRenamesSeparately();
    }

    public void setCommitRenamesSeparately(boolean value) {
        this.myState.setCommitRenamesSeparately(value);
    }

    @NotNull
    public DvcsBranchSettings getFavoriteBranchSettings() {
        DvcsBranchSettings dvcsBranchSettings = this.myState.getFavoriteBranchSettings();
        if (dvcsBranchSettings == null) {
            GitVcsSettings.$$$reportNull$$$0(14);
        }
        return dvcsBranchSettings;
    }

    public boolean shouldSetUserNameGlobally() {
        return this.myState.isSetUserNameGlobally();
    }

    public void setUserNameGlobally(boolean value) {
        this.myState.setSetUserNameGlobally(value);
    }

    public boolean shouldSwapSidesInCompareBranches() {
        return this.myState.isSwapSidesInCompareBranches();
    }

    public void setSwapSidesInCompareBranches(boolean value) {
        this.myState.setSwapSidesInCompareBranches(value);
    }

    public boolean shouldAddSuffixToCherryPicksOfPublishedCommits() {
        return this.myState.isAddSuffixToCherryPicksOfPublishedCommits();
    }

    public void setAddSuffixToCherryPicks(boolean value) {
        this.myState.setAddSuffixToCherryPicksOfPublishedCommits(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVcsSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "updateChangesPolicy";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVcsSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncSetting";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentBranchesByRepository";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncomingCheckStrategy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteBranchSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "migrateUpdateIncomingBranchInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSyncSetting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRecentRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setRecentBranchOfRepository";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRecentCommonBranch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setResetMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIncomingCheckStrategy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo
    extends DvcsBranchInfo {
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(@NotNull String repositoryPath, @NotNull String source, @NotNull String targetRemote, @NotNull String targetBranch) {
            if (repositoryPath == null) {
                PushTargetInfo.$$$reportNull$$$0(0);
            }
            if (source == null) {
                PushTargetInfo.$$$reportNull$$$0(1);
            }
            if (targetRemote == null) {
                PushTargetInfo.$$$reportNull$$$0(2);
            }
            if (targetBranch == null) {
                PushTargetInfo.$$$reportNull$$$0(3);
            }
            super(repositoryPath, source);
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushTargetInfo info = (PushTargetInfo)((Object)o);
            if (this.targetRemoteName != null ? !this.targetRemoteName.equals(info.targetRemoteName) : info.targetRemoteName != null) {
                return false;
            }
            return !(this.targetBranchName != null ? !this.targetBranchName.equals(info.targetBranchName) : info.targetBranchName != null);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.targetRemoteName, this.targetBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetRemote";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetBranch";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitVcsSettings$PushTargetInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum UpdateChangesPolicy {
        STASH,
        SHELVE;

    }
}

