/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.actions.GitOperationActionBase;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.util.GitFreezingProcess;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/actions/GitAbortOperationAction;", "Lgit4idea/actions/GitOperationActionBase;", "repositoryState", "Lcom/intellij/dvcs/repo/Repository$State;", "operationName", "", "gitCommand", "Lgit4idea/commands/GitCommand;", "(Lcom/intellij/dvcs/repo/Repository$State;Ljava/lang/String;Lgit4idea/commands/GitCommand;)V", "getOperationName", "()Ljava/lang/String;", "operationNameCapitalised", "confirmAbort", "", "repository", "Lgit4idea/repo/GitRepository;", "doAbort", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performInBackground", "CherryPick", "Merge", "intellij.vcs.git"})
public abstract class GitAbortOperationAction
extends GitOperationActionBase {
    private final String operationNameCapitalised;
    @NotNull
    private final String operationName;
    private final GitCommand gitCommand;

    /*
     * WARNING - void declaration
     */
    @Override
    public void performInBackground(@NotNull GitRepository repository) {
        void title$iv;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        if (!this.confirmAbort(repository)) {
            return;
        }
        String string = "Aborting " + this.operationNameCapitalised + " Process";
        Project project$iv = repository.getProject();
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, this, repository){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ GitAbortOperationAction this$0;
            final /* synthetic */ GitRepository $repository$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.this$0 = gitAbortOperationAction;
                this.$repository$inlined = gitRepository;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                GitAbortOperationAction.access$doAbort(this.this$0, this.$repository$inlined, indicator2);
            }
        });
    }

    private final boolean confirmAbort(GitRepository repository) {
        String title = "Abort " + this.operationNameCapitalised;
        String message = "Abort " + this.operationName + GitUtil.mention(repository) + "?";
        if (Messages.canShowMacSheetPanel()) {
            title = message;
            message = "";
        }
        return DialogManager.showOkCancelDialog(repository.getProject(), message, title, "Abort", CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) == 0;
    }

    private final void doAbort(GitRepository repository, ProgressIndicator indicator) {
        Project project = repository.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"repository.project");
        Project project2 = project;
        new GitFreezingProcess(project2, "abort", new Runnable(this, project2, indicator, repository){
            final /* synthetic */ GitAbortOperationAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ GitRepository $repository;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Closeable closeable = (Closeable)DvcsUtil.workingTreeChangeStarted((Project)this.$project, (String)"Abort");
                boolean bl = false;
                Throwable throwable = null;
                try {
                    Notification notification;
                    AccessToken it = (AccessToken)closeable;
                    boolean bl2 = false;
                    this.$indicator.setText2("git " + GitAbortOperationAction.access$getGitCommand$p(this.this$0).name() + " --abort" + GitUtil.mention(this.$repository));
                    GitLineHandler handler = new GitLineHandler(this.$project, this.$repository.getRoot(), GitAbortOperationAction.access$getGitCommand$p(this.this$0));
                    handler.addParameters("--abort");
                    GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"Git.getInstance().runCommand(handler)");
                    GitCommandResult result2 = gitCommandResult;
                    if (!result2.success()) {
                        Notification notification2 = VcsNotifier.getInstance((Project)this.$project).notifyError(GitAbortOperationAction.access$getOperationNameCapitalised$p(this.this$0) + " Abort Failed", result2.getErrorOutputAsHtmlString());
                        notification = notification2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)notification2, (String)"VcsNotifier.getInstance(\u2026.errorOutputAsHtmlString)");
                    } else {
                        VcsNotifier.getInstance((Project)this.$project).notifySuccess(GitAbortOperationAction.access$getOperationNameCapitalised$p(this.this$0) + " Abort Succeeded");
                        this.$repository.update();
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.$repository.getRoot()});
                        notification = Unit.INSTANCE;
                    }
                    Notification notification3 = notification;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = gitAbortOperationAction;
                this.$project = project;
                this.$indicator = progressIndicator;
                this.$repository = gitRepository;
            }
        }).execute();
    }

    @Override
    @NotNull
    protected final String getOperationName() {
        return this.operationName;
    }

    public GitAbortOperationAction(@NotNull Repository.State repositoryState, @NotNull String operationName, @NotNull GitCommand gitCommand) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryState, (String)"repositoryState");
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        Intrinsics.checkParameterIsNotNull((Object)gitCommand, (String)"gitCommand");
        super(repositoryState);
        this.operationName = operationName;
        this.gitCommand = gitCommand;
        String string = StringUtil.capitalizeWords((String)this.operationName, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.capitalizeWords(operationName, true)");
        this.operationNameCapitalised = string;
    }

    public static final /* synthetic */ void access$doAbort(GitAbortOperationAction $this, GitRepository repository, ProgressIndicator indicator) {
        $this.doAbort(repository, indicator);
    }

    public static final /* synthetic */ GitCommand access$getGitCommand$p(GitAbortOperationAction $this) {
        return $this.gitCommand;
    }

    public static final /* synthetic */ String access$getOperationNameCapitalised$p(GitAbortOperationAction $this) {
        return $this.operationNameCapitalised;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitAbortOperationAction$Merge;", "Lgit4idea/actions/GitAbortOperationAction;", "()V", "intellij.vcs.git"})
    public static final class Merge
    extends GitAbortOperationAction {
        public Merge() {
            GitCommand gitCommand = GitCommand.MERGE;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitCommand, (String)"GitCommand.MERGE");
            super(Repository.State.MERGING, "merge", gitCommand);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitAbortOperationAction$CherryPick;", "Lgit4idea/actions/GitAbortOperationAction;", "()V", "intellij.vcs.git"})
    public static final class CherryPick
    extends GitAbortOperationAction {
        public CherryPick() {
            GitCommand gitCommand = GitCommand.CHERRY_PICK;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitCommand, (String)"GitCommand.CHERRY_PICK");
            super(Repository.State.GRAFTING, "cherry-pick", gitCommand);
        }
    }
}

