/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.util.text.StringKt;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PySdkPopupFactory;
import com.jetbrains.python.configuration.PySdkStatusBarKt;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.sdk.PyRenderedSdkType;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkRenderingKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/configuration/PySdkPopupFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "shortenNameInPopup", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "AddInterpreterAction", "InterpreterSettingsAction", "SwitchToSdkAction", "intellij.python.configure"})
final class PySdkPopupFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Module module;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ListPopup createPopup(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DefaultActionGroup group = new DefaultActionGroup();
        List<Sdk> list = PyConfigurableInterpreterList.getInstance(this.project).getAllPythonSdks(this.project);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"PyConfigurableInterprete\u2026getAllPythonSdks(project)");
        Map<PyRenderedSdkType, List<Sdk>> moduleSdksByTypes2 = PySdkRenderingKt.groupModuleSdksByTypes(list, this.module, (Function1<? super Sdk, Boolean>)((Function1)createPopup.moduleSdksByTypes.1.INSTANCE));
        Object $this$forEachIndexed$iv = PyRenderedSdkType.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (PyRenderedSdkType item$iv : $this$forEachIndexed$iv) {
            Collection<SwitchToSdkAction> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void type;
            int n = index$iv++;
            PyRenderedSdkType pyRenderedSdkType = item$iv;
            int index = n;
            boolean bl = false;
            Object object = moduleSdksByTypes2;
            boolean bl2 = false;
            Map<PyRenderedSdkType, List<Sdk>> map2 = object;
            boolean bl3 = false;
            if (!map2.containsKey(type)) continue;
            if (index != 0) {
                group.addSeparator();
            }
            object = (Iterable)MapsKt.getValue(moduleSdksByTypes2, (Object)type);
            DefaultActionGroup defaultActionGroup = group;
            boolean $i$f$map = false;
            map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Sdk sdk = (Sdk)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                SwitchToSdkAction switchToSdkAction = new SwitchToSdkAction((Sdk)it);
                collection.add(switchToSdkAction);
            }
            collection = (List)destination$iv$iv;
            defaultActionGroup.addAll((Collection)collection);
        }
        $this$forEachIndexed$iv = moduleSdksByTypes2;
        boolean bl = false;
        if (!$this$forEachIndexed$iv.isEmpty()) {
            group.addSeparator();
        }
        group.add((AnAction)new InterpreterSettingsAction());
        group.add((AnAction)new AddInterpreterAction());
        Sdk currentSdk = PythonSdkType.findPythonSdk(this.module);
        return JBPopupFactory.getInstance().createActionGroupPopup("Project Interpreter", (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, -1, (Condition)new Condition<AnAction>(currentSdk){
            final /* synthetic */ Sdk $currentSdk;

            public final boolean value(AnAction it) {
                return it instanceof SwitchToSdkAction && Intrinsics.areEqual((Object)((SwitchToSdkAction)it).getSdk(), (Object)this.$currentSdk);
            }
            {
                this.$currentSdk = sdk;
            }
        }, null);
    }

    private final String shortenNameInPopup(Sdk sdk) {
        return StringKt.trimMiddle$default((String)PySdkStatusBarKt.access$name(sdk), (int)100, (boolean)false, (int)2, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public PySdkPopupFactory(@NotNull Project project, @NotNull Module module2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        this.project = project;
        this.module = module2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/configuration/PySdkPopupFactory$SwitchToSdkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/jetbrains/python/configuration/PySdkPopupFactory;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.configure"})
    private final class SwitchToSdkAction
    extends DumbAwareAction {
        @NotNull
        private final Sdk sdk;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            PySdkExtKt.setPythonSdk(PySdkPopupFactory.this.getProject(), this.sdk);
            PySdkExtKt.setPythonSdk(PySdkPopupFactory.this.getModule(), this.sdk);
        }

        @NotNull
        public final Sdk getSdk() {
            return this.sdk;
        }

        public SwitchToSdkAction(Sdk sdk) {
            Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
            this.sdk = sdk;
            Presentation presentation = this.getTemplatePresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
            Presentation presentation2 = presentation;
            presentation2.setText(PySdkPopupFactory.this.shortenNameInPopup(this.sdk), false);
            presentation2.setDescription("Switch to " + PySdkStatusBarKt.access$shortenNameAndPath(this.sdk) + ']');
            presentation2.setIcon(PySdkRenderingKt.icon(this.sdk));
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/configuration/PySdkPopupFactory$InterpreterSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/jetbrains/python/configuration/PySdkPopupFactory;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.configure"})
    private final class InterpreterSettingsAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            PyInterpreterInspection.ConfigureInterpreterFix.showProjectInterpreterDialog(PySdkPopupFactory.this.getProject());
        }

        public InterpreterSettingsAction() {
            super("Interpreter Settings...");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/configuration/PySdkPopupFactory$AddInterpreterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/jetbrains/python/configuration/PySdkPopupFactory;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.configure"})
    private final class AddInterpreterAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(PySdkPopupFactory.this.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(project)");
            ProjectSdksModel model = pyConfigurableInterpreterList.getModel();
            Project project = PySdkPopupFactory.this.getProject();
            Module module2 = PySdkPopupFactory.this.getModule();
            ProjectSdksModel projectSdksModel = model;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectSdksModel, (String)"model");
            Object[] objectArray = projectSdksModel.getSdks();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"model.sdks");
            PyAddSdkDialog.Companion.show(project, module2, ArraysKt.asList((Object[])objectArray), new Consumer<Sdk>(model){
                final /* synthetic */ ProjectSdksModel $model;

                public final void accept(@Nullable Sdk it) {
                    if (it != null && this.$model.findSdk(it.getName()) == null) {
                        this.$model.addSdk(it);
                        this.$model.apply();
                    }
                }
                {
                    this.$model = projectSdksModel;
                }
            });
        }

        public AddInterpreterAction() {
            super("Add Interpreter...");
        }
    }
}

