/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CachedValueStabilityChecker {
    private static final Logger LOG = Logger.getInstance(CachedValueStabilityChecker.class);
    private static final Set<String> ourReportedKeys = ContainerUtil.newConcurrentSet();
    private static final ConcurrentMap<Class, List<Field>> ourFieldCache = ConcurrentFactoryMap.createMap(ReflectionUtil::collectFields);
    private static final boolean DO_CHECKS = CachedValueStabilityChecker.shouldDoChecks();

    CachedValueStabilityChecker() {
    }

    private static boolean shouldDoChecks() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            return true;
        }
        if (SystemInfo.IS_AT_LEAST_JAVA9) {
            return false;
        }
        return app.isInternal() || app.isEAP();
    }

    static void checkProvidersEquivalent(CachedValueProvider<?> p1, CachedValueProvider<?> p2, Key<?> key) {
        if (p1 == p2 || !DO_CHECKS || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        if (p1.getClass() != p2.getClass()) {
            if (!CachedValueStabilityChecker.seemConcurrentlyCreatedLambdas(p1.getClass(), p2.getClass())) {
                CachedValueStabilityChecker.complain("Incorrect CachedValue use: different providers supplied for the same key: " + p1 + " and " + p2, key.toString());
            }
            return;
        }
        CachedValueStabilityChecker.checkFieldEquivalence(p1, p2, key.toString(), 0);
    }

    private static boolean seemConcurrentlyCreatedLambdas(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return false;
        }
        String name1 = c1.getName();
        String name2 = c2.getName();
        int index = name1.indexOf("$$Lambda");
        return index > 0 && index == name2.indexOf("$$Lambda") && name2.startsWith(name1.substring(0, index)) && ((List)ourFieldCache.get(c1)).size() == ((List)ourFieldCache.get(c2)).size();
    }

    private static boolean checkFieldEquivalence(Object o1, Object o2, String key, int depth) {
        if (depth > 100) {
            CachedValueStabilityChecker.complain("Too deep function delegation inside CachedValueProvider. If you have cyclic dependencies, please remove them.", key);
            return false;
        }
        for (Field field : (List)ourFieldCache.get(o1.getClass())) {
            Object v2;
            Object v1;
            try {
                field.setAccessible(true);
                v1 = field.get(o1);
                v2 = field.get(o2);
            }
            catch (Exception e) {
                CachedValueStabilityChecker.complain("Please allow full reflective access", key);
                return false;
            }
            if (CachedValueStabilityChecker.areEqual(v1, v2) || v1 != null && v2 != null && CachedValueStabilityChecker.seemConcurrentlyCreatedLambdas(v1.getClass(), v2.getClass())) continue;
            if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && CachedValueStabilityChecker.shouldGoDeeper(v1)) {
                if (CachedValueStabilityChecker.checkFieldEquivalence(v1, v2, key, depth + 1)) continue;
                return false;
            }
            CachedValueStabilityChecker.complain(CachedValueStabilityChecker.nonEquivalence(o1.getClass(), field, v1, v2), key);
            return false;
        }
        return true;
    }

    private static boolean areEqual(Object v1, Object v2) {
        if (Objects.equals(v1, v2)) {
            return true;
        }
        if (v1 instanceof Object[] && v2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])v1, (Object[])v2);
        }
        return false;
    }

    @NotNull
    private static String nonEquivalence(Class<?> objectClass, Field field, @Nullable Object v1, @Nullable Object v2) {
        String string = "Incorrect CachedValue use: same CV with different captured context, this can cause unstable results and invalid PSI access.\nField " + field.getName() + " in " + objectClass + " has non-equivalent values:\n  " + v1 + (v1 == null ? "" : " (" + v1.getClass().getName() + ")") + " and\n  " + v2 + (v2 == null ? "" : " (" + v2.getClass().getName() + ")") + "\nEither make `equals()` hold for these values, or avoid this dependency, e.g. by extracting CV provider into a static method.";
        if (string == null) {
            CachedValueStabilityChecker.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void complain(String message, String key) {
        if (ourReportedKeys.add(key)) {
            LOG.error(message);
        }
    }

    private static boolean shouldGoDeeper(Object o) {
        if (o instanceof CachedValueProvider) {
            return true;
        }
        Class<?> clazz = o.getClass();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null) {
            return false;
        }
        if ((o instanceof Computable || o instanceof Function || o instanceof java.util.function.Function) && Object.class.equals(clazz.getSuperclass())) {
            return true;
        }
        return "kotlin.jvm.internal.Lambda".equals(superclass.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CachedValueStabilityChecker", "nonEquivalence"));
    }
}

