/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.injection.ReferenceInjector;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectionResult
implements Getter<InjectionResult> {
    @Nullable
    final List<? extends PsiFile> files;
    @Nullable
    final List<? extends Pair<ReferenceInjector, Place>> references;
    private final long myModificationCount;

    InjectionResult(@NotNull PsiFile hostFile, @Nullable List<? extends PsiFile> files2, @Nullable List<? extends Pair<ReferenceInjector, Place>> references) {
        if (hostFile == null) {
            InjectionResult.$$$reportNull$$$0(0);
        }
        this.files = files2;
        this.references = references;
        this.myModificationCount = InjectionResult.calcModCount(hostFile);
    }

    public InjectionResult get() {
        return this;
    }

    boolean isEmpty() {
        return this.files == null && this.references == null;
    }

    boolean isValid() {
        block3: {
            block2: {
                if (this.files == null) break block2;
                for (PsiFile psiFile : this.files) {
                    if (psiFile.isValid()) continue;
                    return false;
                }
                break block3;
            }
            if (this.references == null) break block3;
            for (Pair<ReferenceInjector, Place> pair : this.references) {
                Place place = (Place)((Object)pair.getSecond());
                if (place.isValid()) continue;
                return false;
            }
        }
        return true;
    }

    boolean isModCountUpToDate(@NotNull PsiFile hostPsiFile) {
        if (hostPsiFile == null) {
            InjectionResult.$$$reportNull$$$0(1);
        }
        return this.myModificationCount == InjectionResult.calcModCount(hostPsiFile);
    }

    private static long calcModCount(@NotNull PsiFile hostPsiFile) {
        if (hostPsiFile == null) {
            InjectionResult.$$$reportNull$$$0(2);
        }
        return (hostPsiFile.getModificationStamp() << 32) + hostPsiFile.getManager().getModificationTracker().getModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectionResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModCountUpToDate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calcModCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

