/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.FormattingMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import org.jetbrains.annotations.NotNull;

public class FormatterBasedIndentAdjuster {
    private static final int MAX_SYNCHRONOUS_ADJUSTMENT_DOC_SIZE = 100000;

    private FormatterBasedIndentAdjuster() {
    }

    public static void scheduleIndentAdjustment(@NotNull Project myProject, @NotNull Document myDocument, int myOffset) {
        if (myProject == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(0);
        }
        if (myDocument == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(1);
        }
        IndentAdjusterRunnable fixer = new IndentAdjusterRunnable(myProject, myDocument, myOffset);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)myProject);
        if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(myDocument)) {
            documentManager.commitDocument(myDocument);
            fixer.run();
        } else {
            documentManager.performLaterWhenAllCommitted((Runnable)fixer);
        }
    }

    private static boolean isSynchronousAdjustment(@NotNull Document document) {
        if (document == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(2);
        }
        return ApplicationManager.getApplication().isUnitTestMode() || document.getTextLength() <= 100000;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDocument";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedIndentAdjuster";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleIndentAdjustment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSynchronousAdjustment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IndentAdjusterRunnable
    implements Runnable {
        private final Project myProject;
        private final int myLine;
        private final Document myDocument;

        public IndentAdjusterRunnable(Project project, Document document, int offset) {
            this.myProject = project;
            this.myDocument = document;
            this.myLine = this.myDocument.getLineNumber(offset);
        }

        @Override
        public void run() {
            int lineStart = this.myDocument.getLineStartOffset(this.myLine);
            CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
                if (codeStyleManager instanceof FormattingModeAwareIndentAdjuster) {
                    ((FormattingModeAwareIndentAdjuster)codeStyleManager).adjustLineIndent(this.myDocument, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER);
                }
            }));
        }
    }
}

