/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ReprocessContentRootDataActivity;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/ReprocessContentRootDataActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
public final class ReprocessContentRootDataActivity
implements StartupActivity,
DumbAware {
    private final Logger LOG;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        if (ExternalSystemUtil.isNewProject(project)) {
            this.LOG.info("Ignored reprocess of content root data service for new projects");
            return;
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        ContentRootDataService service = new ContentRootDataService();
        ExternalProjectsManagerImpl externalProjectsManager = ExternalProjectsManagerImpl.getInstance(project);
        externalProjectsManager.init();
        externalProjectsManager.runWhenInitialized(new Runnable(project, dataManager, service){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectDataManager $dataManager;
            final /* synthetic */ ContentRootDataService $service;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void run() {
                boolean haveModulesToProcess;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Module[] moduleArray2 = moduleArray;
                boolean bl = false;
                Module[] moduleArray3 = moduleArray2;
                boolean bl2 = false;
                boolean bl3 = haveModulesToProcess = !(moduleArray3.length == 0);
                if (!haveModulesToProcess) {
                    return;
                }
                Lazy modifiableModelsProvider2 = LazyKt.lazy((Function0)((Function0)new Function0<IdeModifiableModelsProviderImpl>(this){
                    final /* synthetic */ runActivity.1 this$0;

                    @NotNull
                    public final IdeModifiableModelsProviderImpl invoke() {
                        return new IdeModifiableModelsProviderImpl(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                try {
                    void $this$mapTo$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Object list$iv$iv;
                    ExternalSystemManager it;
                    Iterable $this$flatMapTo$iv$iv;
                    List list2 = ExternalSystemApiUtil.getAllManagers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ExternalSystemApiUtil.getAllManagers()");
                    Iterable $this$flatMap$iv = list2;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (ExternalSystemManager)element$iv$iv;
                        boolean bl4 = false;
                        list$iv$iv = this.$dataManager.getExternalProjectsData(this.$project, it.getSystemId());
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator<T> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    list$iv$iv = $this$forEach$iv$iv$iv.iterator();
                    while (list$iv$iv.hasNext()) {
                        DataNode dataNode;
                        E element$iv$iv$iv;
                        E element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                        boolean bl5 = false;
                        ExternalProjectInfo it2 = (ExternalProjectInfo)element$iv$iv;
                        boolean bl6 = false;
                        ExternalProjectInfo externalProjectInfo = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)externalProjectInfo, (String)"it");
                        if (externalProjectInfo.getExternalProjectStructure() == null) continue;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        DataNode it$iv$iv = dataNode;
                        boolean bl9 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        list$iv$iv = (DataNode)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl10 = false;
                        Collection collection2 = ExternalSystemApiUtil.findAllRecursively((DataNode)it, (Key)ProjectKeys.CONTENT_ROOT);
                        collection.add(collection2);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv : $this$forEach$iv) {
                        Collection it3 = (Collection)element$iv;
                        boolean bl11 = false;
                        this.$service.importData(it3, null, this.$project, (IdeModifiableModelsProvider)modifiableModelsProvider2.getValue());
                    }
                }
                catch (Throwable throwable) {
                    if (modifiableModelsProvider2.isInitialized()) {
                        ExternalSystemApiUtil.doWriteAction((Runnable)new Runnable(this, modifiableModelsProvider2){
                            final /* synthetic */ runActivity.1 this$0;
                            final /* synthetic */ Lazy $modifiableModelsProvider;

                            public final void run() {
                                if (!this.this$0.$project.isDisposed()) {
                                    ((IdeModifiableModelsProviderImpl)this.$modifiableModelsProvider.getValue()).commit();
                                } else {
                                    ((IdeModifiableModelsProviderImpl)this.$modifiableModelsProvider.getValue()).dispose();
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$modifiableModelsProvider = lazy;
                            }
                        });
                    }
                    throw throwable;
                }
                if (modifiableModelsProvider2.isInitialized()) {
                    ExternalSystemApiUtil.doWriteAction((Runnable)new /* invalid duplicate definition of identical inner class */);
                }
            }
            {
                this.$project = project;
                this.$dataManager = projectDataManager;
                this.$service = contentRootDataService;
            }
        });
    }

    public ReprocessContentRootDataActivity() {
        Logger logger = Logger.getInstance(ReprocessContentRootDataActivity.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Repro\u2026DataActivity::class.java)");
        this.LOG = logger;
    }
}

