/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class TextLayoutCache
implements PrioritizedInternalDocumentListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(TextLayoutCache.class);
    private static final int MAX_CHUNKS_IN_ACTIVE_EDITOR = 1000;
    private static final int MAX_CHUNKS_IN_INACTIVE_EDITOR = 10;
    private final EditorView myView;
    private final Document myDocument;
    private final LineLayout myBidiNotRequiredMarker;
    private ArrayList<LineLayout> myLines = new ArrayList();
    private int myDocumentChangeOldEndLine;
    private Map<LineLayout.Chunk, Object> myLaidOutChunks = new LinkedHashMap<LineLayout.Chunk, Object>(1000, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry<LineLayout.Chunk, Object> eldest) {
            if (this.size() > TextLayoutCache.this.getChunkCacheSizeLimit()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clearing chunk for " + TextLayoutCache.this.myView.getEditor().getVirtualFile());
                }
                eldest.getKey().clearCache();
                return true;
            }
            return false;
        }
    };

    TextLayoutCache(EditorView view) {
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        this.myDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
        this.myBidiNotRequiredMarker = LineLayout.create(view, "", 0);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)view.getEditor().getContentComponent(), (Activatable)new Activatable.Adapter(){

            public void hideNotify() {
                TextLayoutCache.this.trimChunkCache();
            }
        }));
    }

    @Override
    public int getPriority() {
        return 70;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            TextLayoutCache.$$$reportNull$$$0(0);
        }
        this.myDocumentChangeOldEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getOldLength());
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            TextLayoutCache.$$$reportNull$$$0(1);
        }
        int startLine = this.myDocument.getLineNumber(event.getOffset());
        int newEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getNewLength());
        this.invalidateLines(startLine, this.myDocumentChangeOldEndLine, newEndLine, true, LineLayout.isBidiLayoutRequired(event.getNewFragment()));
        if (this.myLines.size() != this.myDocument.getLineCount()) {
            LOG.error("Error updating text layout cache after " + event, new Attachment[]{new Attachment("editorState.txt", this.myView.getEditor().dumpState())});
            this.resetToDocumentSize(true);
        }
    }

    @Override
    public void moveTextHappened(@NotNull Document document, int start2, int end, int base) {
        if (document == null) {
            TextLayoutCache.$$$reportNull$$$0(2);
        }
        int insertedStartLine = this.myDocument.getLineNumber(base);
        int insertedEndLine = this.myDocument.getLineNumber(base + (end - start2));
        this.invalidateLines(insertedStartLine, insertedEndLine);
    }

    public void dispose() {
        this.myLines = null;
        this.myLaidOutChunks = null;
    }

    private int getAdjustedLineNumber(int offset) {
        return this.myDocument.getTextLength() == 0 ? -1 : this.myDocument.getLineNumber(offset);
    }

    void resetToDocumentSize(boolean documentChangedWithoutNotification) {
        this.checkDisposed();
        this.invalidateLines(0, this.myLines.size() - 1, this.myDocument.getLineCount() - 1, documentChangedWithoutNotification, documentChangedWithoutNotification);
        if (this.myLines.size() != this.myDocument.getLineCount()) {
            LOG.error("Error resetting text layout cache", new Attachment[]{new Attachment("editorState.txt", this.myView.getEditor().dumpState())});
        }
    }

    void invalidateLines(int startLine, int endLine) {
        this.invalidateLines(startLine, endLine, endLine, false, false);
    }

    private void invalidateLines(int startLine, int oldEndLine, int newEndLine, boolean textChanged, boolean bidiRequiredForNewText) {
        this.checkDisposed();
        if (textChanged) {
            LineLayout lastOldLine;
            LineLayout firstOldLine = startLine >= 0 && startLine < this.myLines.size() ? this.myLines.get(startLine) : null;
            LineLayout lineLayout = lastOldLine = oldEndLine >= 0 && oldEndLine < this.myLines.size() ? this.myLines.get(oldEndLine) : null;
            if (firstOldLine == null || lastOldLine == null || !firstOldLine.isLtr() || !lastOldLine.isLtr()) {
                bidiRequiredForNewText = true;
            }
        }
        int endLine = Math.min(oldEndLine, newEndLine);
        for (int line2 = startLine; line2 <= endLine; ++line2) {
            LineLayout lineLayout = this.myLines.get(line2);
            if (lineLayout == null) continue;
            this.removeChunksFromCache(lineLayout);
            this.myLines.set(line2, textChanged && bidiRequiredForNewText || !lineLayout.isLtr() ? null : this.myBidiNotRequiredMarker);
        }
        if (oldEndLine < newEndLine) {
            this.myLines.addAll(oldEndLine + 1, Collections.nCopies(newEndLine - oldEndLine, null));
        } else if (oldEndLine > newEndLine) {
            List<LineLayout> layouts = this.myLines.subList(newEndLine + 1, oldEndLine + 1);
            for (LineLayout layout : layouts) {
                if (layout == null) continue;
                this.removeChunksFromCache(layout);
            }
            layouts.clear();
        }
    }

    @NotNull
    LineLayout getLineLayout(int line2) {
        LineLayout result2;
        this.checkDisposed();
        if (line2 >= this.myLines.size()) {
            LOG.error("Unexpected cache state", new Attachment[]{new Attachment("editorState.txt", this.myView.getEditor().dumpState())});
        }
        if ((result2 = this.myLines.get(line2)) == null || result2 == this.myBidiNotRequiredMarker) {
            result2 = LineLayout.create(this.myView, line2, result2 == this.myBidiNotRequiredMarker);
            this.myLines.set(line2, result2);
        }
        LineLayout lineLayout = result2;
        if (lineLayout == null) {
            TextLayoutCache.$$$reportNull$$$0(3);
        }
        return lineLayout;
    }

    boolean hasCachedLayoutFor(int line2) {
        LineLayout layout = this.myLines.get(line2);
        return layout != null && layout != this.myBidiNotRequiredMarker;
    }

    private int getChunkCacheSizeLimit() {
        return this.myView.getEditor().getContentComponent().isShowing() ? 1000 : 10;
    }

    void onChunkAccess(LineLayout.Chunk chunk) {
        this.myLaidOutChunks.put(chunk, this);
    }

    private void removeChunksFromCache(LineLayout layout) {
        layout.getChunksInLogicalOrder().forEach(this.myLaidOutChunks::remove);
    }

    private void trimChunkCache() {
        int limit = this.getChunkCacheSizeLimit();
        if (this.myLaidOutChunks.size() > limit) {
            Iterator<LineLayout.Chunk> it = this.myLaidOutChunks.keySet().iterator();
            while (this.myLaidOutChunks.size() > limit) {
                LineLayout.Chunk chunk = it.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clearing chunk for " + this.myView.getEditor().getVirtualFile());
                }
                chunk.clearCache();
                it.remove();
            }
        }
    }

    private void checkDisposed() {
        if (this.myLines == null) {
            this.myView.getEditor().throwDisposalError("Editor is already disposed");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/TextLayoutCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/TextLayoutCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveTextHappened";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

