/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiffRequestProcessor
extends DiffRequestProcessor {
    @NotNull
    private final List<? extends DiffHyperlink> myRequests;
    private int myIndex;

    public TestDiffRequestProcessor(@Nullable Project project, @NotNull List<? extends DiffHyperlink> requests, int index) {
        if (requests == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        super(project, "TestsFiledAssertions");
        this.myRequests = requests;
        this.myIndex = index;
        this.putContextUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, true);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.applyRequest(this.loadRequest(), force, scrollToChangePolicy);
    }

    @NotNull
    private DiffRequest loadRequest() {
        SimpleDiffRequest simpleDiffRequest;
        block5: {
            if (this.myIndex < 0 || this.myIndex >= this.myRequests.size()) {
                NoDiffRequest noDiffRequest = NoDiffRequest.INSTANCE;
                if (noDiffRequest == null) {
                    TestDiffRequestProcessor.$$$reportNull$$$0(1);
                }
                return noDiffRequest;
            }
            DiffHyperlink hyperlink = this.myRequests.get(this.myIndex);
            try {
                String windowTitle = hyperlink.getDiffTitle();
                String text1 = hyperlink.getLeft();
                String text2 = hyperlink.getRight();
                VirtualFile file1 = TestDiffRequestProcessor.findFile(hyperlink.getFilePath());
                VirtualFile file2 = TestDiffRequestProcessor.findFile(hyperlink.getActualFilePath());
                DiffContent content1 = TestDiffRequestProcessor.createContentWithTitle(this.getProject(), text1, file1, file2);
                DiffContent content2 = TestDiffRequestProcessor.createContentWithTitle(this.getProject(), text2, file2, file1);
                String title1 = TestDiffRequestProcessor.getContentTitle("diff.content.expected.title", file1);
                String title2 = TestDiffRequestProcessor.getContentTitle("diff.content.actual.title", file2);
                simpleDiffRequest = new SimpleDiffRequest(windowTitle, content1, content2, title1, title2);
                if (simpleDiffRequest != null) break block5;
            }
            catch (Exception e) {
                ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((Throwable)e);
                if (errorDiffRequest == null) {
                    TestDiffRequestProcessor.$$$reportNull$$$0(3);
                }
                return errorDiffRequest;
            }
            TestDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return simpleDiffRequest;
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String path) {
        return path != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(path) : null;
    }

    @NotNull
    private static DiffContent createContentWithTitle(@Nullable Project project, @NotNull String content2, @Nullable VirtualFile contentFile, @Nullable VirtualFile highlightFile) {
        if (content2 == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        if (contentFile != null) {
            DiffContent diffContent = DiffContentFactory.getInstance().create(project, contentFile);
            if (diffContent == null) {
                TestDiffRequestProcessor.$$$reportNull$$$0(5);
            }
            return diffContent;
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, content2, highlightFile);
        if (documentContent == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(6);
        }
        return documentContent;
    }

    @NotNull
    private static String getContentTitle(@NotNull String titleKey, @Nullable VirtualFile file2) {
        if (titleKey == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(7);
        }
        String title = ExecutionBundle.message((String)titleKey, (Object[])new Object[0]);
        if (file2 != null) {
            title = title + " (" + file2.getPresentableUrl() + ")";
        }
        String string = title;
        if (string == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected boolean hasNextChange() {
        return this.myIndex + 1 < this.myRequests.size();
    }

    @Override
    protected boolean hasPrevChange() {
        return this.myIndex > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ++this.myIndex;
        if (this.myIndex >= this.myRequests.size()) {
            this.myIndex = 0;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        --this.myIndex;
        if (this.myIndex < 0) {
            this.myIndex = this.myRequests.size() - 1;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequests.size() > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRequest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentWithTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createContentWithTitle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContentTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

