/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.execution.console.ConsoleHistoryModelProvider;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.HistoryRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TObjectHashingStrategy;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleHistoryController
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.console.ConsoleHistoryController");
    private static final Map<LanguageConsoleView, ConsoleHistoryController> ourControllers = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private final LanguageConsoleView myConsole;
    private final AnAction myHistoryNext;
    private final AnAction myHistoryPrev;
    private final AnAction myBrowseHistory;
    private boolean myMultiline;
    private ModelHelper myHelper;
    private long myLastSaveStamp;

    @Deprecated
    public ConsoleHistoryController(@NotNull String type, @Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (type == null) {
            ConsoleHistoryController.$$$reportNull$$$0(0);
        }
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(1);
        }
        this(new ConsoleRootType(type, null){}, persistenceId, console);
    }

    public ConsoleHistoryController(@NotNull ConsoleRootType rootType, @Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(2);
        }
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(3);
        }
        this(rootType, ConsoleHistoryController.fixNullPersistenceId(persistenceId, console), console, ConsoleHistoryModelProvider.findModelForConsole(ConsoleHistoryController.fixNullPersistenceId(persistenceId, console), console));
    }

    private ConsoleHistoryController(@NotNull ConsoleRootType rootType, @NotNull String persistenceId, @NotNull LanguageConsoleView console, @NotNull ConsoleHistoryModel model2) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(4);
        }
        if (persistenceId == null) {
            ConsoleHistoryController.$$$reportNull$$$0(5);
        }
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(6);
        }
        if (model2 == null) {
            ConsoleHistoryController.$$$reportNull$$$0(7);
        }
        this.myHistoryNext = new MyAction(true, ConsoleHistoryController.getKeystrokesUpDown(true));
        this.myHistoryPrev = new MyAction(false, ConsoleHistoryController.getKeystrokesUpDown(false));
        this.myBrowseHistory = new MyBrowseAction();
        this.myHelper = new ModelHelper(rootType, persistenceId, model2);
        this.myConsole = console;
    }

    public void setModel(@NotNull ConsoleHistoryModel model2) {
        if (model2 == null) {
            ConsoleHistoryController.$$$reportNull$$$0(8);
        }
        this.myHelper = new ModelHelper(this.myHelper.myRootType, this.myHelper.myId, model2);
    }

    public void dispose() {
    }

    public static ConsoleHistoryController getController(@NotNull LanguageConsoleView console) {
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(9);
        }
        return ourControllers.get(console);
    }

    public static void addToHistory(@NotNull LanguageConsoleView consoleView, @Nullable String command) {
        ConsoleHistoryController controller;
        if (consoleView == null) {
            ConsoleHistoryController.$$$reportNull$$$0(10);
        }
        if ((controller = ConsoleHistoryController.getController(consoleView)) != null) {
            controller.addToHistory(command);
        }
    }

    public void addToHistory(@Nullable String command) {
        this.getModel().addToHistory(command);
    }

    public boolean hasHistory() {
        return !this.getModel().isEmpty();
    }

    @NotNull
    private static String fixNullPersistenceId(@Nullable String persistenceId, @NotNull LanguageConsoleView console) {
        if (console == null) {
            ConsoleHistoryController.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)persistenceId)) {
            String string = persistenceId;
            if (string == null) {
                ConsoleHistoryController.$$$reportNull$$$0(12);
            }
            return string;
        }
        String url = console.getProject().getPresentableUrl();
        String string = StringUtil.isNotEmpty((String)url) ? url : "default";
        if (string == null) {
            ConsoleHistoryController.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isMultiline() {
        return this.myMultiline;
    }

    public ConsoleHistoryController setMultiline(boolean multiline) {
        this.myMultiline = multiline;
        return this;
    }

    ConsoleHistoryModel getModel() {
        return this.myHelper.getModel();
    }

    public void install() {
        MessageBusConnection busConnection = this.myConsole.getProject().getMessageBus().connect((Disposable)this.myConsole);
        busConnection.subscribe(ProjectEx.ProjectSaved.TOPIC, (Object)new ProjectEx.ProjectSaved(){

            @Override
            public void duringSave(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                ConsoleHistoryController.this.saveHistory();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/ConsoleHistoryController$2", "duringSave"));
            }
        });
        busConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void beforeDocumentSaving(@NotNull Document document) {
                if (document == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (document == ConsoleHistoryController.this.myConsole.getEditorDocument()) {
                    ConsoleHistoryController.this.saveHistory();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/execution/console/ConsoleHistoryController$3", "beforeDocumentSaving"));
            }
        });
        ConsoleHistoryController original = ourControllers.put(this.myConsole, this);
        LOG.assertTrue(original == null, (Object)("History controller already installed for: " + this.myConsole.getTitle()));
        Disposer.register((Disposable)this.myConsole, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                ConsoleHistoryController controller = ConsoleHistoryController.getController(ConsoleHistoryController.this.myConsole);
                if (controller == ConsoleHistoryController.this) {
                    ourControllers.remove(ConsoleHistoryController.this.myConsole);
                }
                ConsoleHistoryController.this.saveHistory();
            }
        });
        if (this.myHelper.getModel().getHistorySize() == 0) {
            this.loadHistory(this.myHelper.getId());
        }
        this.configureActions();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    private long getCurrentTimeStamp() {
        return this.getModel().getModificationCount() + this.myConsole.getEditorDocument().getModificationStamp();
    }

    private void configureActions() {
        EmptyAction.setupAction((AnAction)this.myHistoryNext, (String)"Console.History.Next", null);
        EmptyAction.setupAction((AnAction)this.myHistoryPrev, (String)"Console.History.Previous", null);
        EmptyAction.setupAction((AnAction)this.myBrowseHistory, (String)"Console.History.Browse", null);
        if (!this.myMultiline) {
            ConsoleHistoryController.addShortcuts(this.myHistoryNext, ConsoleHistoryController.getShortcutUpDown(true));
            ConsoleHistoryController.addShortcuts(this.myHistoryPrev, ConsoleHistoryController.getShortcutUpDown(false));
        }
        this.myHistoryNext.registerCustomShortcutSet(this.myHistoryNext.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myHistoryPrev.registerCustomShortcutSet(this.myHistoryPrev.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
        this.myBrowseHistory.registerCustomShortcutSet(this.myBrowseHistory.getShortcutSet(), this.myConsole.getCurrentEditor().getComponent());
    }

    public boolean loadHistory(String id) {
        CharSequence prev = this.myHelper.getContent();
        boolean result2 = this.myHelper.loadHistory(id);
        CharSequence userValue = this.myHelper.getContent();
        if (prev != userValue && userValue != null) {
            this.setConsoleText(new ConsoleHistoryModel.Entry(userValue, -1), false, false);
        }
        return result2;
    }

    private void saveHistory() {
        if (this.myLastSaveStamp == this.getCurrentTimeStamp()) {
            return;
        }
        this.myHelper.setContent(this.myConsole.getEditorDocument().getText());
        this.myHelper.saveHistory();
        this.myLastSaveStamp = this.getCurrentTimeStamp();
    }

    public AnAction getHistoryNext() {
        return this.myHistoryNext;
    }

    public AnAction getHistoryPrev() {
        return this.myHistoryPrev;
    }

    public AnAction getBrowseHistory() {
        return this.myBrowseHistory;
    }

    protected void setConsoleText(ConsoleHistoryModel.Entry command, boolean storeUserText, boolean regularMode) {
        if (regularMode && this.myMultiline && StringUtil.isEmptyOrSpaces((CharSequence)command.getText())) {
            return;
        }
        EditorEx editor = this.myConsole.getCurrentEditor();
        Document document = editor.getDocument();
        WriteCommandAction.writeCommandAction((Project)this.myConsole.getProject()).run(() -> {
            int offset;
            CharSequence text2;
            if (storeUserText) {
                text2 = document.getText();
                if (Comparing.equal((CharSequence)command.getText(), (CharSequence)text2) && this.myHelper.getContent() != null) {
                    return;
                }
                this.myHelper.setContent((String)text2);
                this.myHelper.getModel().setContent((String)text2);
            }
            text2 = (CharSequence)ObjectUtils.chooseNotNull((Object)command.getText(), (Object)"");
            if (regularMode) {
                if (this.myMultiline) {
                    offset = this.insertTextMultiline(text2, editor, document);
                } else {
                    document.setText(text2);
                    offset = command.getOffset() == -1 ? document.getTextLength() : command.getOffset();
                }
            } else {
                offset = 0;
                try {
                    document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
                    document.setText(text2);
                }
                finally {
                    document.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
                }
            }
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        });
    }

    protected int insertTextMultiline(CharSequence text2, Editor editor, Document document) {
        TextRange selection = EditorUtil.getSelectionInAnyMode(editor);
        int start2 = document.getLineStartOffset(document.getLineNumber(selection.getStartOffset()));
        int end = document.getLineEndOffset(document.getLineNumber(selection.getEndOffset()));
        document.replaceString(start2, end, text2);
        editor.getSelectionModel().setSelection(start2, start2 + text2.length());
        return start2;
    }

    private boolean canMoveInEditor(boolean next) {
        EditorEx consoleEditor = this.myConsole.getCurrentEditor();
        Document document = consoleEditor.getDocument();
        CaretModel caretModel = consoleEditor.getCaretModel();
        if (LookupManager.getActiveLookup(consoleEditor) != null) {
            return false;
        }
        if (next) {
            return document.getLineNumber(caretModel.getOffset()) == 0;
        }
        int lineCount = document.getLineCount();
        return !(lineCount != 0 && document.getLineNumber(caretModel.getOffset()) != lineCount - 1 || !StringUtil.isEmptyOrSpaces((String)document.getText().substring(caretModel.getOffset())) && !this.myHelper.getModel().prevOnLastLine());
    }

    @NotNull
    private static String getHistoryName(@NotNull ConsoleRootType rootType, @NotNull String id) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(14);
        }
        if (id == null) {
            ConsoleHistoryController.$$$reportNull$$$0(15);
        }
        String string = rootType.getConsoleTypeId() + "/" + PathUtil.makeFileName((String)rootType.getHistoryPathName(id), (String)rootType.getDefaultFileExtension());
        if (string == null) {
            ConsoleHistoryController.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getContentFile(@NotNull ConsoleRootType rootType, @NotNull String id, ScratchFileService.Option option) {
        if (rootType == null) {
            ConsoleHistoryController.$$$reportNull$$$0(17);
        }
        if (id == null) {
            ConsoleHistoryController.$$$reportNull$$$0(18);
        }
        String pathName = PathUtil.makeFileName((String)rootType.getContentPathName(id), (String)rootType.getDefaultFileExtension());
        try {
            return rootType.findFile(null, pathName, option);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> {
                String message = String.format("Unable to open '%s/%s'\nReason: %s", rootType.getId(), pathName, e.getLocalizedMessage());
                Messages.showErrorDialog((String)message, (String)"Unable to Open File");
            });
            return null;
        }
    }

    private static ShortcutSet getShortcutUpDown(boolean isUp) {
        AnAction action2 = ActionManager.getInstance().getActionOrStub(isUp ? "EditorUp" : "EditorDown");
        if (action2 != null) {
            return action2.getShortcutSet();
        }
        return new CustomShortcutSet(KeyStroke.getKeyStroke(isUp ? 38 : 40, 0));
    }

    private static void addShortcuts(@NotNull AnAction action2, @NotNull ShortcutSet newShortcuts) {
        if (action2 == null) {
            ConsoleHistoryController.$$$reportNull$$$0(19);
        }
        if (newShortcuts == null) {
            ConsoleHistoryController.$$$reportNull$$$0(20);
        }
        if (action2.getShortcutSet().getShortcuts().length == 0) {
            action2.registerCustomShortcutSet(newShortcuts, null);
        } else {
            action2.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{action2.getShortcutSet(), newShortcuts}), null);
        }
    }

    private static Collection<KeyStroke> getKeystrokesUpDown(boolean isUp) {
        ArrayList<KeyStroke> result2 = new ArrayList<KeyStroke>();
        ShortcutSet shortcutSet = ConsoleHistoryController.getShortcutUpDown(isUp);
        for (Shortcut shortcut : shortcutSet.getShortcuts()) {
            if (!shortcut.isKeyboard() || ((KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            result2.add(((KeyboardShortcut)shortcut).getFirstKeyStroke());
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 2: 
            case 4: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistenceId";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/ConsoleHistoryController";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/ConsoleHistoryController";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fixNullPersistenceId";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getController";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixNullPersistenceId";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContentFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addShortcuts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ModelHelper
    implements SafeWriteRequestor {
        private final ConsoleRootType myRootType;
        private final String myId;
        private final ConsoleHistoryModel myModel;
        private CharSequence myContent;

        public ModelHelper(ConsoleRootType rootType, String id, ConsoleHistoryModel model2) {
            this.myRootType = rootType;
            this.myId = id;
            this.myModel = model2;
        }

        public ConsoleHistoryModel getModel() {
            return this.myModel;
        }

        public void setContent(String userValue) {
            this.myContent = userValue;
        }

        public String getId() {
            return this.myId;
        }

        public CharSequence getContent() {
            return this.myContent;
        }

        @Nullable
        File getFile(String id) {
            if (this.myRootType.isHidden()) {
                return null;
            }
            String rootPath = ScratchFileService.getInstance().getRootPath((RootType)HistoryRootType.getInstance());
            return new File(FileUtil.toSystemDependentName((String)(rootPath + "/" + ConsoleHistoryController.getHistoryName(this.myRootType, id))));
        }

        @NotNull
        Charset getCharset() {
            Charset charset = EncodingRegistry.getInstance().getDefaultCharset();
            if (charset == null) {
                ModelHelper.$$$reportNull$$$0(0);
            }
            return charset;
        }

        public boolean loadHistory(String id) {
            try {
                File file2 = this.getFile(id);
                if (file2 == null || !file2.exists()) {
                    return false;
                }
                String[] split = FileUtil.loadFile((File)file2, (Charset)this.getCharset()).split(this.myRootType.getEntrySeparator());
                this.getModel().resetEntries(Arrays.asList(split));
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        private void saveHistory() {
            if (this.getModel().isEmpty()) {
                return;
            }
            File file2 = this.getFile(this.myId);
            if (file2 == null) {
                return;
            }
            File dir = file2.getParentFile();
            if (dir == null || dir.exists() && !dir.isDirectory() || !dir.exists() && !dir.mkdirs()) {
                LOG.error("Unable to create " + file2.getPath());
                return;
            }
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), this.getCharset()));){
                boolean first = true;
                for (String entry : this.getModel().getEntries()) {
                    if (first) {
                        first = false;
                    } else {
                        out.write(this.myRootType.getEntrySeparator());
                    }
                    out.write(entry);
                }
                ((Writer)out).flush();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController$ModelHelper", "getCharset"));
        }
    }

    private class MyBrowseAction
    extends DumbAwareAction {
        private MyBrowseAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyBrowseAction.$$$reportNull$$$0(0);
            }
            boolean enabled = ConsoleHistoryController.this.hasHistory();
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyBrowseAction.$$$reportNull$$$0(1);
            }
            String title = ConsoleHistoryController.this.myConsole.getTitle() + " History";
            ContentChooser<String> chooser = new ContentChooser<String>(ConsoleHistoryController.this.myConsole.getProject(), title, true, true){
                {
                    this.setOKButtonText(ActionsBundle.actionText((String)"EditorPaste"));
                    this.setOKButtonMnemonic(80);
                    this.setCancelButtonText(CommonBundle.getCloseButtonText());
                    this.setUseNumbering(false);
                }

                @Override
                protected void removeContentAt(String content2) {
                    ConsoleHistoryController.this.getModel().removeFromHistory(content2);
                }

                @Override
                protected String getStringRepresentationFor(String content2) {
                    return content2;
                }

                @Override
                @NotNull
                protected List<String> getContents() {
                    List<String> list2 = ConsoleHistoryController.this.getModel().getEntries();
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                @Override
                protected Editor createIdeaEditor(String text2) {
                    PsiFile consoleFile = ConsoleHistoryController.this.myConsole.getFile();
                    Language language = consoleFile.getLanguage();
                    Project project = consoleFile.getProject();
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a." + consoleFile.getFileType().getDefaultExtension(), language, (CharSequence)StringUtil.convertLineSeparators((String)text2), false, true);
                    VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                    if (virtualFile instanceof LightVirtualFile) {
                        ((LightVirtualFile)virtualFile).setWritable(false);
                    }
                    Document document = (Document)ObjectUtils.notNull((Object)FileDocumentManager.getInstance().getDocument(virtualFile));
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    EditorEx editor = (EditorEx)editorFactory.createViewer(document, project);
                    editor.getSettings().setFoldingOutlineShown(false);
                    editor.getSettings().setLineMarkerAreaShown(false);
                    editor.getSettings().setIndentGuidesShown(false);
                    SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)psiFile.getViewProvider().getVirtualFile());
                    editor.setHighlighter(new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
                    return editor;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleHistoryController$MyBrowseAction$1", "getContents"));
                }
            };
            chooser.setContentIcon(null);
            chooser.setSplitterOrientation(false);
            chooser.setSelectedIndex(Math.max(0, ConsoleHistoryController.this.getModel().getHistorySize() - 1));
            if (chooser.showAndGet() && ConsoleHistoryController.this.myConsole.getCurrentEditor().getComponent().isShowing()) {
                ConsoleHistoryController.this.setConsoleText(new ConsoleHistoryModel.Entry(chooser.getSelectedText(), -1), false, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/console/ConsoleHistoryController$MyBrowseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyAction
    extends DumbAwareAction {
        private final boolean myNext;
        @NotNull
        private final Collection<KeyStroke> myUpDownKeystrokes;

        MyAction(@NotNull boolean next, Collection<KeyStroke> upDownKeystrokes) {
            if (upDownKeystrokes == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            this.myNext = next;
            this.myUpDownKeystrokes = upDownKeystrokes;
            this.getTemplatePresentation().setVisible(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ConsoleHistoryModel.Entry command;
            if (e == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            boolean hasHistory = ConsoleHistoryController.this.getModel().hasHistory();
            ConsoleHistoryModel.Entry entry = command = this.myNext ? ConsoleHistoryController.this.getModel().getHistoryNext() : ConsoleHistoryController.this.getModel().getHistoryPrev();
            if (!ConsoleHistoryController.this.myMultiline && command == null || !hasHistory && !this.myNext) {
                return;
            }
            ConsoleHistoryController.this.setConsoleText(command, !hasHistory, true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            boolean enabled = ConsoleHistoryController.this.myMultiline || !this.isUpDownKey(e) || ConsoleHistoryController.this.canMoveInEditor(this.myNext);
            e.getPresentation().setEnabled(enabled);
        }

        private boolean isUpDownKey(@NotNull AnActionEvent e) {
            InputEvent event;
            if (e == null) {
                MyAction.$$$reportNull$$$0(3);
            }
            if (!((event = e.getInputEvent()) instanceof KeyEvent)) {
                return false;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent((KeyEvent)event);
            return this.myUpDownKeystrokes.contains(keyStroke);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upDownKeystrokes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/console/ConsoleHistoryController$MyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpDownKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

