/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PrevNextDifferenceIterableBase<T>
implements PrevNextDifferenceIterable {
    @NotNull
    protected abstract List<? extends T> getChanges();

    @NotNull
    protected abstract EditorEx getEditor();

    protected abstract int getStartLine(@NotNull T var1);

    protected abstract int getEndLine(@NotNull T var1);

    protected void scrollToChange(@NotNull T change) {
        if (change == null) {
            PrevNextDifferenceIterableBase.$$$reportNull$$$0(0);
        }
        DiffUtil.scrollEditor(this.getEditor(), this.getStartLine(change), true);
    }

    @Override
    public boolean canGoNext() {
        EditorEx editor;
        List<T> changes = this.getChanges();
        if (changes.isEmpty()) {
            return false;
        }
        int line2 = editor.getCaretModel().getLogicalPosition().line;
        editor = this.getEditor();
        if (line2 == DiffUtil.getLineCount(editor.getDocument()) - 1) {
            return false;
        }
        T lastChange = changes.get(changes.size() - 1);
        return this.getStartLine(lastChange) > line2;
    }

    @Override
    public void goNext() {
        List<T> changes = this.getChanges();
        int line2 = this.getEditor().getCaretModel().getLogicalPosition().line;
        T next = null;
        for (int i = 0; i < changes.size(); ++i) {
            T change = changes.get(i);
            if (this.getStartLine(change) <= line2) continue;
            next = change;
            break;
        }
        assert (next != null);
        this.scrollToChange(next);
    }

    @Override
    public boolean canGoPrev() {
        List<T> changes = this.getChanges();
        if (changes.isEmpty()) {
            return false;
        }
        int line2 = this.getEditor().getCaretModel().getLogicalPosition().line;
        if (line2 == 0) {
            return false;
        }
        T firstChange = changes.get(0);
        if (this.getEndLine(firstChange) > line2) {
            return false;
        }
        return this.getStartLine(firstChange) < line2;
    }

    @Override
    public void goPrev() {
        List<T> changes = this.getChanges();
        int line2 = this.getEditor().getCaretModel().getLogicalPosition().line;
        T prev = null;
        for (int i = 0; i < changes.size(); ++i) {
            T next;
            T change = changes.get(i);
            T t = next = i < changes.size() - 1 ? (T)changes.get(i + 1) : null;
            if (next != null && this.getEndLine(next) <= line2 && this.getStartLine(next) < line2) continue;
            prev = change;
            break;
        }
        assert (prev != null);
        this.scrollToChange(prev);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/util/PrevNextDifferenceIterableBase", "scrollToChange"));
    }
}

