/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.analysis.AnalyzeDisposer;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongProcedure;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001f !\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u0006J@\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0010`\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer;", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "(Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;)V", "analyzeDisposedObjects", "", "disposedObjectsIDs", "Lgnu/trove/TIntHashSet;", "parentList", "Lcom/intellij/diagnostic/hprof/util/IntList;", "sizesList", "computeDisposedObjectsIDsSet", "createDisposerTreeReport", "getInstancesListInPriorityOrder", "", "Lgnu/trove/TLongArrayList;", "classToLeakedIdsList", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "Lkotlin/collections/HashMap;", "disposedDominatorReportEntries", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposedDominatorReportEntry;", "printDisposerTreeReportLine", "", "buffer", "Lcom/intellij/diagnostic/hprof/util/TruncatingPrintBuffer;", "mapping", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Grouping;", "groupedObjects", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$InstanceStats;", "Companion", "DisposedDominatorReportEntry", "Grouping", "InstanceStats", "intellij.platform.ide.impl"})
public final class AnalyzeDisposer {
    private final ObjectNavigator nav;
    @NotNull
    private static final Set<String> TOP_REPORTED_CLASSES;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String createDisposerTreeReport() {
        boolean bl;
        Object object;
        if (!this.nav.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        this.nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
        boolean bl2 = !this.nav.isNull();
        boolean bl3 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.nav.goToInstanceField("com.intellij.openapi.util.objectTree.ObjectTree", "myObject2NodeMap");
        this.nav.goToInstanceField("gnu.trove.THashMap", "_values");
        HashMap groupingToObjectStats = new HashMap();
        int maxTreeDepth = 200;
        HashSet tooDeepObjectClasses = new HashSet();
        this.nav.getReferencesCopy().forEach(new TLongProcedure(this, maxTreeDepth, tooDeepObjectClasses, groupingToObjectStats){
            final /* synthetic */ AnalyzeDisposer this$0;
            final /* synthetic */ int $maxTreeDepth;
            final /* synthetic */ HashSet $tooDeepObjectClasses;
            final /* synthetic */ HashMap $groupingToObjectStats;

            /*
             * WARNING - void declaration
             */
            public final boolean execute(long it) {
                Object object;
                void $this$getOrPut$iv;
                ClassDefinition classDefinition;
                long parentId;
                if (it == 0L) {
                    return true;
                }
                ObjectNavigator.goTo$default(AnalyzeDisposer.access$getNav$p(this.this$0), it, null, 2, null);
                long objectNodeParentId = AnalyzeDisposer.access$getNav$p(this.this$0).getInstanceFieldObjectId("com.intellij.openapi.util.objectTree.ObjectNode", "myParent");
                long objectNodeObjectId = AnalyzeDisposer.access$getNav$p(this.this$0).getInstanceFieldObjectId("com.intellij.openapi.util.objectTree.ObjectNode", "myObject");
                ObjectNavigator.goTo$default(AnalyzeDisposer.access$getNav$p(this.this$0), objectNodeParentId, null, 2, null);
                long l = parentId = AnalyzeDisposer.access$getNav$p(this.this$0).isNull() ? 0L : AnalyzeDisposer.access$getNav$p(this.this$0).getInstanceFieldObjectId("com.intellij.openapi.util.objectTree.ObjectNode", "myObject");
                if (parentId == 0L) {
                    classDefinition = null;
                } else {
                    ObjectNavigator.goTo$default(AnalyzeDisposer.access$getNav$p(this.this$0), parentId, null, 2, null);
                    classDefinition = AnalyzeDisposer.access$getNav$p(this.this$0).getClass();
                }
                ClassDefinition parentClass = classDefinition;
                ObjectNavigator.goTo$default(AnalyzeDisposer.access$getNav$p(this.this$0), objectNodeObjectId, null, 2, null);
                ClassDefinition objectClass = AnalyzeDisposer.access$getNav$p(this.this$0).getClass();
                ClassDefinition rootClass = null;
                long rootId = 0L;
                if (parentId == 0L) {
                    rootClass = objectClass;
                    rootId = objectNodeObjectId;
                } else {
                    long rootObjectNodeId = objectNodeParentId;
                    long rootObjectId = 0L;
                    int iterationCount = 0;
                    do {
                        ObjectNavigator.goTo$default(AnalyzeDisposer.access$getNav$p(this.this$0), rootObjectNodeId, null, 2, null);
                        rootObjectNodeId = AnalyzeDisposer.access$getNav$p(this.this$0).getInstanceFieldObjectId("com.intellij.openapi.util.objectTree.ObjectNode", "myParent");
                        rootObjectId = AnalyzeDisposer.access$getNav$p(this.this$0).getInstanceFieldObjectId("com.intellij.openapi.util.objectTree.ObjectNode", "myObject");
                    } while (rootObjectNodeId != 0L && ++iterationCount < this.$maxTreeDepth);
                    if (iterationCount >= this.$maxTreeDepth) {
                        this.$tooDeepObjectClasses.add(objectClass);
                        rootId = parentId;
                        ClassDefinition classDefinition2 = parentClass;
                        if (classDefinition2 == null) {
                            Intrinsics.throwNpe();
                        }
                        rootClass = classDefinition2;
                    } else {
                        ObjectNavigator.goTo$default(AnalyzeDisposer.access$getNav$p(this.this$0), rootObjectId, null, 2, null);
                        rootId = rootObjectId;
                        rootClass = AnalyzeDisposer.access$getNav$p(this.this$0).getClass();
                    }
                }
                Map rootObjectNodeId = this.$groupingToObjectStats;
                Grouping key$iv = new Grouping(objectClass, parentClass, rootClass);
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    InstanceStats answer$iv = new InstanceStats();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((InstanceStats)object).registerObject(parentId, rootId);
                return true;
            }
            {
                this.this$0 = analyzeDisposer;
                this.$maxTreeDepth = n;
                this.$tooDeepObjectClasses = hashSet;
                this.$groupingToObjectStats = hashMap;
            }
        });
        Object object2 = new TruncatingPrintBuffer(400, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

            @NotNull
            public final StringBuilder invoke(@Nullable String p1) {
                StringBuilder stringBuilder = (StringBuilder)this.receiver;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(p1);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(StringsKt.class, (String)"intellij.platform.ide.impl");
            }

            public final String getName() {
                return "appendln";
            }

            public final String getSignature() {
                return "appendln(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;";
            }
        }));
        boolean bl6 = false;
        Throwable throwable = null;
        try {
            void $this$groupByTo$iv$iv;
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object2;
            boolean bl7 = false;
            buffer.println("Disposer tree stats:");
            Set set = groupingToObjectStats.entrySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"groupingToObjectStats\n        .entries");
            Iterable $this$sortedByDescending$iv = set;
            boolean $i$f$sortedByDescending = false;
            object = $this$sortedByDescending$iv;
            boolean bl8 = false;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(((InstanceStats)it.getValue()).objectCount());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = ((InstanceStats)it.getValue()).objectCount();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator2);
            boolean $i$f$groupBy = false;
            object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object3;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl9 = false;
                ClassDefinition key$iv$iv = ((Grouping)it.getKey()).getRootClass();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl10 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv;
            bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$rootClass$entries = element$iv = iterator.next();
                boolean bl11 = false;
                Object object4 = $dstr$rootClass$entries;
                boolean bl12 = false;
                ClassDefinition rootClass = (ClassDefinition)object4.getKey();
                object4 = $dstr$rootClass$entries;
                bl12 = false;
                List entries = (List)object4.getValue();
                buffer.println("Root: " + rootClass.getName());
                object4 = new TruncatingPrintBuffer(100, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                    public final void invoke(@NotNull String p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((TruncatingPrintBuffer)this.receiver).println(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                    }

                    public final String getName() {
                        return "println";
                    }

                    public final String getSignature() {
                        return "println(Ljava/lang/String;)V";
                    }
                }));
                bl12 = false;
                Throwable throwable2 = null;
                try {
                    TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)object4;
                    boolean bl13 = false;
                    Iterable $this$forEach$iv2 = entries;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Map.Entry $dstr$mapping$groupedObjects = (Map.Entry)element$iv2;
                        boolean bl14 = false;
                        Map.Entry entry = $dstr$mapping$groupedObjects;
                        boolean bl15 = false;
                        Grouping mapping = (Grouping)entry.getKey();
                        entry = $dstr$mapping$groupedObjects;
                        bl15 = false;
                        InstanceStats groupedObjects = (InstanceStats)entry.getValue();
                        Grouping grouping = mapping;
                        Intrinsics.checkExpressionValueIsNotNull((Object)grouping, (String)"mapping");
                        InstanceStats instanceStats = groupedObjects;
                        Intrinsics.checkExpressionValueIsNotNull((Object)instanceStats, (String)"groupedObjects");
                        this.printDisposerTreeReportLine(buffer2, grouping, instanceStats);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable2);
                }
                buffer.println();
            }
            buffer = Unit.INSTANCE;
        }
        catch (Throwable buffer) {
            throwable = buffer;
            throw buffer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        if (tooDeepObjectClasses.size() > 0) {
            object2 = result2;
            String string = "Skipped analysis of objects too deep in disposer tree:";
            boolean bl16 = false;
            StringBuilder stringBuilder = ((StringBuilder)object2).append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            Iterable $this$forEach$iv = tooDeepObjectClasses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassDefinition it = (ClassDefinition)element$iv;
                boolean bl17 = false;
                StringBuilder stringBuilder2 = result2;
                object = " * " + this.nav.getClassStore().getShortPrettyNameForClass(it);
                bl = false;
                StringBuilder stringBuilder3 = stringBuilder2.append((String)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void printDisposerTreeReportLine(TruncatingPrintBuffer buffer, Grouping mapping, InstanceStats groupedObjects) {
        void sourceClass;
        void parentClass;
        Grouping grouping = mapping;
        ClassDefinition classDefinition = grouping.component1();
        ClassDefinition classDefinition2 = grouping.component2();
        ClassDefinition rootClass = grouping.component3();
        int objectCount = groupedObjects.objectCount();
        int parentCount = groupedObjects.parentCount();
        if (parentClass != null && objectCount == parentCount) {
            return;
        }
        String parentString = null;
        if (parentClass == null) {
            parentString = "(no parent)";
        } else {
            String parentClassName = this.nav.getClassStore().getShortPrettyNameForClass((ClassDefinition)parentClass);
            int rootCount = groupedObjects.rootCount();
            parentString = Intrinsics.areEqual((Object)rootClass, (Object)parentClass) ^ true || rootCount != parentCount ? "<-- " + parentCount + ' ' + parentClassName + " [...] " + rootCount : "<-- " + parentCount;
        }
        String sourceClassName = this.nav.getClassStore().getShortPrettyNameForClass((ClassDefinition)sourceClass);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%6d";
        Object[] objectArray = new Object[]{objectCount};
        StringBuilder stringBuilder = new StringBuilder().append("  ");
        TruncatingPrintBuffer truncatingPrintBuffer = buffer;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        truncatingPrintBuffer.println(stringBuilder.append(string3).append(' ').append(sourceClassName).append(' ').append(parentString).toString());
    }

    @NotNull
    public final TIntHashSet computeDisposedObjectsIDsSet(@NotNull IntList parentList) {
        Intrinsics.checkParameterIsNotNull((Object)parentList, (String)"parentList");
        TIntHashSet result2 = new TIntHashSet();
        if (!this.nav.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
            return result2;
        }
        this.nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
        boolean bl = !this.nav.isNull();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.nav.goToInstanceField("com.intellij.openapi.util.objectTree.ObjectTree", "myDisposedObjects");
        this.nav.goToInstanceField("com.intellij.util.containers.WeakHashMap", "myMap");
        this.nav.goToInstanceField("com.intellij.util.containers.RefHashMap$MyMap", "_set");
        ClassDefinition weakKeyClass = this.nav.getClassStore().get("com.intellij.util.containers.WeakHashMap$WeakKey");
        this.nav.getReferencesCopy().forEach(new TLongProcedure(this, weakKeyClass, parentList, result2){
            final /* synthetic */ AnalyzeDisposer this$0;
            final /* synthetic */ ClassDefinition $weakKeyClass;
            final /* synthetic */ IntList $parentList;
            final /* synthetic */ TIntHashSet $result;

            public final boolean execute(long it) {
                if (it == 0L) {
                    return true;
                }
                AnalyzeDisposer.access$getNav$p(this.this$0).goTo(it, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                if (Intrinsics.areEqual((Object)AnalyzeDisposer.access$getNav$p(this.this$0).getClass(), (Object)this.$weakKeyClass) ^ true) {
                    return true;
                }
                AnalyzeDisposer.access$getNav$p(this.this$0).goToInstanceField("com.intellij.util.containers.WeakHashMap$WeakKey", "referent");
                if (AnalyzeDisposer.access$getNav$p(this.this$0).getId() == 0L) {
                    return true;
                }
                int leakId = (int)AnalyzeDisposer.access$getNav$p(this.this$0).getId();
                if (this.$parentList.get(leakId) == 0) {
                    return true;
                }
                this.$result.add(leakId);
                return true;
            }
            {
                this.this$0 = analyzeDisposer;
                this.$weakKeyClass = classDefinition;
                this.$parentList = intList;
                this.$result = tIntHashSet;
            }
        });
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String analyzeDisposedObjects(@NotNull TIntHashSet disposedObjectsIDs, @NotNull IntList parentList, @NotNull IntList sizesList) {
        Object object;
        boolean $i$f$forEach;
        void totalCount;
        Intrinsics.checkParameterIsNotNull((Object)disposedObjectsIDs, (String)"disposedObjectsIDs");
        Intrinsics.checkParameterIsNotNull((Object)parentList, (String)"parentList");
        Intrinsics.checkParameterIsNotNull((Object)sizesList, (String)"sizesList");
        StringBuilder result2 = new StringBuilder();
        HashMap<ClassDefinition, TLongArrayList> leakedInstancesByClass = new HashMap<ClassDefinition, TLongArrayList>();
        TObjectIntHashMap countByClass = new TObjectIntHashMap();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        disposedObjectsIDs.forEach(new TIntProcedure(this, leakedInstancesByClass, countByClass, (Ref.IntRef)totalCount){
            final /* synthetic */ AnalyzeDisposer this$0;
            final /* synthetic */ HashMap $leakedInstancesByClass;
            final /* synthetic */ TObjectIntHashMap $countByClass;
            final /* synthetic */ Ref.IntRef $totalCount;

            public final boolean execute(int it) {
                Object object;
                AnalyzeDisposer.access$getNav$p(this.this$0).goTo(it, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                ClassDefinition leakClass = AnalyzeDisposer.access$getNav$p(this.this$0).getClass();
                long leakId = AnalyzeDisposer.access$getNav$p(this.this$0).getId();
                Map $this$getOrPut$iv = this.$leakedInstancesByClass;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(leakClass);
                if (value$iv == null) {
                    boolean bl = false;
                    TLongArrayList answer$iv = new TLongArrayList();
                    $this$getOrPut$iv.put(leakClass, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((TLongArrayList)object).add(leakId);
                this.$countByClass.put((Object)leakClass, this.$countByClass.get((Object)leakClass) + 1);
                int n = this.$totalCount.element;
                this.$totalCount.element = n + 1;
                return true;
            }
            {
                this.this$0 = analyzeDisposer;
                this.$leakedInstancesByClass = hashMap;
                this.$countByClass = tObjectIntHashMap;
                this.$totalCount = intRef;
            }
        });
        boolean bl = false;
        List entries = new ArrayList();
        countByClass.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<ClassDefinition>(entries){
            final /* synthetic */ List $entries;

            public final boolean execute(ClassDefinition key, int value) {
                ClassDefinition classDefinition = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDefinition, (String)"key");
                @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000%\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"com/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$analyzeDisposedObjects$TObjectIntMapEntry", "T", "", "key", "value", "", "(Ljava/lang/Object;I)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "()I", "component1", "component2", "copy", "(Ljava/lang/Object;I)Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$analyzeDisposedObjects$TObjectIntMapEntry;", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
                public final class TObjectIntMapEntry<T> {
                    private final T key;
                    private final int value;

                    public final T getKey() {
                        return this.key;
                    }

                    public final int getValue() {
                        return this.value;
                    }

                    public TObjectIntMapEntry(T key, int value) {
                        this.key = key;
                        this.value = value;
                    }

                    public final T component1() {
                        return this.key;
                    }

                    public final int component2() {
                        return this.value;
                    }

                    @NotNull
                    public final TObjectIntMapEntry<T> copy(T key, int value) {
                        return new TObjectIntMapEntry<T>(key, value);
                    }

                    public static /* synthetic */ TObjectIntMapEntry copy$default(TObjectIntMapEntry tObjectIntMapEntry, Object object, int n, int n2, Object object2) {
                        if ((n2 & 1) != 0) {
                            object = tObjectIntMapEntry.key;
                        }
                        if ((n2 & 2) != 0) {
                            n = tObjectIntMapEntry.value;
                        }
                        return tObjectIntMapEntry.copy(object, n);
                    }

                    @NotNull
                    public String toString() {
                        return "TObjectIntMapEntry(key=" + this.key + ", value=" + this.value + ")";
                    }

                    public int hashCode() {
                        T t = this.key;
                        return (t != null ? t.hashCode() : 0) * 31 + Integer.hashCode(this.value);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof TObjectIntMapEntry)) break block3;
                                TObjectIntMapEntry tObjectIntMapEntry = (TObjectIntMapEntry)object;
                                if (!Intrinsics.areEqual(this.key, tObjectIntMapEntry.key) || !(this.value == tObjectIntMapEntry.value)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                this.$entries.add(new TObjectIntMapEntry<ClassDefinition>(classDefinition, value));
                return true;
            }
            {
                this.$entries = list2;
            }
        });
        Closeable closeable = new TruncatingPrintBuffer(100, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

            @NotNull
            public final StringBuilder invoke(@Nullable String p1) {
                StringBuilder stringBuilder = (StringBuilder)this.receiver;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(p1);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(StringsKt.class, (String)"intellij.platform.ide.impl");
            }

            public final String getName() {
                return "appendln";
            }

            public final String getSignature() {
                return "appendln(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;";
            }
        }));
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable;
            boolean bl3 = false;
            buffer.println("Count of disposed-but-strong-referenced objects: " + totalCount.element);
            Iterable $this$sortedByDescending$iv = entries;
            boolean $i$f$sortedByDescending = false;
            Iterable iterable = $this$sortedByDescending$iv;
            boolean bl4 = false;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    TObjectIntMapEntry it = (TObjectIntMapEntry)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getValue());
                    it = (TObjectIntMapEntry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Iterable $this$partition$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                TObjectIntMapEntry it = (TObjectIntMapEntry)element$iv;
                boolean bl5 = false;
                if (TOP_REPORTED_CLASSES.contains(((ClassDefinition)it.getKey()).getName())) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            $this$partition$iv = new Pair(first$iv, second$iv);
            $i$f$partition = false;
            boolean bl6 = false;
            Iterable it = $this$partition$iv;
            boolean bl7 = false;
            Iterable $this$forEach$iv = CollectionsKt.plus((Collection)((Collection)it.getFirst()), (Iterable)((Iterable)it.getSecond()));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TObjectIntMapEntry entry = (TObjectIntMapEntry)element$iv;
                boolean bl8 = false;
                buffer.println("  " + entry.getValue() + ' ' + ((ClassDefinition)entry.getKey()).getPrettyName());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        StringsKt.appendln((StringBuilder)result2);
        GCRootPathsTree disposedTree = new GCRootPathsTree(disposedObjectsIDs, parentList, sizesList, this.nav, null);
        for (int disposedObjectsID : disposedObjectsIDs) {
            disposedTree.registerObject(disposedObjectsID);
        }
        Map<ClassDefinition, List<GCRootPathsTree.RegularNode>> disposedDominatorNodesByClass = disposedTree.getDisposedDominatorNodes();
        long allDominatorsCount = 0L;
        long allDominatorsSubgraphSize = 0L;
        boolean $this$forEach$iv = false;
        List disposedDominatorClassSizeList = new ArrayList();
        Object $this$forEach$iv2 = disposedDominatorNodesByClass;
        $i$f$forEach = false;
        Object object2 = $this$forEach$iv2;
        boolean element$iv = false;
        Iterator entry = object2.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry element$iv2;
            Map.Entry $dstr$classDefinition$nodeList = element$iv2 = entry.next();
            boolean bl9 = false;
            Map.Entry entry2 = $dstr$classDefinition$nodeList;
            boolean bl10 = false;
            ClassDefinition classDefinition = (ClassDefinition)entry2.getKey();
            entry2 = $dstr$classDefinition$nodeList;
            bl10 = false;
            List nodeList = (List)entry2.getValue();
            long dominatorClassSubgraphSize = 0L;
            long dominatorClassInstanceCount = 0L;
            Iterable $this$forEach$iv3 = nodeList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                GCRootPathsTree.RegularNode it = (GCRootPathsTree.RegularNode)element$iv3;
                boolean bl11 = false;
                dominatorClassInstanceCount += (long)it.getInstances().size();
                dominatorClassSubgraphSize += (long)it.getTotalSizeInDwords() * (long)4;
            }
            allDominatorsCount += dominatorClassInstanceCount;
            allDominatorsSubgraphSize += dominatorClassSubgraphSize;
            disposedDominatorClassSizeList.add(new DisposedDominatorReportEntry(classDefinition, dominatorClassInstanceCount, dominatorClassSubgraphSize));
        }
        $this$forEach$iv2 = new TruncatingPrintBuffer(30, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

            @NotNull
            public final StringBuilder invoke(@Nullable String p1) {
                StringBuilder stringBuilder = (StringBuilder)this.receiver;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(p1);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(StringsKt.class, (String)"intellij.platform.ide.impl");
            }

            public final String getName() {
                return "appendln";
            }

            public final String getSignature() {
                return "appendln(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;";
            }
        }));
        boolean bl12 = false;
        object2 = null;
        try {
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)$this$forEach$iv2;
            boolean bl13 = false;
            buffer.println("Disposed-but-strong-referenced dominator object count: " + allDominatorsCount);
            buffer.println("Disposed-but-strong-referenced dominator sub-graph size: " + HeapReportUtils.Companion.toShortStringAsSize(allDominatorsSubgraphSize));
            Iterable $this$sortedByDescending$iv = disposedDominatorClassSizeList;
            boolean $i$f$sortedByDescending = false;
            Iterable bl9 = $this$sortedByDescending$iv;
            boolean bl14 = false;
            Comparator comparator3 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    DisposedDominatorReportEntry it = (DisposedDominatorReportEntry)b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getSize());
                    it = (DisposedDominatorReportEntry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = it.getSize();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
            Iterable $this$forEach$iv4 = CollectionsKt.sortedWith((Iterable)bl9, (Comparator)comparator3);
            boolean $i$f$forEach3 = false;
            for (Object element$iv4 : $this$forEach$iv4) {
                DisposedDominatorReportEntry entry3 = (DisposedDominatorReportEntry)element$iv4;
                boolean bl15 = false;
                buffer.println("  " + HeapReportUtils.Companion.toPaddedShortStringAsSize(entry3.getSize()) + " - " + HeapReportUtils.Companion.toShortStringAsCount(entry3.getCount()) + ' ' + entry3.getClassDefinition().getName());
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            object2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$this$forEach$iv2, (Throwable)object2);
        }
        StringsKt.appendln((StringBuilder)result2);
        List<TLongArrayList> instancesListInOrder = this.getInstancesListInPriorityOrder(leakedInstancesByClass, disposedDominatorClassSizeList);
        Closeable closeable2 = new TruncatingPrintBuffer(700, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>(result2){

            @NotNull
            public final StringBuilder invoke(@Nullable String p1) {
                StringBuilder stringBuilder = (StringBuilder)this.receiver;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(p1);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(StringsKt.class, (String)"intellij.platform.ide.impl");
            }

            public final String getName() {
                return "appendln";
            }

            public final String getSignature() {
                return "appendln(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;";
            }
        }));
        boolean bl16 = false;
        object = null;
        try {
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable2;
            boolean bl17 = false;
            Iterable $this$forEach$iv5 = instancesListInOrder;
            boolean $i$f$forEach4 = false;
            for (Object element$iv5 : $this$forEach$iv5) {
                void $this$forEach$iv6;
                TLongArrayList instances = (TLongArrayList)element$iv5;
                boolean bl18 = false;
                ObjectNavigator.goTo$default(this.nav, instances.get(0), null, 2, null);
                buffer.println("Disposed but still strong-referenced objects: " + instances.size() + ' ' + this.nav.getClass().getPrettyName() + ", most common paths from GC-roots:");
                GCRootPathsTree gcRootPathsTree = new GCRootPathsTree(disposedObjectsIDs, parentList, sizesList, this.nav, this.nav.getClass());
                instances.forEach(new TLongProcedure(gcRootPathsTree){
                    final /* synthetic */ GCRootPathsTree $gcRootPathsTree;

                    public final boolean execute(long leakId) {
                        this.$gcRootPathsTree.registerObject((int)leakId);
                        return true;
                    }
                    {
                        this.$gcRootPathsTree = gCRootPathsTree;
                    }
                });
                Iterable $i$f$forEach2 = StringsKt.split$default((CharSequence)gcRootPathsTree.printTree(70, 5), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                TruncatingPrintBuffer truncatingPrintBuffer = buffer;
                boolean $i$f$forEach5 = false;
                for (Object element$iv6 : $this$forEach$iv6) {
                    String p1 = (String)element$iv6;
                    boolean bl19 = false;
                    truncatingPrintBuffer.println(p1);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            object = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TLongArrayList> getInstancesListInPriorityOrder(HashMap<ClassDefinition, TLongArrayList> classToLeakedIdsList, List<DisposedDominatorReportEntry> disposedDominatorReportEntries) {
        void $this$mapTo$iv$iv;
        ClassDefinition classDefinition;
        void $this$mapTo$iv$iv2;
        Object $this$forEach$iv;
        Object result$iv;
        Object element$iv2;
        boolean bl = false;
        List result2 = new ArrayList();
        HashMap classToLeakedIdsListCopy = new HashMap(classToLeakedIdsList);
        Iterable $this$forEach$iv2 = TOP_REPORTED_CLASSES;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            String topClassName = (String)element$iv2;
            boolean bl2 = false;
            Map $this$filterKeys$iv = classToLeakedIdsListCopy;
            boolean $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            Map map2 = $this$filterKeys$iv;
            boolean bl3 = false;
            for (Map.Entry entry$iv : map2.entrySet()) {
                ClassDefinition it = (ClassDefinition)entry$iv.getKey();
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)topClassName)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$forEach$iv = (Map)result$iv;
            boolean $i$f$forEach2 = false;
            result$iv = $this$forEach$iv;
            boolean bl5 = false;
            Iterator iterator = result$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                TLongArrayList list2;
                Map.Entry element$iv3;
                Map.Entry $dstr$classDefinition$list = element$iv3 = iterator.next();
                boolean bl6 = false;
                Map.Entry entry = $dstr$classDefinition$list;
                boolean bl7 = false;
                ClassDefinition classDefinition2 = (ClassDefinition)entry.getKey();
                entry = $dstr$classDefinition$list;
                bl7 = false;
                TLongArrayList tLongArrayList = list2 = (TLongArrayList)entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)tLongArrayList, (String)"list");
                result2.add(tLongArrayList);
                classToLeakedIdsListCopy.remove(classDefinition2);
            }
        }
        Set set = classToLeakedIdsListCopy.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"classToLeakedIdsListCopy\n        .entries");
        Iterable $this$sortedByDescending$iv = set;
        boolean $i$f$sortedByDescending = false;
        element$iv2 = $this$sortedByDescending$iv;
        boolean topClassName = false;
        Comparator bl2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(((TLongArrayList)it.getValue()).size());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ((TLongArrayList)it.getValue()).size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        Collection<ClassDefinition> collection = CollectionsKt.sortedWith(element$iv2, (Comparator)bl2);
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            result$iv = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl8 = false;
            classDefinition = (ClassDefinition)it.getKey();
            collection.add(classDefinition);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        ArrayDeque classOrderByInstanceCount = new ArrayDeque(collection2);
        Iterable $this$sortedByDescending$iv2 = disposedDominatorReportEntries;
        boolean $i$f$sortedByDescending2 = false;
        destination$iv$iv = $this$sortedByDescending$iv2;
        $i$f$mapTo = false;
        $this$forEach$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                DisposedDominatorReportEntry it = (DisposedDominatorReportEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getSize());
                it = (DisposedDominatorReportEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getSize();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        collection = CollectionsKt.sortedWith((Iterable)destination$iv$iv, (Comparator)$this$forEach$iv);
        Iterable $this$map$iv2 = collection;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DisposedDominatorReportEntry bl8 = (DisposedDominatorReportEntry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl9 = false;
            classDefinition = it.getClassDefinition();
            collection.add(classDefinition);
        }
        Collection<ClassDefinition> collection3 = collection = (List)destination$iv$iv2;
        ArrayDeque classOrderByByteCount = new ArrayDeque(collection3);
        boolean nextByInstanceCount = true;
        while (!classOrderByInstanceCount.isEmpty() || !classOrderByByteCount.isEmpty()) {
            ArrayDeque nextCollection;
            ArrayDeque arrayDeque = nextCollection = nextByInstanceCount ? classOrderByInstanceCount : classOrderByByteCount;
            if (!nextCollection.isEmpty()) {
                TLongArrayList list3;
                ClassDefinition nextClass = (ClassDefinition)nextCollection.removeFirst();
                if ((TLongArrayList)classToLeakedIdsListCopy.remove(nextClass) == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"classToLeakedIdsListCopy\u2026ve(nextClass) ?: continue");
                result2.add(list3);
            }
            nextByInstanceCount = !nextByInstanceCount;
        }
        return result2;
    }

    public AnalyzeDisposer(@NotNull ObjectNavigator nav) {
        Intrinsics.checkParameterIsNotNull((Object)nav, (String)"nav");
        this.nav = nav;
    }

    static {
        Companion = new Companion(null);
        TOP_REPORTED_CLASSES = SetsKt.setOf((Object)"com.intellij.openapi.project.impl.ProjectImpl");
    }

    public static final /* synthetic */ ObjectNavigator access$getNav$p(AnalyzeDisposer $this) {
        return $this.nav;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Grouping;", "", "childClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "parentClass", "rootClass", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "getChildClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getParentClass", "getRootClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class Grouping {
        @NotNull
        private final ClassDefinition childClass;
        @Nullable
        private final ClassDefinition parentClass;
        @NotNull
        private final ClassDefinition rootClass;

        @NotNull
        public final ClassDefinition getChildClass() {
            return this.childClass;
        }

        @Nullable
        public final ClassDefinition getParentClass() {
            return this.parentClass;
        }

        @NotNull
        public final ClassDefinition getRootClass() {
            return this.rootClass;
        }

        public Grouping(@NotNull ClassDefinition childClass, @Nullable ClassDefinition parentClass, @NotNull ClassDefinition rootClass) {
            Intrinsics.checkParameterIsNotNull((Object)childClass, (String)"childClass");
            Intrinsics.checkParameterIsNotNull((Object)rootClass, (String)"rootClass");
            this.childClass = childClass;
            this.parentClass = parentClass;
            this.rootClass = rootClass;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.childClass;
        }

        @Nullable
        public final ClassDefinition component2() {
            return this.parentClass;
        }

        @NotNull
        public final ClassDefinition component3() {
            return this.rootClass;
        }

        @NotNull
        public final Grouping copy(@NotNull ClassDefinition childClass, @Nullable ClassDefinition parentClass, @NotNull ClassDefinition rootClass) {
            Intrinsics.checkParameterIsNotNull((Object)childClass, (String)"childClass");
            Intrinsics.checkParameterIsNotNull((Object)rootClass, (String)"rootClass");
            return new Grouping(childClass, parentClass, rootClass);
        }

        public static /* synthetic */ Grouping copy$default(Grouping grouping, ClassDefinition classDefinition, ClassDefinition classDefinition2, ClassDefinition classDefinition3, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = grouping.childClass;
            }
            if ((n & 2) != 0) {
                classDefinition2 = grouping.parentClass;
            }
            if ((n & 4) != 0) {
                classDefinition3 = grouping.rootClass;
            }
            return grouping.copy(classDefinition, classDefinition2, classDefinition3);
        }

        @NotNull
        public String toString() {
            return "Grouping(childClass=" + this.childClass + ", parentClass=" + this.parentClass + ", rootClass=" + this.rootClass + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.childClass;
            ClassDefinition classDefinition2 = this.parentClass;
            ClassDefinition classDefinition3 = this.rootClass;
            return ((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + (classDefinition2 != null ? ((Object)classDefinition2).hashCode() : 0)) * 31 + (classDefinition3 != null ? ((Object)classDefinition3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Grouping)) break block3;
                    Grouping grouping = (Grouping)object;
                    if (!Intrinsics.areEqual((Object)this.childClass, (Object)grouping.childClass) || !Intrinsics.areEqual((Object)this.parentClass, (Object)grouping.parentClass) || !Intrinsics.areEqual((Object)this.rootClass, (Object)grouping.rootClass)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$InstanceStats;", "", "()V", "parentIds", "Lgnu/trove/TLongArrayList;", "rootIds", "Lgnu/trove/TLongHashSet;", "objectCount", "", "parentCount", "registerObject", "", "parentId", "", "rootId", "rootCount", "intellij.platform.ide.impl"})
    public static final class InstanceStats {
        private final TLongArrayList parentIds = new TLongArrayList();
        private final TLongHashSet rootIds = new TLongHashSet();

        public final int parentCount() {
            return new TLongHashSet(this.parentIds.toNativeArray()).size();
        }

        public final int rootCount() {
            return this.rootIds.size();
        }

        public final int objectCount() {
            return this.parentIds.size();
        }

        public final void registerObject(long parentId, long rootId) {
            this.parentIds.add(parentId);
            this.rootIds.add(rootId);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposedDominatorReportEntry;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "count", "", "size", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;JJ)V", "getClassDefinition", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getCount", "()J", "getSize", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class DisposedDominatorReportEntry {
        @NotNull
        private final ClassDefinition classDefinition;
        private final long count;
        private final long size;

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        public final long getCount() {
            return this.count;
        }

        public final long getSize() {
            return this.size;
        }

        public DisposedDominatorReportEntry(@NotNull ClassDefinition classDefinition, long count, long size) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            this.count = count;
            this.size = size;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        public final long component2() {
            return this.count;
        }

        public final long component3() {
            return this.size;
        }

        @NotNull
        public final DisposedDominatorReportEntry copy(@NotNull ClassDefinition classDefinition, long count, long size) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            return new DisposedDominatorReportEntry(classDefinition, count, size);
        }

        public static /* synthetic */ DisposedDominatorReportEntry copy$default(DisposedDominatorReportEntry disposedDominatorReportEntry, ClassDefinition classDefinition, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = disposedDominatorReportEntry.classDefinition;
            }
            if ((n & 2) != 0) {
                l = disposedDominatorReportEntry.count;
            }
            if ((n & 4) != 0) {
                l2 = disposedDominatorReportEntry.size;
            }
            return disposedDominatorReportEntry.copy(classDefinition, l, l2);
        }

        @NotNull
        public String toString() {
            return "DisposedDominatorReportEntry(classDefinition=" + this.classDefinition + ", count=" + this.count + ", size=" + this.size + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.classDefinition;
            return ((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + Long.hashCode(this.count)) * 31 + Long.hashCode(this.size);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DisposedDominatorReportEntry)) break block3;
                    DisposedDominatorReportEntry disposedDominatorReportEntry = (DisposedDominatorReportEntry)object;
                    if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)disposedDominatorReportEntry.classDefinition) || !(this.count == disposedDominatorReportEntry.count) || !(this.size == disposedDominatorReportEntry.size)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Companion;", "", "()V", "TOP_REPORTED_CLASSES", "", "", "getTOP_REPORTED_CLASSES", "()Ljava/util/Set;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Set<String> getTOP_REPORTED_CLASSES() {
            return TOP_REPORTED_CLASSES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

