/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.util.EventListener;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class FontEditorPreview
implements PreviewPanel {
    private final EditorEx myEditor;
    private final Supplier<? extends EditorColorsScheme> mySchemeSupplier;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public FontEditorPreview(Supplier<? extends EditorColorsScheme> schemeSupplier, boolean editable) {
        this.mySchemeSupplier = schemeSupplier;
        String text2 = FontEditorPreview.getIDEDemoText();
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(text2, 10, 3, -1, this.mySchemeSupplier.get(), editable);
        FontEditorPreview.installTrafficLights(this.myEditor);
    }

    public static String getIDEDemoText() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + " is a full-featured IDE\nwith a high level of usability and outstanding\nadvanced code editing and refactoring support.\n\nabcdefghijklmnopqrstuvwxyz 0123456789 (){}[]\nABCDEFGHIJKLMNOPQRSTUVWXYZ +-*/= .,;:!? #&$%@|^\n\n\n\n";
    }

    static void installTrafficLights(@NotNull EditorEx editor) {
        if (editor == null) {
            FontEditorPreview.$$$reportNull$$$0(0);
        }
        TrafficLightRenderer renderer2 = new TrafficLightRenderer(null, null, null){

            @Override
            @NotNull
            protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
                if (severityRegistrar == null) {
                    1.$$$reportNull$$$0(0);
                }
                TrafficLightRenderer.DaemonCodeAnalyzerStatus status = new TrafficLightRenderer.DaemonCodeAnalyzerStatus();
                status.errorAnalyzingFinished = true;
                status.errorCount = new int[]{1, 2};
                TrafficLightRenderer.DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    1.$$$reportNull$$$0(1);
                }
                return daemonCodeAnalyzerStatus;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "severityRegistrar";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/colors/FontEditorPreview$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDaemonCodeAnalyzerStatus";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        Disposer.register((Disposable)((Disposable)editor.getCaretModel()), (Disposable)renderer2);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeRenderer(renderer2);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
    }

    static Editor createPreviewEditor(String text2, int column, int line2, int selectedLine, EditorColorsScheme scheme, boolean editable) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)text2);
        EditorEx editor = (EditorEx)(editable ? editorFactory.createEditor(editorDocument) : editorFactory.createViewer(editorDocument));
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(true);
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        LogicalPosition pos = new LogicalPosition(line2, column);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (selectedLine >= 0) {
            editor.getSelectionModel().setSelection(editorDocument.getLineStartOffset(selectedLine), editorDocument.getLineEndOffset(selectedLine));
        }
        return editor;
    }

    @Override
    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme = this.updateOptionsScheme(this.mySchemeSupplier.get());
        this.myEditor.setColorsScheme(scheme);
        this.myEditor.reinitSettings();
    }

    protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
        return selectedScheme;
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            FontEditorPreview.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installTrafficLights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

