/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileWatchRequestModifier
implements Runnable {
    private static final Logger LOG = Logger.getInstance(FileWatchRequestModifier.class);
    private final Project myProject;
    private final NewMappings myNewMappings;
    private final Map<VcsDirectoryMapping, LocalFileSystem.WatchRequest> myDirectoryMappingWatches;
    private final LocalFileSystem myLfs;

    public FileWatchRequestModifier(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull LocalFileSystem localFileSystem) {
        if (project == null) {
            FileWatchRequestModifier.$$$reportNull$$$0(0);
        }
        if (newMappings == null) {
            FileWatchRequestModifier.$$$reportNull$$$0(1);
        }
        if (localFileSystem == null) {
            FileWatchRequestModifier.$$$reportNull$$$0(2);
        }
        this.myLfs = localFileSystem;
        this.myProject = project;
        this.myNewMappings = newMappings;
        this.myDirectoryMappingWatches = new THashMap();
    }

    @Override
    public void run() {
        if (!this.myProject.isInitialized() || this.myProject.isDisposed()) {
            return;
        }
        List<VcsDirectoryMapping> copy = this.myNewMappings.getDirectoryMappings();
        LinkedList<VcsDirectoryMapping> added = new LinkedList<VcsDirectoryMapping>(copy);
        added.removeAll(this.myDirectoryMappingWatches.keySet());
        LinkedList<VcsDirectoryMapping> deleted = new LinkedList<VcsDirectoryMapping>(this.myDirectoryMappingWatches.keySet());
        deleted.removeAll(copy);
        THashMap toAdd = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        for (VcsDirectoryMapping vcsDirectoryMapping : added) {
            if (vcsDirectoryMapping.isDefaultMapping()) continue;
            toAdd.put(FileUtil.toCanonicalPath((String)vcsDirectoryMapping.getDirectory()), vcsDirectoryMapping);
        }
        LinkedList<LocalFileSystem.WatchRequest> toRemove = new LinkedList<LocalFileSystem.WatchRequest>();
        for (VcsDirectoryMapping mapping : deleted) {
            LocalFileSystem.WatchRequest removed;
            if (mapping.isDefaultMapping() || (removed = this.myDirectoryMappingWatches.remove(mapping)) == null) continue;
            toRemove.add(removed);
        }
        Set set = this.myLfs.replaceWatchedRoots(toRemove, toAdd.keySet(), null);
        for (LocalFileSystem.WatchRequest request : set) {
            VcsDirectoryMapping mapping = (VcsDirectoryMapping)toAdd.get(request.getRootPath());
            if (mapping != null) {
                this.myDirectoryMappingWatches.put(mapping, request);
                continue;
            }
            LOG.error("root=" + request.getRootPath() + " toAdd=" + toAdd.keySet());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "localFileSystem";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/FileWatchRequestModifier";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

