/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.DefaultInclusionModel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    @NotNull
    private final ToggleChangeDiffAction myToggleChangeDiffAction;
    @Nullable
    private Set<String> myChangeListNames;

    public LocalChangesBrowser(@NotNull Project project) {
        if (project == null) {
            LocalChangesBrowser.$$$reportNull$$$0(0);
        }
        super(project, true, true);
        this.myToggleChangeDiffAction = new ToggleChangeDiffAction();
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.myViewer.setInclusionModel(new DefaultInclusionModel((TObjectHashingStrategy<Object>)ChangeListChange.HASHING_STRATEGY));
        this.myViewer.rebuildTree();
    }

    public void dispose() {
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        List list = ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{this.myToggleChangeDiffAction});
        if (list == null) {
            LocalChangesBrowser.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        List lists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        if (this.myChangeListNames != null) {
            lists = ContainerUtil.filter((Collection)lists, list -> this.myChangeListNames.contains(list.getName()));
        }
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChangeLists(this.myProject, this.getGrouping(), lists, Registry.is((String)"vcs.skip.single.default.changelist"));
        if (defaultTreeModel == null) {
            LocalChangesBrowser.$$$reportNull$$$0(2);
        }
        return defaultTreeModel;
    }

    public void setIncludedChanges(@NotNull Collection<? extends Change> changes2) {
        if (changes2 == null) {
            LocalChangesBrowser.$$$reportNull$$$0(3);
        }
        ArrayList<? extends Change> changesToInclude = new ArrayList<Change>(changes2);
        HashSet<Change> otherChanges = new HashSet<Change>();
        for (Change change : changes2) {
            if (change instanceof ChangeListChange) continue;
            otherChanges.add(change);
        }
        if (!otherChanges.isEmpty()) {
            for (Change change : this.getAllChanges()) {
                if (!(change instanceof ChangeListChange) || !otherChanges.contains(change)) continue;
                changesToInclude.add((Change)change);
            }
        }
        this.myViewer.setIncludedChanges(changesToInclude);
    }

    public List<Change> getAllChanges() {
        return VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getIncludedChanges() {
        return VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
    }

    public void setToggleActionTitle(@Nullable String title) {
        this.myToggleChangeDiffAction.getTemplatePresentation().setText(title);
    }

    public void setChangeLists(@Nullable List<? extends LocalChangeList> changeLists) {
        this.myChangeListNames = changeLists != null ? ContainerUtil.map2Set(changeLists, LocalChangeList::getName) : null;
        this.myViewer.rebuildTree();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        @NotNull
        private final MergingUpdateQueue myUpdateQueue;

        private MyChangeListListener() {
            this.myUpdateQueue = new MergingUpdateQueue("LocalChangesViewer", 300, true, (JComponent)LocalChangesBrowser.this, (Disposable)LocalChangesBrowser.this);
        }

        private void doUpdate() {
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    LocalChangesBrowser.this.myViewer.rebuildTree();
                }
            });
        }

        public void changeListsChanged() {
            this.doUpdate();
        }
    }

    private class ToggleChangeDiffAction
    extends CheckboxAction
    implements DumbAware {
        ToggleChangeDiffAction() {
            super("&Include");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Change change;
            if (e == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(0);
            }
            if ((change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                return false;
            }
            return LocalChangesBrowser.this.myViewer.isIncluded(change);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Change change;
            if (e == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(1);
            }
            if ((change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                return;
            }
            if (state) {
                LocalChangesBrowser.this.myViewer.includeChange(change);
            } else {
                LocalChangesBrowser.this.myViewer.excludeChange(change);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser$ToggleChangeDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

