/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShelvedWrapper {
    @Nullable
    private final ShelvedChange myShelvedChange;
    @Nullable
    private final ShelvedBinaryFile myBinaryFile;

    ShelvedWrapper(@NotNull ShelvedChange shelvedChange) {
        if (shelvedChange == null) {
            ShelvedWrapper.$$$reportNull$$$0(0);
        }
        this.myShelvedChange = shelvedChange;
        this.myBinaryFile = null;
    }

    ShelvedWrapper(@NotNull ShelvedBinaryFile binaryFile) {
        if (binaryFile == null) {
            ShelvedWrapper.$$$reportNull$$$0(1);
        }
        this.myShelvedChange = null;
        this.myBinaryFile = binaryFile;
    }

    @Nullable
    public ShelvedChange getShelvedChange() {
        return this.myShelvedChange;
    }

    @Nullable
    public ShelvedBinaryFile getBinaryFile() {
        return this.myBinaryFile;
    }

    public String getRequestName() {
        return FileUtil.toSystemDependentName((String)((String)ObjectUtils.chooseNotNull((Object)this.getAfterPath(), (Object)this.getBeforePath())));
    }

    String getBeforePath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getBeforePath() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).BEFORE_PATH;
    }

    String getAfterPath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getAfterPath() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).AFTER_PATH;
    }

    FileStatus getFileStatus() {
        return this.myShelvedChange != null ? this.myShelvedChange.getFileStatus() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).getFileStatus();
    }

    Change getChange(@NotNull Project project) {
        if (project == null) {
            ShelvedWrapper.$$$reportNull$$$0(2);
        }
        return this.myShelvedChange != null ? this.myShelvedChange.getChange() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).createChange(project);
    }

    @Nullable
    public VirtualFile getBeforeVFUnderProject(@NotNull Project project) {
        if (project == null) {
            ShelvedWrapper.$$$reportNull$$$0(3);
        }
        if (this.getBeforePath() == null || project.getBasePath() == null) {
            return null;
        }
        File baseDir = new File(project.getBasePath());
        File file = new File(baseDir, this.getBeforePath());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getChange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeforeVFUnderProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

