/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class CompositeChangeListFilteringStrategy
implements ChangeListFilteringStrategy {
    private final TreeMap<CommittedChangesFilterKey, ChangeListFilteringStrategy> myDelegates = new TreeMap();
    private boolean myInSetBase = false;

    public JComponent getFilterUI() {
        return null;
    }

    public CommittedChangesFilterKey getKey() {
        throw new UnsupportedOperationException();
    }

    public void setFilterBase(List<? extends CommittedChangeList> changeLists) {
        this.setFilterBaseImpl(changeLists, true);
    }

    private List<CommittedChangeList> setFilterBaseImpl(List<? extends CommittedChangeList> changeLists, boolean setFirst) {
        List<Object> list = new ArrayList<CommittedChangeList>(changeLists);
        if (this.myInSetBase) {
            return list;
        }
        this.myInSetBase = true;
        boolean callSetFilterBase = setFirst;
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            if (callSetFilterBase) {
                delegate.setFilterBase(list);
            }
            callSetFilterBase = true;
            list = delegate.filterChangeLists(list);
        }
        this.myInSetBase = false;
        return list;
    }

    public void addChangeListener(ChangeListener listener) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.addChangeListener(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.removeChangeListener(listener);
        }
    }

    public void resetFilterBase() {
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.resetFilterBase();
        }
    }

    public void appendFilterBase(List<? extends CommittedChangeList> changeLists) {
        List<Object> list = new ArrayList<CommittedChangeList>(changeLists);
        for (ChangeListFilteringStrategy delegate : this.myDelegates.values()) {
            delegate.appendFilterBase(list);
            list = delegate.filterChangeLists(list);
        }
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<? extends CommittedChangeList> changeLists) {
        List<CommittedChangeList> list = this.setFilterBaseImpl(changeLists, false);
        if (list == null) {
            CompositeChangeListFilteringStrategy.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void addStrategy(CommittedChangesFilterKey key, ChangeListFilteringStrategy strategy) {
        this.myDelegates.put(key, strategy);
    }

    public ChangeListFilteringStrategy removeStrategy(CommittedChangesFilterKey key) {
        return this.myDelegates.remove(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CompositeChangeListFilteringStrategy", "filterChangeLists"));
    }
}

