/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.interfaces.EditorConfigHeaderElement;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveHeaderElementQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.editorconfig"})
public final class EditorConfigRemoveHeaderElementQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.header-element.remove.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (!(psiElement instanceof EditorConfigHeaderElement)) {
            psiElement = null;
        }
        EditorConfigHeaderElement editorConfigHeaderElement = (EditorConfigHeaderElement)psiElement;
        if (editorConfigHeaderElement == null) {
            return;
        }
        EditorConfigHeaderElement pattern = editorConfigHeaderElement;
        EditorConfigHeader header = pattern.getHeader();
        IntRange globalRange = EditorConfigPsiTreeUtil.INSTANCE.findRemovableRange(pattern);
        TextRange textRange = header.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"header.textRange");
        int headerOffset = textRange.getStartOffset();
        int n = globalRange.getStart() - headerOffset;
        IntRange parentRange = new IntRange(n, globalRange.getEndInclusive() - headerOffset);
        String string = header.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header.text");
        CharSequence text = string;
        CharSequence newText = StringsKt.removeRange((CharSequence)text, (IntRange)parentRange);
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigHeader newHeader = factory.createHeader(newText);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(header, newHeader){
            final /* synthetic */ EditorConfigHeader $header;
            final /* synthetic */ EditorConfigHeader $newHeader;

            public final void run() {
                this.$header.replace(this.$newHeader);
            }
            {
                this.$header = editorConfigHeader;
                this.$newHeader = editorConfigHeader2;
            }
        });
    }
}

