/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Experiments {
    public static final ExtensionPointName<ExperimentalFeature> EP_NAME = ExtensionPointName.create((String)"com.intellij.experimentalFeature");
    private static final Logger LOG = Logger.getInstance(Experiments.class);
    private static final Map<String, Boolean> myCache = ContainerUtil.newConcurrentMap();

    public static boolean isFeatureEnabled(String featureId) {
        if (ApplicationManager.getApplication() == null) {
            return false;
        }
        Boolean result = myCache.get(featureId);
        if (result == null) {
            result = Experiments.calcIsFeatureEnabled(featureId);
            myCache.put(featureId, result);
        }
        return result;
    }

    private static boolean calcIsFeatureEnabled(String featureId) {
        ExperimentalFeature feature = Experiments.getFeatureById(featureId);
        if (feature != null) {
            String key = Experiments.toPropertyKey(feature);
            if (PropertiesComponent.getInstance().isValueSet(key)) {
                return PropertiesComponent.getInstance().getBoolean(key, false);
            }
            return feature.isEnabled();
        }
        return false;
    }

    public static void setFeatureEnabled(String featureId, boolean enabled) {
        ExperimentalFeature feature = Experiments.getFeatureById(featureId);
        if (feature != null) {
            myCache.put(featureId, enabled);
            String key = Experiments.toPropertyKey(feature);
            PropertiesComponent.getInstance().setValue(key, enabled, feature.isEnabled());
            LOG.info("Experimental feature '" + featureId + "' is now turned " + (enabled ? "ON" : "OFF"));
        }
    }

    @Nullable
    private static ExperimentalFeature getFeatureById(String featureId) {
        for (ExperimentalFeature feature : (ExperimentalFeature[])EP_NAME.getExtensions()) {
            if (!feature.id.equals(featureId)) continue;
            return feature;
        }
        return null;
    }

    public static boolean isChanged(String featureId) {
        ExperimentalFeature feature = Experiments.getFeatureById(featureId);
        return feature != null && feature.isEnabled() != Experiments.isFeatureEnabled(featureId);
    }

    private static String toPropertyKey(ExperimentalFeature feature) {
        return "experimentalFeature." + feature.id;
    }
}

