/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlImpl
implements Url {
    private final String scheme;
    private final String authority;
    private final String path;
    private String decodedPath;
    private final String parameters;
    private String externalForm;
    private UrlImpl withoutParameters;

    @Deprecated
    public UrlImpl(@NotNull String path) {
        if (path == null) {
            UrlImpl.$$$reportNull$$$0(0);
        }
        this(null, null, path, null);
    }

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path) {
        this(scheme, authority, path, null);
    }

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String parameters) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = StringUtil.notNullize((String)path);
        this.parameters = StringUtil.nullize((String)parameters);
    }

    @Override
    public Url resolve(@NotNull String subPath) {
        if (subPath == null) {
            UrlImpl.$$$reportNull$$$0(1);
        }
        return new UrlImpl(this.scheme, this.authority, this.path.isEmpty() ? subPath : this.path + "/" + subPath, this.parameters);
    }

    @Override
    @NotNull
    public Url addParameters(@NotNull Map<String, String> parameters) {
        if (parameters == null) {
            UrlImpl.$$$reportNull$$$0(2);
        }
        if (parameters.isEmpty()) {
            UrlImpl urlImpl = this;
            if (urlImpl == null) {
                UrlImpl.$$$reportNull$$$0(3);
            }
            return urlImpl;
        }
        StringBuilder builder = new StringBuilder();
        if (this.parameters == null) {
            builder.append('?');
        } else {
            builder.append(this.parameters);
            builder.append('&');
        }
        Urls.encodeParameters(parameters, builder);
        UrlImpl urlImpl = new UrlImpl(this.scheme, this.authority, this.path, builder.toString());
        if (urlImpl == null) {
            UrlImpl.$$$reportNull$$$0(4);
        }
        return urlImpl;
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.decodedPath == null) {
            this.decodedPath = URLUtil.unescapePercentSequences((String)this.path);
        }
        String string = this.decodedPath;
        if (string == null) {
            UrlImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public boolean isInLocalFileSystem() {
        return "file".equals(this.scheme);
    }

    @Override
    @Nullable
    public String getParameters() {
        return this.parameters;
    }

    @Override
    public String toDecodedForm() {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            builder.append(this.scheme);
            if (this.authority == null) {
                builder.append(':');
            } else {
                builder.append("://");
            }
            if (this.authority != null) {
                builder.append(this.authority);
            }
        }
        builder.append(this.getPath());
        if (this.parameters != null) {
            builder.append(this.parameters);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String toExternalForm() {
        if (this.externalForm != null) {
            String string = this.externalForm;
            if (string == null) {
                UrlImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        if ((this.authority == null || !this.path.isEmpty() && this.path.charAt(0) != '/') && !this.isInLocalFileSystem()) {
            String string = this.toDecodedForm();
            if (string == null) {
                UrlImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        String result = Urls.toUriWithoutParameters(this).toASCIIString();
        if (this.parameters != null) {
            result = result + this.parameters;
        }
        this.externalForm = result;
        String string = result;
        if (string == null) {
            UrlImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public Url trimParameters() {
        if (this.parameters == null) {
            UrlImpl urlImpl = this;
            if (urlImpl == null) {
                UrlImpl.$$$reportNull$$$0(9);
            }
            return urlImpl;
        }
        if (this.withoutParameters == null) {
            this.withoutParameters = new UrlImpl(this.scheme, this.authority, this.path, null);
        }
        UrlImpl urlImpl = this.withoutParameters;
        if (urlImpl == null) {
            UrlImpl.$$$reportNull$$$0(10);
        }
        return urlImpl;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equals((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equals((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equals(url.getPath()) && StringUtil.equals((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    @Override
    public boolean equalsIgnoreCase(@Nullable Url o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equalsIgnoreCase((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equalsIgnoreCase((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equalsIgnoreCase(url.getPath()) && StringUtil.equalsIgnoreCase((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    @Override
    public boolean equalsIgnoreParameters(@Nullable Url url) {
        return url != null && this.equals(url.trimParameters());
    }

    private int computeHashCode(boolean caseSensitive) {
        int result = UrlImpl.stringHashCode(this.scheme, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.authority, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.getPath(), caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.parameters, caseSensitive);
        return result;
    }

    private static int stringHashCode(@Nullable CharSequence string, boolean caseSensitive) {
        return string == null ? 0 : (caseSensitive ? string.hashCode() : StringUtil.stringHashCodeInsensitive((CharSequence)string));
    }

    public int hashCode() {
        return this.computeHashCode(true);
    }

    @Override
    public int hashCodeCaseInsensitive() {
        return this.computeHashCode(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/UrlImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/UrlImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toExternalForm";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "trimParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

