/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DigestUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0007J\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\fH\u0007J\b\u0010\u0012\u001a\u00020\fH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/io/DigestUtil;", "", "()V", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "Lkotlin/Lazy;", "sunSecurityProvider", "Ljava/security/Provider;", "getMessageDigest", "Ljava/security/MessageDigest;", "algorithm", "", "md5", "randomToken", "sha1", "sha256", "intellij.platform.util.ex"})
public final class DigestUtil {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Provider sunSecurityProvider;
    @NotNull
    private static final Lazy random$delegate;
    public static final DigestUtil INSTANCE;

    static {
        DigestUtil digestUtil;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DigestUtil.class), "random", "getRandom()Ljava/security/SecureRandom;"))};
        INSTANCE = digestUtil = new DigestUtil();
        Provider provider = Security.getProvider("SUN");
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"java.security.Security.getProvider(\"SUN\")");
        sunSecurityProvider = provider;
        random$delegate = LazyKt.lazy((Function0)random.2.INSTANCE);
    }

    @NotNull
    public final SecureRandom getRandom() {
        Lazy lazy = random$delegate;
        DigestUtil digestUtil = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (SecureRandom)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest md5() {
        return INSTANCE.getMessageDigest("MD5");
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha1() {
        return INSTANCE.getMessageDigest("SHA-1");
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha256() {
        return INSTANCE.getMessageDigest("SHA-256");
    }

    @NotNull
    public final String randomToken() {
        String string = new BigInteger(130, this.getRandom()).toString(32);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BigInteger(130, random).toString(32)");
        return string;
    }

    private final MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, sunSecurityProvider);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"MessageDigest.getInstanc\u2026thm, sunSecurityProvider)");
        return messageDigest;
    }

    private DigestUtil() {
    }
}

