/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.BundleBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.AppleBoldDottedPainter;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.DetectRetinaKit;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.WavePainter;
import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.HeadlessToolkit;

public final class UIUtil
extends StartupUiUtil {
    public static final String BORDER_LINE = "<hr size=1 noshade>";
    public static final Key<Boolean> LAF_WITH_THEME_KEY = Key.create((String)"Laf.with.ui.theme");
    public static final boolean SUPPRESS_FOCUS_STEALING = Registry.is((String)"suppress.focus.stealing.linux") && Registry.is((String)"suppress.focus.stealing");
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl;
            if (!SystemInfo.isXWindow) {
                Boolean bl2 = false;
                if (bl2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return bl2;
            }
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                bl = (Boolean)method.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                Boolean bl3 = false;
                if (bl3 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return bl3;
            }
            if (bl == null) {
                1.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
        }
    };
    private static final String[] STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    public static final char MNEMONIC = '\u001b';
    @NonNls
    public static final String HTML_MIME = "text/html";
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String ARIAL_FONT_NAME = "Arial";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    @NonNls
    public static final String HIDE_EDITOR_FROM_DATA_CONTEXT_PROPERTY = "AuxEditorComponent";
    @NonNls
    public static final String CENTER_TOOLTIP_DEFAULT = "ToCenterTooltip";
    @NonNls
    public static final String CENTER_TOOLTIP_STRICT = "ToCenterTooltip.default";
    private static final Pattern CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
    @NonNls
    private static final String FOCUS_PROXY_KEY = "isFocusProxy";
    public static final Key<Integer> KEEP_BORDER_SIDES = Key.create((String)"keepBorderSides");
    private static final Key<UndoManager> UNDO_MANAGER = Key.create((String)"undoManager");
    private static final AbstractAction REDO_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            UndoManager manager;
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            if ((manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER)) != null && manager.canRedo()) {
                manager.redo();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/UIUtil$2", "actionPerformed"));
        }
    };
    private static final AbstractAction UNDO_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            UndoManager manager;
            if (e == null) {
                3.$$$reportNull$$$0(0);
            }
            if ((manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER)) != null && manager.canUndo()) {
                manager.undo();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/UIUtil$3", "actionPerformed"));
        }
    };
    private static final Color ACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.active", 10533589);
    private static final Color INACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.inactive", Gray._128);
    public static final Color CONTRAST_BORDER_COLOR = JBColor.namedColor("Borders.ContrastBorderColor", new JBColor(0xC9C9C9, 0x323232));
    public static final Color SIDE_PANEL_BACKGROUND = JBColor.namedColor("SidePanel.background", new JBColor(15133680, 4080460));
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._223, Gray.x51);
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
    public static final Color TRANSPARENT_COLOR = Gray.TRANSPARENT;
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 4;
    public static final int LARGE_VGAP = 12;
    public static final Insets PANEL_REGULAR_INSETS = JBInsets.create(8, 12);
    public static final Insets PANEL_SMALL_INSETS = JBInsets.create(5, 8);
    @NonNls
    private static final String ROOT_PANE = "JRootPane.future";
    private static final Ref<Boolean> ourRetina = Ref.create((Object)(SystemInfo.isMac ? null : Boolean.valueOf(false)));
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
    public static final int LIST_FIXED_CELL_HEIGHT = 20;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS = Key.create((String)"NOT_IN_HIERARCHY_COMPONENTS");
    private static final JBTreeTraverser<Component> UI_TRAVERSER = JBTreeTraverser.from(c -> {
        JBIterable result = c instanceof JMenu ? JBIterable.of((Object[])((JMenu)c).getMenuComponents()) : (c instanceof JComboBox && UIUtil.isUnderAquaLookAndFeel() ? JBIterable.empty() : UIUtil.uiChildren(c));
        if (c instanceof JComponent) {
            JPopupMenu jpm;
            JComponent jc = (JComponent)c;
            Iterable<? extends Component> orphans = UIUtil.getClientProperty((Object)jc, NOT_IN_HIERARCHY_COMPONENTS);
            if (orphans != null) {
                result = result.append(orphans);
            }
            if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                result = result.append(Collections.singletonList(jpm));
            }
        }
        return result;
    });
    private static final Function.Mono<Component> COMPONENT_PARENT = new Function.Mono<Component>(){

        public Component fun(Component c) {
            return c.getParent();
        }
    };
    private static final Color DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
    private static final DocumentAdapter SET_TEXT_CHECKER = new DocumentAdapter(){

        @Override
        protected void textChanged(@NotNull DocumentEvent e) {
            Document document;
            if (e == null) {
                11.$$$reportNull$$$0(0);
            }
            if ((document = e.getDocument()) instanceof AbstractDocument) {
                StackTraceElement[] stackTrace;
                for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                    UndoableEditListener[] undoableEditListeners;
                    if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                    for (UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                        if (!(listener instanceof UndoManager)) continue;
                        Runnable runnable = ((UndoManager)listener)::discardAllEdits;
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/UIUtil$11", "textChanged"));
        }
    };
    public static final String CHECKBOX_ROLLOVER_PROPERTY = "JCheckBox.rollOver.rectangle";
    public static final String CHECKBOX_PRESSED_PROPERTY = "JCheckBox.pressed.rectangle";
    private static final Color BACKGROUND = new JBColor(0xFFFFFF, 3948353);
    private static final Color LIST_BACKGROUND = JBColor.namedColor("List.background", BACKGROUND);
    private static final Color TREE_BACKGROUND = JBColor.namedColor("Tree.background", BACKGROUND);
    private static final Color TABLE_BACKGROUND = JBColor.namedColor("Table.background", BACKGROUND);
    private static final JBValue SELECTED_ITEM_ALPHA = new JBValue.UIInteger("List.selectedItemAlpha", 75);

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.util.ui.UIUtil");
        if (logger == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @Deprecated
    public static void decorateFrame(@NotNull JRootPane pane) {
        if (pane == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        UIUtil.decorateWindowHeader(pane);
    }

    public static void decorateWindowHeader(JRootPane pane) {
        if (pane != null && SystemInfo.isMac) {
            pane.putClientProperty("jetbrains.awt.windowDarkAppearance", Registry.is((String)"ide.mac.allowDarkWindowDecorations") && UIUtil.isUnderDarcula());
        }
    }

    public static void markAsTypeAheadAware(Window window) {
        UIUtil.putWindowClientProperty(window, "TypeAheadAwareWindow", Boolean.TRUE);
    }

    public static boolean isTypeAheadAware(Window window) {
        return UIUtil.isWindowClientPropertyTrue(window, "TypeAheadAwareWindow");
    }

    public static void markAsPossibleOwner(Dialog dialog) {
        UIUtil.putWindowClientProperty(dialog, "PossibleOwner", Boolean.TRUE);
    }

    public static boolean isPossibleOwner(@NotNull Dialog dialog) {
        if (dialog == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        return UIUtil.isWindowClientPropertyTrue(dialog, "PossibleOwner");
    }

    public static int getMultiClickInterval() {
        Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return 500;
    }

    public static void applyStyle(@NotNull ComponentStyle componentStyle, @NotNull Component comp) {
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        if (comp == null) {
            UIUtil.$$$reportNull$$$0(4);
        }
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (UIUtil.isUnderAquaBasedLookAndFeel()) {
            c.putClientProperty("JComponent.sizeVariant", StringUtil.toLowerCase((String)componentStyle.name()));
        }
        FontSize fontSize = componentStyle == ComponentStyle.MINI ? FontSize.MINI : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.NORMAL);
        c.setFont(UIUtil.getFont(fontSize, c.getFont()));
        Container p = c.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    @NotNull
    public static Cursor getTextCursor(@NotNull Color backgroundColor) {
        if (backgroundColor == null) {
            UIUtil.$$$reportNull$$$0(5);
        }
        Cursor cursor = SystemInfo.isMac && ColorUtil.isDark(backgroundColor) ? MacUIUtil.getInvertedTextCursor() : Cursor.getPredefinedCursor(2);
        if (cursor == null) {
            UIUtil.$$$reportNull$$$0(6);
        }
        return cursor;
    }

    @Nullable
    public static Cursor cursorIfNotDefault(@Nullable Cursor cursorToSet) {
        return cursorToSet != null && cursorToSet.getType() != 0 ? cursorToSet : null;
    }

    @NotNull
    public static RGBImageFilter getGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("grayFilter", new GrayFilter(33, -35, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return grayFilter;
    }

    @NotNull
    public static RGBImageFilter getTextGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("text.grayFilter", new GrayFilter(20, 0, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(8);
        }
        return grayFilter;
    }

    public static boolean isMinimized(Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)window;
        return frame.getExtendedState() == 1;
    }

    @Deprecated
    public static boolean isAppleRetina() {
        return false;
    }

    @NotNull
    public static Couple<Color> getCellColors(@NotNull JTable table, boolean isSel, int row, int column) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        Couple couple = Couple.of((Object)(isSel ? table.getSelectionForeground() : table.getForeground()), (Object)(isSel ? table.getSelectionBackground() : table.getBackground()));
        if (couple == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        return couple;
    }

    public static void fixOSXEditorBackground(@NotNull JTable table) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(11);
        }
        if (!SystemInfo.isMac) {
            return;
        }
        if (table.isEditing()) {
            int column = table.getEditingColumn();
            int row = table.getEditingRow();
            Component renderer = column >= 0 && row >= 0 ? table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), true, table.hasFocus(), row, column) : null;
            Component component = table.getEditorComponent();
            if (component != null && renderer != null) {
                UIUtil.changeBackGround(component, renderer.getBackground());
            }
        }
    }

    public static boolean isDialogFont(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        return "Dialog".equals(font.getFamily(Locale.US));
    }

    private UIUtil() {
    }

    public static boolean isRetina(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(13);
        }
        return SystemInfo.isMac ? DetectRetinaKit.isMacRetina(graphics) : UIUtil.isRetina();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        if (Registry.is((String)"new.retina.detection")) {
            return DetectRetinaKit.isRetina();
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set((Object)false);
                try {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    Integer scale = (Integer)ReflectionUtil.getField(device.getClass(), (Object)device, Integer.TYPE, (String)"scale");
                    if (scale != null && scale == 2) {
                        ourRetina.set((Object)true);
                        return true;
                    }
                }
                catch (AWTError | Exception throwable) {
                    // empty catch block
                }
                ourRetina.set((Object)false);
            }
            return (Boolean)ourRetina.get();
        }
    }

    public static boolean hasLeakingAppleListeners() {
        return SystemInfo.isMac && System.getProperty("java.runtime.version").startsWith("1.6.0_29");
    }

    public static void removeLeakingAppleListeners() {
        if (!UIUtil.hasLeakingAppleListeners()) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String name = "apple.awt.contentScaleFactor";
        for (PropertyChangeListener each : toolkit.getPropertyChangeListeners(name)) {
            toolkit.removePropertyChangeListener(name, each);
        }
    }

    public static boolean isWindowClientPropertyTrue(Window window, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(14);
        }
        return Boolean.TRUE.equals(UIUtil.getWindowClientProperty(window, key));
    }

    public static Object getWindowClientProperty(Window window, @NotNull Object key) {
        JRootPane pane;
        if (key == null) {
            UIUtil.$$$reportNull$$$0(15);
        }
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return pane.getClientProperty(key);
        }
        return null;
    }

    public static void putWindowClientProperty(Window window, @NotNull Object key, Object value) {
        JRootPane pane;
        if (key == null) {
            UIUtil.$$$reportNull$$$0(16);
        }
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            pane.putClientProperty(key, value);
        }
    }

    public static boolean isClientPropertyTrue(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(17);
        }
        return Boolean.TRUE.equals(UIUtil.getClientProperty(component, key));
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(18);
        }
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Class<T> type) {
        if (type == null) {
            UIUtil.$$$reportNull$$$0(19);
        }
        return (T)ObjectUtils.tryCast((Object)UIUtil.getClientProperty(component, type), type);
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(20);
        }
        return (T)UIUtil.getClientProperty(component, key);
    }

    public static <T> void putClientProperty(@NotNull JComponent component, @NotNull Key<T> key, T value) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(21);
        }
        if (key == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        component.putClientProperty(key, value);
    }

    @NotNull
    public static String getHtmlBody(@NotNull String text) {
        int bodyIndex;
        int htmlIndex;
        if (text == null) {
            UIUtil.$$$reportNull$$$0(23);
        }
        if ((htmlIndex = 6 + text.indexOf("<html>")) < 6) {
            String string = text.replaceAll("\n", "<br>");
            if (string == null) {
                UIUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        int htmlCloseIndex = text.indexOf("</html>", htmlIndex);
        if (htmlCloseIndex < 0) {
            htmlCloseIndex = text.length();
        }
        if ((bodyIndex = 6 + text.indexOf("<body>", htmlIndex)) < 6) {
            String string = text.substring(htmlIndex, htmlCloseIndex);
            if (string == null) {
                UIUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        int bodyCloseIndex = text.indexOf("</body>", bodyIndex);
        if (bodyCloseIndex < 0) {
            bodyCloseIndex = text.length();
        }
        String string = text.substring(bodyIndex, Math.min(bodyCloseIndex, htmlCloseIndex));
        if (string == null) {
            UIUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getHtmlBody(@NotNull Html html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(27);
        }
        String result = UIUtil.getHtmlBody(html.getText());
        String string = html.isKeepFont() ? result : result.replaceAll("<font(.*?)>", "").replaceAll("</font>", "");
        if (string == null) {
            UIUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static void drawLinePickedOut(@NotNull Graphics graphics, int x, int y, int x1, int y1) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(29);
        }
        if (x == x1) {
            int minY = Math.min(y, y1);
            int maxY = Math.max(y, y1);
            UIUtil.drawLine(graphics, x, minY + 1, x1, maxY - 1);
        } else if (y == y1) {
            int minX = Math.min(x, x1);
            int maxX = Math.max(x, x1);
            UIUtil.drawLine(graphics, minX + 1, y, maxX - 1, y1);
        } else {
            UIUtil.drawLine(graphics, x, y, x1, y1);
        }
    }

    public static boolean isReallyTypedEvent(@NotNull KeyEvent e) {
        char c;
        if (e == null) {
            UIUtil.$$$reportNull$$$0(30);
        }
        if ((c = e.getKeyChar()) < ' ' || c == '\u007f') {
            return false;
        }
        if (SystemInfo.isWindows && c >= '\u200c' && c <= '\u200f') {
            return true;
        }
        if (SystemInfo.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return !e.isAltDown() && !e.isControlDown();
    }

    public static int getStringY(@NotNull String string, @NotNull Rectangle bounds, @NotNull Graphics2D g) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(31);
        }
        if (bounds == null) {
            UIUtil.$$$reportNull$$$0(32);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(33);
        }
        int centerY = bounds.height / 2;
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle stringBounds = font.getStringBounds(string, frc).getBounds();
        return (int)((double)centerY - (double)stringBounds.height / 2.0 - (double)stringBounds.y);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(34);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(35);
        }
        UIUtil.drawLabelDottedRectangle(label, g, null);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g, @Nullable Rectangle bounds) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(36);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(37);
        }
        if (bounds == null) {
            bounds = UIUtil.getLabelTextBounds(label);
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int baseLine = label.getUI().getBaseline(label, label.getWidth(), label.getHeight());
        int textY = baseLine - fm.getLeading() - fm.getAscent();
        int textHeight = fm.getHeight();
        UIUtil.drawDottedRectangle(g, bounds.x, textY, bounds.x + bounds.width - 1, textY + textHeight - 1);
    }

    @NotNull
    public static Rectangle getLabelTextBounds(@NotNull JLabel label) {
        if (label == null) {
            UIUtil.$$$reportNull$$$0(38);
        }
        Dimension size = label.getPreferredSize();
        Icon icon = label.getIcon();
        Point point = new Point(0, 0);
        Insets insets = label.getInsets();
        if (icon != null) {
            if (label.getHorizontalTextPosition() == 11) {
                point.x += label.getIconTextGap();
                point.x += icon.getIconWidth();
            } else if (label.getHorizontalTextPosition() == 10) {
                size.width -= icon.getIconWidth();
            }
        }
        point.x += insets.left;
        point.y += insets.top;
        size.width -= point.x;
        size.width -= insets.right;
        size.height -= insets.bottom;
        Rectangle rectangle = new Rectangle(point, size);
        if (rectangle == null) {
            UIUtil.$$$reportNull$$$0(39);
        }
        return rectangle;
    }

    public static int getHighestGlyphHeight(@NotNull String string, @NotNull Font font, @NotNull Graphics graphics) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(40);
        }
        if (font == null) {
            UIUtil.$$$reportNull$$$0(41);
        }
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(42);
        }
        FontRenderContext frc = ((Graphics2D)graphics).getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string);
        int maxHeight = 0;
        for (int i = 0; i < string.length(); ++i) {
            maxHeight = Math.max(maxHeight, (int)gv.getGlyphMetrics(i).getBounds2D().getHeight());
        }
        return maxHeight;
    }

    public static void setEnabled(@NotNull Component component, boolean enabled, boolean recursively) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(43);
        }
        UIUtil.setEnabled(component, enabled, recursively, false);
    }

    public static void setEnabled(@NotNull Component component, boolean enabled, boolean recursively, boolean visibleOnly) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(44);
        }
        JBIterable all = recursively ? ((JBTreeTraverser)UIUtil.uiTraverser(component).expandAndFilter(visibleOnly ? Component::isVisible : Conditions.alwaysTrue())).traverse() : JBIterable.of((Object)component);
        Color fg = enabled ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        for (Component c : all) {
            c.setEnabled(enabled);
            if (!(c instanceof JLabel)) continue;
            c.setForeground(fg);
        }
    }

    @Deprecated
    public static void drawLine(@NotNull Graphics g, int x1, int y1, int x2, int y2) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(45);
        }
        LinePainter2D.paint((Graphics2D)g, x1, y1, (double)x2, y2);
    }

    public static void drawLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, @Nullable Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(46);
        }
        Color oldFg = g.getColor();
        Color oldBg = g.getBackground();
        if (fgColor != null) {
            g.setColor(fgColor);
        }
        if (bgColor != null) {
            g.setBackground(bgColor);
        }
        LinePainter2D.paint(g, x1, y1, (double)x2, y2);
        if (fgColor != null) {
            g.setColor(oldFg);
        }
        if (bgColor != null) {
            g.setBackground(oldBg);
        }
    }

    public static void drawWave(@NotNull Graphics2D g, @NotNull Rectangle rectangle) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(47);
        }
        if (rectangle == null) {
            UIUtil.$$$reportNull$$$0(48);
        }
        WavePainter.forColor(g.getColor()).paint(g, (int)rectangle.getMinX(), (int)rectangle.getMaxX(), (int)rectangle.getMaxY());
    }

    @NotNull
    public static String[] splitText(@NotNull String text, @NotNull FontMetrics fontMetrics, int widthLimit, char separator) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(49);
        }
        if (fontMetrics == null) {
            UIUtil.$$$reportNull$$$0(50);
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        StringBuilder currentAtom = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String s;
            int width;
            char ch = text.charAt(i);
            currentAtom.append(ch);
            if (ch == separator) {
                currentLine.append(currentAtom.toString());
                currentAtom.setLength(0);
            }
            if ((width = fontMetrics.stringWidth(s = currentLine.toString() + currentAtom)) < widthLimit - fontMetrics.charWidth('w')) continue;
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
                continue;
            }
            lines.add(currentAtom.toString());
            currentAtom.setLength(0);
        }
        String s = currentLine.toString() + currentAtom;
        if (!s.isEmpty()) {
            lines.add(s);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(lines);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(51);
        }
        return stringArray;
    }

    public static void setActionNameAndMnemonic(@NotNull String text, @NotNull Action action) {
        if (text == null) {
            UIUtil.$$$reportNull$$$0(52);
        }
        if (action == null) {
            UIUtil.$$$reportNull$$$0(53);
        }
        UIUtil.assignMnemonic(text, action);
        text = text.replaceAll("&", "");
        action.putValue("Name", text);
    }

    public static void assignMnemonic(@NotNull String text, @NotNull Action action) {
        String mnemoChar;
        int mnemoPos;
        if (text == null) {
            UIUtil.$$$reportNull$$$0(54);
        }
        if (action == null) {
            UIUtil.$$$reportNull$$$0(55);
        }
        if ((mnemoPos = text.indexOf(38)) >= 0 && mnemoPos < text.length() - 2 && (mnemoChar = text.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
    }

    @NotNull
    public static Font getLabelFont(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(56);
        }
        Font font = UIUtil.getFont(size, null);
        if (font == null) {
            UIUtil.$$$reportNull$$$0(57);
        }
        return font;
    }

    @NotNull
    public static Font getFont(@NotNull FontSize size, @Nullable Font base) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(58);
        }
        if (base == null) {
            base = UIUtil.getLabelFont();
        }
        Font font = base.deriveFont(UIUtil.getFontSize(size));
        if (font == null) {
            UIUtil.$$$reportNull$$$0(59);
        }
        return font;
    }

    public static float getFontSize(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(60);
        }
        int defSize = UIUtil.getLabelFont().getSize();
        switch (size) {
            case SMALL: {
                return Math.max((float)defSize - JBUIScale.scale(2.0f), JBUIScale.scale(11.0f));
            }
            case MINI: {
                return Math.max((float)defSize - JBUIScale.scale(4.0f), JBUIScale.scale(9.0f));
            }
        }
        return defSize;
    }

    @NotNull
    public static Color getLabelFontColor(@NotNull FontColor fontColor) {
        if (fontColor == null) {
            UIUtil.$$$reportNull$$$0(61);
        }
        Color defColor = UIUtil.getLabelForeground();
        if (fontColor == FontColor.BRIGHTER) {
            JBColor jBColor = new JBColor(new Color(Math.min(defColor.getRed() + 50, 255), Math.min(defColor.getGreen() + 50, 255), Math.min(defColor.getBlue() + 50, 255)), defColor.darker());
            if (jBColor == null) {
                UIUtil.$$$reportNull$$$0(62);
            }
            return jBColor;
        }
        Color color = defColor;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(63);
        }
        return color;
    }

    public static int getCheckBoxTextHorizontalOffset(@NotNull JCheckBox cb) {
        if (cb == null) {
            UIUtil.$$$reportNull$$$0(64);
        }
        ButtonUI ui = cb.getUI();
        String text = cb.getText();
        Icon buttonIcon = cb.getIcon();
        if (buttonIcon == null && ui != null) {
            if (ui instanceof BasicRadioButtonUI) {
                buttonIcon = ((BasicRadioButtonUI)ui).getDefaultIcon();
            } else if (UIUtil.isUnderAquaLookAndFeel()) {
                Method method;
                Ref cached = ourDefaultIconMethodsCache.get(ui.getClass());
                if (cached == null) {
                    cached = Ref.create((Object)ReflectionUtil.findMethod(Arrays.asList(ui.getClass().getMethods()), (String)"getDefaultIcon", (Class[])new Class[]{JComponent.class}));
                    ourDefaultIconMethodsCache.put(ui.getClass(), (Ref<Method>)cached);
                    if (!cached.isNull()) {
                        ((Method)cached.get()).setAccessible(true);
                    }
                }
                if ((method = (Method)cached.get()) != null) {
                    try {
                        buttonIcon = (Icon)method.invoke((Object)ui, cb);
                    }
                    catch (Exception e) {
                        cached.set(null);
                    }
                }
            }
        }
        Dimension size = new Dimension();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = cb.getInsets();
        size = cb.getSize(size);
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = size.width - (i.right + viewRect.x);
        viewRect.height = size.height - (i.bottom + viewRect.y);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        SwingUtilities.layoutCompoundLabel(cb, cb.getFontMetrics(cb.getFont()), text, buttonIcon, cb.getVerticalAlignment(), cb.getHorizontalAlignment(), cb.getVerticalTextPosition(), cb.getHorizontalTextPosition(), viewRect, iconRect, textRect, text == null ? 0 : cb.getIconTextGap());
        return textRect.x;
    }

    public static int getScrollBarWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    @NotNull
    public static Color getLabelForeground() {
        JBColor jBColor = JBColor.namedColor("Label.foreground", new JBColor(Gray._0, Gray.xBB));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(65);
        }
        return jBColor;
    }

    @NotNull
    public static Color getLabelDisabledForeground() {
        JBColor jBColor = JBColor.namedColor("Label.disabledForeground", JBColor.GRAY);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(66);
        }
        return jBColor;
    }

    @NotNull
    public static Color getContextHelpForeground() {
        JBColor jBColor = JBColor.namedColor("Label.infoForeground", new JBColor(Gray.x78, Gray.x8C));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(67);
        }
        return jBColor;
    }

    @NotNull
    public static String removeMnemonic(@NotNull String s) {
        if (s == null) {
            UIUtil.$$$reportNull$$$0(68);
        }
        if (s.indexOf(38) != -1) {
            s = StringUtil.replace((String)s, (String)"&", (String)"");
        }
        if (s.indexOf(95) != -1) {
            s = StringUtil.replace((String)s, (String)"_", (String)"");
        }
        if (s.indexOf(27) != -1) {
            s = StringUtil.replace((String)s, (String)String.valueOf('\u001b'), (String)"");
        }
        String string = s;
        if (string == null) {
            UIUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    public static int getDisplayMnemonicIndex(@NotNull String s) {
        int idx;
        if (s == null) {
            UIUtil.$$$reportNull$$$0(70);
        }
        if ((idx = s.indexOf(38)) >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(38)) {
            return idx;
        }
        idx = s.indexOf(27);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(27)) {
            return idx;
        }
        return -1;
    }

    public static String replaceMnemonicAmpersand(String value) {
        return BundleBase.replaceMnemonicAmpersand((String)value);
    }

    public static Color getTableHeaderBackground() {
        return UIManager.getColor("TableHeader.background");
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextForeground() {
        Color color = UIUtil.getTreeForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(71);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextBackground() {
        Color color = UIUtil.getTreeBackground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(72);
        }
        return color;
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    @NotNull
    public static Color getInactiveTextColor() {
        JBColor jBColor = JBColor.namedColor("Component.infoForeground", new JBColor(Gray.x99, Gray.x78));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(73);
        }
        return jBColor;
    }

    @Deprecated
    public static Color getActiveTextFieldBackgroundColor() {
        return UIUtil.getTextFieldBackground();
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    @Deprecated
    @NotNull
    public static Color getTextInactiveTextColor() {
        Color color = UIUtil.getInactiveTextColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(74);
        }
        return color;
    }

    public static void installPopupMenuColorAndFonts(@NotNull JComponent contentPane) {
        if (contentPane == null) {
            UIUtil.$$$reportNull$$$0(75);
        }
        LookAndFeel.installColorsAndFont(contentPane, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    public static void installPopupMenuBorder(@NotNull JComponent contentPane) {
        if (contentPane == null) {
            UIUtil.$$$reportNull$$$0(76);
        }
        LookAndFeel.installBorder(contentPane, "PopupMenu.border");
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static int getTreeRightChildIndent() {
        return UIManager.getInt("Tree.rightChildIndent");
    }

    public static int getTreeLeftChildIndent() {
        return UIManager.getInt("Tree.leftChildIndent");
    }

    @NotNull
    public static Color getToolTipBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.background", new JBColor(Gray.xF2, new Color(3948353)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(77);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipActionBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.Actions.background", new JBColor(Gray.xEB, new Color(4409162)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(78);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipForeground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.foreground", new JBColor(Gray.x00, Gray.xBB));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(79);
        }
        return jBColor;
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(@NotNull String propertyPrefix) {
        if (propertyPrefix == null) {
            UIUtil.$$$reportNull$$$0(80);
        }
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(81);
        }
        return c.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static Color getTableGridColor() {
        return UIManager.getColor("Table.gridColor");
    }

    @NotNull
    public static Color getPanelBackground() {
        Color color = JBColor.PanelBackground;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(82);
        }
        return color;
    }

    public static Color getEditorPaneBackground() {
        return UIManager.getColor("EditorPane.background");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static Color getTabbedPaneBackground() {
        return UIManager.getColor("TabbedPane.background");
    }

    public static void setSliderIsFilled(@NotNull JSlider slider, boolean value) {
        if (slider == null) {
            UIUtil.$$$reportNull$$$0(83);
        }
        slider.putClientProperty(JSLIDER_ISFILLED, value);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.textForeground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    @Deprecated
    @NotNull
    public static Color getSeparatorForeground() {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(84);
        }
        return color;
    }

    public static Color getSeparatorBackground() {
        return UIManager.getColor("Separator.background");
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    public static Color getSeparatorHighlight() {
        return UIManager.getColor("Separator.highlight");
    }

    @Deprecated
    @NotNull
    public static Color getSeparatorColor() {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(85);
        }
        return color;
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    @Deprecated
    public static void setLineStyleAngled(@NotNull JTree component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(86);
        }
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon = (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.errorIcon"), (Object)AllIcons.General.ErrorDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(87);
        }
        return icon;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon = (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.informationIcon"), (Object)AllIcons.General.InformationDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(88);
        }
        return icon;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon = (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.questionIcon"), (Object)AllIcons.General.QuestionDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(89);
        }
        return icon;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon = (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.warningIcon"), (Object)AllIcons.General.WarningDialog);
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(90);
        }
        return icon;
    }

    @NotNull
    public static Icon getBalloonInformationIcon() {
        Icon icon = AllIcons.General.BalloonInformation;
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(91);
        }
        return icon;
    }

    @NotNull
    public static Icon getBalloonWarningIcon() {
        Icon icon = AllIcons.General.BalloonWarning;
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(92);
        }
        return icon;
    }

    @NotNull
    public static Icon getBalloonErrorIcon() {
        Icon icon = AllIcons.General.BalloonError;
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(93);
        }
        return icon;
    }

    public static Icon getRadioButtonIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    @NotNull
    public static Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || UIUtil.isUnderDarcula();
        Icon expandedDefault = UIUtil.getTreeExpandedIcon();
        Icon collapsedDefault = UIUtil.getTreeCollapsedIcon();
        Icon expandedSelected = UIUtil.getTreeSelectedExpandedIcon();
        Icon collapsedSelected = UIUtil.getTreeSelectedCollapsedIcon();
        int width = Math.max(Math.max(expandedDefault.getIconWidth(), collapsedDefault.getIconWidth()), Math.max(expandedSelected.getIconWidth(), collapsedSelected.getIconWidth()));
        int height = Math.max(Math.max(expandedDefault.getIconHeight(), collapsedDefault.getIconHeight()), Math.max(expandedSelected.getIconHeight(), collapsedSelected.getIconHeight()));
        CenteredIcon centeredIcon = new CenteredIcon(!white ? (expanded ? expandedDefault : collapsedDefault) : (expanded ? expandedSelected : collapsedSelected), width, height, false);
        if (centeredIcon == null) {
            UIUtil.$$$reportNull$$$0(94);
        }
        return centeredIcon;
    }

    @NotNull
    public static Icon getTreeCollapsedIcon() {
        Icon icon = UIManager.getIcon("Tree.collapsedIcon");
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(95);
        }
        return icon;
    }

    @NotNull
    public static Icon getTreeExpandedIcon() {
        Icon icon = UIManager.getIcon("Tree.expandedIcon");
        if (icon == null) {
            UIUtil.$$$reportNull$$$0(96);
        }
        return icon;
    }

    @Deprecated
    public static Icon getTreeIcon(boolean expanded) {
        return expanded ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon();
    }

    @NotNull
    public static Icon getTreeSelectedCollapsedIcon() {
        Icon icon = UIManager.getIcon("Tree.collapsedSelectedIcon");
        Icon icon2 = icon != null ? icon : UIUtil.getTreeCollapsedIcon();
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(97);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeSelectedExpandedIcon() {
        Icon icon = UIManager.getIcon("Tree.expandedSelectedIcon");
        Icon icon2 = icon != null ? icon : UIUtil.getTreeExpandedIcon();
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(98);
        }
        return icon2;
    }

    public static Border getTableHeaderCellBorder() {
        return UIManager.getBorder("TableHeader.cellBorder");
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    @Deprecated
    public static boolean isUnderAlloyIDEALookAndFeel() {
        return false;
    }

    @Deprecated
    public static boolean isUnderWindowsLookAndFeel() {
        return SystemInfo.isWindows && UIManager.getLookAndFeel().getName().equals("Windows");
    }

    @Deprecated
    public static boolean isUnderWindowsClassicLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Windows Classic");
    }

    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    @Deprecated
    public static boolean isUnderNimbusLookAndFeel() {
        return false;
    }

    @Deprecated
    public static boolean isUnderJGoodiesLookAndFeel() {
        return false;
    }

    public static boolean isUnderAquaBasedLookAndFeel() {
        return SystemInfo.isMac && (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
    }

    public static boolean isUnderDefaultMacTheme() {
        return SystemInfo.isMac && UIUtil.isUnderIntelliJLaF() && Registry.is((String)"ide.intellij.laf.macos.ui") && !UIUtil.isCustomTheme();
    }

    public static boolean isUnderWin10LookAndFeel() {
        return SystemInfo.isWindows && UIUtil.isUnderIntelliJLaF() && Registry.is((String)"ide.intellij.laf.win10.ui") && !UIUtil.isCustomTheme();
    }

    private static boolean isCustomTheme() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof UserDataHolder) {
            Boolean value = (Boolean)((UserDataHolder)lookAndFeel).getUserData(LAF_WITH_THEME_KEY);
            return value != null && value != false;
        }
        return false;
    }

    public static boolean isUnderDarcula() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static boolean isGraphite() {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            return Foundation.invoke("NSColor", "currentControlTint", new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    @Nullable
    public static String getGtkThemeName() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null && "GTKLookAndFeel".equals(laf.getClass().getSimpleName())) {
            try {
                Method method = laf.getClass().getDeclaredMethod("getGtkThemeName", new Class[0]);
                method.setAccessible(true);
                Object theme = method.invoke((Object)laf, new Object[0]);
                if (theme != null) {
                    return theme.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static Font getToolbarFont() {
        Font font = SystemInfo.isMac ? UIUtil.getLabelFont(FontSize.SMALL) : UIUtil.getLabelFont();
        if (font == null) {
            UIUtil.$$$reportNull$$$0(99);
        }
        return font;
    }

    @Deprecated
    public static boolean isMurrineBasedTheme() {
        String gtkTheme = UIUtil.getGtkThemeName();
        return "Ambiance".equalsIgnoreCase(gtkTheme) || "Radiance".equalsIgnoreCase(gtkTheme) || "Dust".equalsIgnoreCase(gtkTheme) || "Dust Sand".equalsIgnoreCase(gtkTheme);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Color shade(@NotNull Color c, double factor, double d) {
        void alphaFactor;
        if (c == null) {
            UIUtil.$$$reportNull$$$0(100);
        }
        assert (factor >= 0.0) : factor;
        Color color = new Color(Math.min((int)Math.round((double)c.getRed() * factor), 255), Math.min((int)Math.round((double)c.getGreen() * factor), 255), Math.min((int)Math.round((double)c.getBlue() * factor), 255), Math.min((int)Math.round((double)c.getAlpha() * alphaFactor), 255));
        if (color == null) {
            UIUtil.$$$reportNull$$$0(101);
        }
        return color;
    }

    @NotNull
    public static Color mix(@NotNull Color c1, Color c2, double factor) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(102);
        }
        assert (0.0 <= factor && factor <= 1.0) : factor;
        double backFactor = 1.0 - factor;
        Color color = new Color(Math.min((int)Math.round((double)c1.getRed() * backFactor + (double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c1.getGreen() * backFactor + (double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c1.getBlue() * backFactor + (double)c2.getBlue() * factor), 255));
        if (color == null) {
            UIUtil.$$$reportNull$$$0(103);
        }
        return color;
    }

    public static boolean isFullRowSelectionLAF() {
        return false;
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDarcula();
    }

    public static int getListCellHPadding() {
        return UIUtil.isUnderDefaultMacTheme() ? 8 : (UIUtil.isUnderWin10LookAndFeel() ? 2 : 7);
    }

    public static int getListCellVPadding() {
        return 1;
    }

    @NotNull
    public static Insets getListCellPadding() {
        JBInsets jBInsets = JBInsets.create(UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding());
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(104);
        }
        return jBInsets;
    }

    @NotNull
    public static Insets getListViewportPadding() {
        JBInsets jBInsets = UIUtil.isUnderNativeMacLookAndFeel() ? JBInsets.create(1, 0) : JBUI.emptyInsets();
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(105);
        }
        return jBInsets;
    }

    public static boolean isToUseDottedCellBorder() {
        return !UIUtil.isUnderNativeMacLookAndFeel();
    }

    public static boolean isControlKeyDown(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            UIUtil.$$$reportNull$$$0(106);
        }
        return SystemInfo.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    @NotNull
    public static String[] getValidFontNames(boolean familyName) {
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!UIUtil.isValidFont(font)) continue;
                result.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Font labelFont = UIUtil.getLabelFont();
        if (labelFont != null && UIUtil.isValidFont(labelFont)) {
            result.add(familyName ? labelFont.getFamily() : labelFont.getName());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(107);
        }
        return stringArray;
    }

    @NotNull
    public static String[] getStandardFontSizes() {
        if (STANDARD_FONT_SIZES == null) {
            UIUtil.$$$reportNull$$$0(108);
        }
        return STANDARD_FONT_SIZES;
    }

    public static boolean isValidFont(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(109);
        }
        try {
            return font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setupEnclosingDialogBounds(@NotNull JComponent component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(110);
        }
        component.revalidate();
        component.repaint();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    @NotNull
    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            UIUtil.appendColor(fg, rule);
            rule.append(" ; ");
        }
        rule.append(" }");
        String string = rule.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(111);
        }
        return string;
    }

    public static void appendColor(@NotNull Color color, @NotNull StringBuilder sb) {
        if (color == null) {
            UIUtil.$$$reportNull$$$0(112);
        }
        if (sb == null) {
            UIUtil.$$$reportNull$$$0(113);
        }
        if (color.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getBlue()));
    }

    public static void drawDottedRectangle(@NotNull Graphics g, @NotNull Rectangle r) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(114);
        }
        if (r == null) {
            UIUtil.$$$reportNull$$$0(115);
        }
        UIUtil.drawDottedRectangle(g, r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public static void drawDottedRectangle(@NotNull Graphics g, int x, int y, int x1, int y1) {
        int i1;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(116);
        }
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            UIUtil.drawLine(g, x, i1, x, i1);
        }
    }

    public static void drawBoldDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(117);
        }
        if (SystemInfo.isMac && !UIUtil.isRetina() || SystemInfo.isLinux) {
            UIUtil.drawAppleDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        } else {
            UIUtil.drawBoringDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        }
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startX, float endX, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(118);
        }
        JBColor c1 = JBColor.namedColor("SearchMatch.startBackground", JBColor.namedColor("SearchMatch.startColor", 16771746));
        JBColor c2 = JBColor.namedColor("SearchMatch.endBackground", JBColor.namedColor("SearchMatch.endColor", 16764994));
        UIUtil.drawSearchMatch(g, startX, endX, height, c1, c2);
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startXf, float endXf, int height, Color c1, Color c2) {
        boolean drawRound;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(119);
        }
        GraphicsConfig config = new GraphicsConfig(g);
        float alpha = (float)JBUI.getInt("SearchMatch.transparency", 70) / 100.0f;
        alpha = alpha < 0.0f || alpha > 1.0f ? 0.7f : alpha;
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        g.setPaint(UIUtil.getGradientPaint(startXf, 2.0f, c1, startXf, height - 5, c2));
        if (JreHiDpiUtil.isJreHiDPI(g)) {
            GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing(g);
            g.fill(new RoundRectangle2D.Float(startXf, 2.0f, endXf - startXf, height - 4, 5.0f, 5.0f));
            c.restore();
            config.restore();
            return;
        }
        int startX = (int)startXf;
        int endX = (int)endXf;
        g.fillRect(startX, 3, endX - startX, height - 5);
        boolean bl = drawRound = endXf - startXf > 4.0f;
        if (drawRound) {
            UIUtil.drawLine(g, startX - 1, 4, startX - 1, height - 4);
            UIUtil.drawLine(g, endX, 4, endX, height - 4);
            g.setColor(new Color(100, 100, 100, 50));
            UIUtil.drawLine(g, startX - 1, 4, startX - 1, height - 4);
            UIUtil.drawLine(g, endX, 4, endX, height - 4);
            UIUtil.drawLine(g, startX, 3, endX - 1, 3);
            UIUtil.drawLine(g, startX, height - 3, endX - 1, height - 3);
        }
        config.restore();
    }

    private static void drawBoringDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(120);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
            UIUtil.drawLine(g, startX, lineY + 1, endX, lineY + 1);
        }
        int step = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        g.setColor(fgColor != null ? fgColor : oldColor);
        for (int dotXi = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            UIUtil.drawLine(g, dotXi, lineY, dotXi + 1, lineY);
            UIUtil.drawLine(g, dotXi, lineY + 1, dotXi + 1, lineY + 1);
        }
        g.setColor(oldColor);
    }

    public static void drawGradientHToolbarBackground(@NotNull Graphics g, int width, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(121);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._215, 0.0f, height, Gray._200));
        g2d.fillRect(0, 0, width, height);
    }

    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean drawTopLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(122);
        }
        UIUtil.drawHeader(g, x, width, height, active, false, drawTopLine, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean toolWindow, boolean drawTopLine, boolean drawBottomLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(123);
        }
        GraphicsConfig config = GraphicsUtil.disableAAPainting(g);
        try {
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBackground(active));
            g.fillRect(x, 0, width, height);
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBorderBackground());
            if (drawTopLine) {
                UIUtil.drawLine(g, x, 0, width, 0);
            }
            if (drawBottomLine) {
                UIUtil.drawLine(g, x, height - 1, width, height - 1);
            }
        }
        finally {
            config.restore();
        }
    }

    public static void drawDoubleSpaceDottedLine(@NotNull Graphics2D g, int start, int end, int xOrY, Color fgColor, boolean horizontal) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(124);
        }
        g.setColor(fgColor);
        for (int dot = start; dot < end; dot += 3) {
            if (horizontal) {
                UIUtil.drawLine(g, dot, xOrY, dot, xOrY);
                continue;
            }
            UIUtil.drawLine(g, xOrY, dot, xOrY, dot);
        }
    }

    private static void drawAppleDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(125);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
            UIUtil.drawLine(g, startX, lineY + 1, endX, lineY + 1);
            UIUtil.drawLine(g, startX, lineY + 2, endX, lineY + 2);
        }
        AppleBoldDottedPainter painter = AppleBoldDottedPainter.forColor((Color)ObjectUtils.notNull((Object)fgColor, (Object)oldColor));
        painter.paint(g, startX, endX, lineY);
    }

    public static void applyRenderingHints(@NotNull Graphics g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(126);
        }
        Graphics2D g2d = (Graphics2D)g;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            g2d.addRenderingHints(map);
        }
    }

    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        if (UIUtil.isJreHiDPI()) {
            BufferedImage bufferedImage = RetinaImage.create(width, height, type);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(127);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(128);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, int width, int height, int type) {
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            BufferedImage bufferedImage = RetinaImage.create(gc, width, height, type);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(129);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(130);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(131);
        }
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            BufferedImage bufferedImage = RetinaImage.create(gc, width, height, (int)type, (PaintUtil.RoundingMode)rm);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(132);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(rm.round(width), rm.round(height), (int)type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(133);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(ScaleContext ctx, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(134);
        }
        if (UIUtil.isJreHiDPI(ctx)) {
            BufferedImage bufferedImage = RetinaImage.create(ctx, width, height, (int)type, (PaintUtil.RoundingMode)rm);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(135);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(rm.round(width), rm.round(height), (int)type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(136);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImage(Graphics g, int width, int height, int type) {
        BufferedImage bufferedImage = UIUtil.createImage(g, (double)width, (double)height, type, PaintUtil.RoundingMode.FLOOR);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(137);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(Graphics g, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(138);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (JreHiDpiUtil.isJreHiDPI(g2d)) {
                BufferedImage bufferedImage = RetinaImage.create(g2d, width, height, (int)type, (PaintUtil.RoundingMode)rm);
                if (bufferedImage == null) {
                    UIUtil.$$$reportNull$$$0(139);
                }
                return bufferedImage;
            }
            BufferedImage bufferedImage = new BufferedImage(rm.round(width), rm.round(height), (int)type);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(140);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = UIUtil.createImage(rm.round(width), rm.round(height), (int)type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(141);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImage(Component comp, int width, int height, int type) {
        BufferedImage bufferedImage = comp != null ? UIUtil.createImage(comp.getGraphicsConfiguration(), width, height, type) : UIUtil.createImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(142);
        }
        return bufferedImage;
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImageForGraphics(Graphics2D g, int width, int height, int type) {
        BufferedImage bufferedImage = UIUtil.createImage(g, width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(143);
        }
        return bufferedImage;
    }

    public static void paintWithXorOnRetina(@NotNull Dimension size, @NotNull Graphics g, boolean useRetinaCondition, @NotNull Consumer<? super Graphics2D> paintRoutine) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(144);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(145);
        }
        if (paintRoutine == null) {
            UIUtil.$$$reportNull$$$0(146);
        }
        if (!useRetinaCondition || !JreHiDpiUtil.isJreHiDPI((Graphics2D)g) || Registry.is((String)"ide.mac.retina.disableDrawingFix")) {
            paintRoutine.consume((Object)((Graphics2D)g));
        } else {
            Rectangle rect = g.getClipBounds();
            if (rect == null) {
                rect = new Rectangle(size);
            }
            BufferedImage image = new BufferedImage(rect.width * 2, rect.height * 2, 1);
            Graphics2D imageGraphics = (Graphics2D)((Image)image).getGraphics();
            imageGraphics.scale(2.0, 2.0);
            imageGraphics.translate(-rect.x, -rect.y);
            imageGraphics.setClip(rect.x, rect.y, rect.width, rect.height);
            paintRoutine.consume((Object)imageGraphics);
            image.flush();
            imageGraphics.dispose();
            ((Graphics2D)g).scale(0.5, 0.5);
            g.drawImage(image, rect.x * 2, rect.y * 2, null);
        }
    }

    public static void setupComposite(@NotNull Graphics2D g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(147);
        }
        g.setComposite((Boolean)X_RENDER_ACTIVE.getValue() != false ? AlphaComposite.SrcOver : AlphaComposite.Src);
    }

    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + UIUtil.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Method dispatchEventMethod = (Method)ObjectUtils.notNull((Object)ReflectionUtil.getDeclaredMethod(eventQueue.getClass(), (String)"dispatchEvent", (Class[])new Class[]{AWTEvent.class}));
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.invoke((Object)eventQueue, event);
                }
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e.getCause());
            }
            catch (Exception e) {
                UIUtil.getLogger().error((Throwable)e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
            }
            ++i;
        }
    }

    @NotNull
    private static Thread getEventQueueThread() {
        Thread thread;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, (String)"getDispatchThread", (Class[])new Class[0]);
            thread = (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (thread == null) {
            UIUtil.$$$reportNull$$$0(148);
        }
        return thread;
    }

    /*
     * WARNING - void declaration
     */
    public static void addAwtListener(final @NotNull AWTEventListener listener, long mask, @NotNull Disposable disposable) {
        void parent;
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(149);
        }
        if (disposable == null) {
            UIUtil.$$$reportNull$$$0(150);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, mask);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
        });
    }

    public static void addParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(151);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(152);
        }
        component.addPropertyChangeListener("ancestor", listener);
    }

    public static void removeParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(153);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(154);
        }
        component.removePropertyChangeListener("ancestor", listener);
    }

    public static void drawVDottedLine(@NotNull Graphics2D g, int lineX, int startY, int endY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(155);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, lineX, startY, lineX, endY);
        }
        g.setColor(fgColor);
        for (int i = startY / 2 * 2; i < endY; i += 2) {
            g.drawRect(lineX, i, 0, 0);
        }
    }

    public static void drawHDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(156);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            UIUtil.drawLine(g, startX, lineY, endX, lineY);
        }
        g.setColor(fgColor);
        for (int i = startX / 2 * 2; i < endX; i += 2) {
            g.drawRect(i, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(157);
        }
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static void drawStringWithHighlighting(@NotNull Graphics g, @NotNull String s, int x, int y, Color foreground, Color highlighting) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(158);
        }
        if (s == null) {
            UIUtil.$$$reportNull$$$0(159);
        }
        g.setColor(highlighting);
        boolean isRetina = JreHiDpiUtil.isJreHiDPI((Graphics2D)g);
        float scale = 1.0f / JBUIScale.sysScale((Graphics2D)g);
        for (float i = (float)(x - 1); i <= (float)(x + 1); i += isRetina ? scale : 1.0f) {
            for (float j = (float)(y - 1); j <= (float)(y + 1); j += isRetina ? scale : 1.0f) {
                ((Graphics2D)g).drawString(s, i, j);
            }
        }
        g.setColor(foreground);
        g.drawString(s, x, y);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str, boolean horzCentered, boolean vertCentered) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(160);
        }
        if (rect == null) {
            UIUtil.$$$reportNull$$$0(161);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(162);
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int textWidth = fm.stringWidth(str) - 1;
        int x = horzCentered ? Math.max(rect.x, rect.x + (rect.width - textWidth) / 2) : rect.x;
        int y = vertCentered ? Math.max(rect.y, rect.y + rect.height / 2 + fm.getAscent() * 2 / 5) : rect.y;
        Shape oldClip = g.getClip();
        g.clip(rect);
        g.drawString(str, x, y);
        g.setClip(oldClip);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(163);
        }
        if (rect == null) {
            UIUtil.$$$reportNull$$$0(164);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(165);
        }
        UIUtil.drawCenteredString(g, rect, str, true, true);
    }

    public static boolean isFocusAncestor(@NotNull Component component) {
        Component owner;
        if (component == null) {
            UIUtil.$$$reportNull$$$0(166);
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return false;
        }
        if (owner == component) {
            return true;
        }
        return SwingUtilities.isDescendingFrom(owner, component);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(167);
        }
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(168);
        }
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(169);
        }
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(170);
        }
        return UIUtil.isActionClick(e, effectiveType, false);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType, boolean allowShift) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(171);
        }
        if (!allowShift && UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    @NotNull
    public static Color getBgFillColor(@NotNull Component c) {
        Component parent;
        if (c == null) {
            UIUtil.$$$reportNull$$$0(172);
        }
        Color color = (parent = UIUtil.findNearestOpaque(c)) == null ? c.getBackground() : parent.getBackground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(173);
        }
        return color;
    }

    @Nullable
    public static Component findNearestOpaque(Component c) {
        return ComponentUtil.findParentByCondition(c, Component::isOpaque);
    }

    @Deprecated
    public static Component findParentByCondition(@Nullable Component c, @NotNull Condition<? super Component> condition) {
        if (condition == null) {
            UIUtil.$$$reportNull$$$0(174);
        }
        return ComponentUtil.findParentByCondition(c, (? super Component it) -> condition.value(it));
    }

    @Nullable
    public static Component getDeepestComponentAt(@NotNull Component parent, int x, int y) {
        Component component;
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(175);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(parent, x, y)) != null && component.getParent() instanceof JRootPane) {
            JRootPane rootPane = (JRootPane)component.getParent();
            Point point = SwingUtilities.convertPoint(parent, new Point(x, y), rootPane.getLayeredPane());
            component = SwingUtilities.getDeepestComponentAt(rootPane.getLayeredPane(), point.x, point.y);
            if (component == null) {
                point = SwingUtilities.convertPoint(parent, new Point(x, y), rootPane.getContentPane());
                component = SwingUtilities.getDeepestComponentAt(rootPane.getContentPane(), point.x, point.y);
            }
        }
        return component;
    }

    public static void layoutRecursively(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(176);
        }
        if (component instanceof JComponent) {
            component.doLayout();
            for (Component child : ((JComponent)component).getComponents()) {
                UIUtil.layoutRecursively(child);
            }
        }
    }

    @NotNull
    @Language(value="HTML")
    public static String getCssFontDeclaration(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(177);
        }
        String string = UIUtil.getCssFontDeclaration(font, null, null, null);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(178);
        }
        return string;
    }

    @NotNull
    @Language(value="HTML")
    public static String getCssFontDeclaration(@NotNull Font font, @Nullable Color fgColor, @Nullable Color linkColor, @Nullable String liImg) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(179);
        }
        StringBuilder builder = new StringBuilder().append("<style>\n");
        String familyAndSize = "font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;";
        builder.append("body, div, td, p {").append(familyAndSize);
        if (fgColor != null) {
            builder.append(" color:#").append(ColorUtil.toHex(fgColor)).append(';');
        }
        builder.append("}\n");
        builder.append("a {").append(familyAndSize);
        if (linkColor != null) {
            builder.append(" color:#").append(ColorUtil.toHex(linkColor)).append(';');
        }
        builder.append("}\n");
        builder.append("code {font-size:").append(font.getSize()).append("pt;}\n");
        builder.append("ul {list-style:disc; margin-left:15px;}\n");
        String string = builder.append("</style>").toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(180);
        }
        return string;
    }

    @NotNull
    public static Color getFocusedFillColor() {
        Color color = UIUtil.toAlpha(UIUtil.getListSelectionBackground(), 100);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(181);
        }
        return color;
    }

    @NotNull
    public static Color getFocusedBoundsColor() {
        Color color = UIUtil.getBoundsColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(182);
        }
        return color;
    }

    @NotNull
    public static Color getBoundsColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(183);
        }
        return color;
    }

    @NotNull
    public static Color getBoundsColor(boolean focused) {
        Color color = focused ? UIUtil.getFocusedBoundsColor() : UIUtil.getBoundsColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(184);
        }
        return color;
    }

    @NotNull
    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        Color color2 = new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
        if (color2 == null) {
            UIUtil.$$$reportNull$$$0(185);
        }
        return color2;
    }

    public static boolean isFocusable(@Nullable Component component) {
        return component != null && component.isFocusable() && component.isEnabled() && component.isShowing();
    }

    @Deprecated
    public static void requestFocus(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(186);
        }
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(c::requestFocus);
        }
    }

    public static void dispose(Component c) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c.getMouseListeners()) {
            c.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c.getMouseMotionListeners()) {
            c.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c.getMouseWheelListeners()) {
            c.removeMouseWheelListener(each);
        }
        if (c instanceof AbstractButton) {
            ActionListener[] listeners;
            for (ActionListener listener : listeners = ((AbstractButton)c).getActionListeners()) {
                ((AbstractButton)c).removeActionListener(listener);
            }
        }
    }

    public static void disposeProgress(@NotNull JProgressBar progress) {
        if (progress == null) {
            UIUtil.$$$reportNull$$$0(187);
        }
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(() -> progress.setUI(null));
    }

    @Nullable
    public static Component findUltimateParent(@Nullable Component c) {
        return c == null ? null : ComponentUtil.findUltimateParent(c);
    }

    @NotNull
    public static Color getHeaderActiveColor() {
        Color color = ACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(188);
        }
        return color;
    }

    @NotNull
    public static Color getFocusedBorderColor() {
        Color color = JBUI.CurrentTheme.Focus.focusColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(189);
        }
        return color;
    }

    @NotNull
    public static Color getHeaderInactiveColor() {
        Color color = INACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(190);
        }
        return color;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    public static Color getBorderColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(191);
        }
        return color;
    }

    @NotNull
    public static Font getTitledBorderFont() {
        Font defFont = UIUtil.getLabelFont();
        Font font = defFont.deriveFont((float)defFont.getSize() - 1.0f);
        if (font == null) {
            UIUtil.$$$reportNull$$$0(192);
        }
        return font;
    }

    @Deprecated
    @NotNull
    public static Color getBorderInactiveColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(193);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getBorderActiveColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(194);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getBorderSeparatorColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(195);
        }
        return color;
    }

    @Nullable
    public static StyleSheet loadStyleSheet(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        try {
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.loadRules(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8), url);
            return styleSheet;
        }
        catch (IOException e) {
            UIUtil.getLogger().warn(url + " loading failed", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static HTMLEditorKit getHTMLEditorKit() {
        HTMLEditorKit hTMLEditorKit = UIUtil.getHTMLEditorKit(true);
        if (hTMLEditorKit == null) {
            UIUtil.$$$reportNull$$$0(196);
        }
        return hTMLEditorKit;
    }

    @NotNull
    public static HTMLEditorKit getHTMLEditorKit(boolean noGapsBetweenParagraphs) {
        JBHtmlEditorKit jBHtmlEditorKit = new JBHtmlEditorKit(noGapsBetweenParagraphs);
        if (jBHtmlEditorKit == null) {
            UIUtil.$$$reportNull$$$0(197);
        }
        return jBHtmlEditorKit;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(198);
        }
        FontUIResource fontUIResource = UIUtil.getFontWithFallback(font.getFamily(), font.getStyle(), font.getSize());
        if (fontUIResource == null) {
            UIUtil.$$$reportNull$$$0(199);
        }
        return fontUIResource;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, int size) {
        Font fontWithFallback = SystemInfo.isMac ? new Font(familyName, style, size) : new StyleContext().getFont(familyName, style, size);
        FontUIResource fontUIResource = fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : new FontUIResource(fontWithFallback);
        if (fontUIResource == null) {
            UIUtil.$$$reportNull$$$0(200);
        }
        return fontUIResource;
    }

    public static <T> T htmlInjectionGuard(T toRender) {
        if (toRender instanceof String && StringUtil.toLowerCase((String)((String)toRender)).startsWith("<html>")) {
            return (T)("<html>" + StringUtil.escapeXmlEntities((String)((String)toRender)));
        }
        return toRender;
    }

    public static void removeScrollBorder(Component c) {
        for (JScrollPane scrollPane : UIUtil.uiTraverser(c).filter(JScrollPane.class)) {
            if (!UIUtil.uiParents(scrollPane, true).takeWhile(Conditions.notEqualTo((Object)c)).filter(Conditions.not((Condition)Conditions.instanceOf((Class[])new Class[]{JPanel.class, JLayeredPane.class}))).isEmpty()) continue;
            Integer keepBorderSides = UIUtil.getClientProperty((Object)scrollPane, KEEP_BORDER_SIDES);
            if (keepBorderSides != null) {
                if (scrollPane.getBorder() instanceof LineBorder) {
                    Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                    scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                    continue;
                }
                scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), keepBorderSides));
                continue;
            }
            scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), 0));
        }
    }

    @NotNull
    public static String toHtml(@NotNull String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(201);
        }
        String string = UIUtil.toHtml(html, 0);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(202);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String toHtml(@NotNull String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(203);
        }
        html = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = UIUtil.getLabelFont();
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : JBUIScale.scale(11);
        String string = "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(html, hPadding) + "</html>";
        if (string == null) {
            UIUtil.$$$reportNull$$$0(204);
        }
        return string;
    }

    @NotNull
    public static String addPadding(@NotNull String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(205);
        }
        String string = String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(206);
        }
        return string;
    }

    @NotNull
    public static String convertSpace2Nbsp(@NotNull String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(207);
        }
        StringBuilder result = new StringBuilder();
        int braces = 0;
        for (int currentPos = 0; currentPos < html.length(); ++currentPos) {
            String each = html.substring(currentPos, currentPos + 1);
            if ("<".equals(each)) {
                ++braces;
            } else if (">".equals(each)) {
                --braces;
            }
            if (" ".equals(each) && braces == 0) {
                result.append("&nbsp;");
                continue;
            }
            result.append(each);
        }
        String string = result.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(208);
        }
        return string;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager edtInvocationManager;
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(209);
        }
        if ((edtInvocationManager = EdtInvocationManager.getInstance()).isEventDispatchThread()) {
            runnable.run();
        } else {
            edtInvocationManager.invokeLater(runnable);
        }
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(210);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                EdtInvocationManager.getInstance().invokeAndWait(runnable);
            }
            catch (Exception e) {
                UIUtil.getLogger().error((Throwable)e);
            }
        }
    }

    public static <T> T invokeAndWaitIfNeeded(@NotNull Computable<T> computable) {
        if (computable == null) {
            UIUtil.$$$reportNull$$$0(211);
        }
        Ref result = Ref.create();
        UIUtil.invokeAndWaitIfNeeded(() -> result.set(computable.compute()));
        return (T)result.get();
    }

    public static void invokeAndWaitIfNeeded(@NotNull ThrowableRunnable runnable) throws Throwable {
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(212);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            Ref ref = Ref.create();
            EdtInvocationManager.getInstance().invokeAndWait(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ref.set((Object)throwable);
                }
            });
            if (!ref.isNull()) {
                throw (Throwable)ref.get();
            }
        }
    }

    public static boolean isFocusProxy(@Nullable Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(FOCUS_PROXY_KEY));
    }

    public static void maybeInstall(@NotNull InputMap map, String action, KeyStroke stroke) {
        if (map == null) {
            UIUtil.$$$reportNull$$$0(213);
        }
        if (map.get(stroke) == null) {
            map.put(stroke, action);
        }
    }

    public static void changeBackGround(@NotNull Component component, Color background) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(214);
        }
        Color oldBackGround = component.getBackground();
        if (background == null || !background.equals(oldBackGround)) {
            component.setBackground(background);
        }
    }

    public static void addKeyboardShortcut(@NotNull JComponent target, final AbstractButton button, KeyStroke keyStroke) {
        if (target == null) {
            UIUtil.$$$reportNull$$$0(215);
        }
        target.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.isEnabled()) {
                    button.doClick();
                }
            }
        }, keyStroke, 0);
    }

    @Nullable
    public static ComboPopup getComboBoxPopup(@NotNull JComboBox comboBox) {
        ComboBoxUI ui;
        if (comboBox == null) {
            UIUtil.$$$reportNull$$$0(216);
        }
        if ((ui = comboBox.getUI()) instanceof BasicComboBoxUI) {
            return (ComboPopup)ReflectionUtil.getField(BasicComboBoxUI.class, (Object)ui, ComboPopup.class, (String)"popup");
        }
        return null;
    }

    public static void fixFormattedField(@NotNull JFormattedTextField field) {
        if (field == null) {
            UIUtil.$$$reportNull$$$0(217);
        }
        if (SystemInfo.isMac) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof HeadlessToolkit) {
                return;
            }
            int commandKeyMask = toolkit.getMenuShortcutKeyMask();
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static int getSelectedButton(@NotNull ButtonGroup group) {
        if (group == null) {
            UIUtil.$$$reportNull$$$0(218);
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (group.isSelected(button.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedButton(@NotNull ButtonGroup group, int index) {
        if (group == null) {
            UIUtil.$$$reportNull$$$0(219);
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            group.setSelected(button.getModel(), index == i);
            ++i;
        }
    }

    public static boolean isSelectionButtonDown(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(220);
        }
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public static boolean isToggleListSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(221);
        }
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    public static void setComboBoxEditorBounds(int x, int y, int width, int height, @NotNull JComponent editor) {
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(222);
        }
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            editor.reshape(x, y, width - 4, height - 1);
        } else {
            editor.reshape(x, y, width, height);
        }
    }

    public static int fixComboBoxHeight(int height) {
        return SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel() ? 28 : height;
    }

    public static boolean isDescendingFrom(@Nullable Component child, @NotNull Component parent) {
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(223);
        }
        while (child != null && child != parent) {
            child = child instanceof JPopupMenu ? ((JPopupMenu)child).getInvoker() : child.getParent();
        }
        return child == parent;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component) {
        if (type == null) {
            UIUtil.$$$reportNull$$$0(224);
        }
        return ComponentUtil.getParentOfType(type, component);
    }

    @NotNull
    public static JBIterable<Component> uiParents(@Nullable Component c, boolean strict) {
        JBIterable jBIterable = strict ? JBIterable.generate((Object)c, COMPONENT_PARENT).skip(1) : JBIterable.generate((Object)c, COMPONENT_PARENT);
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(225);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(226);
            }
            return jBIterable;
        }
        Container container = (Container)component;
        JBIterable jBIterable = JBIterable.of((Object[])container.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(227);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<Component> uiTraverser(@Nullable Component component) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)UI_TRAVERSER.withRoot((Object)component)).expandAndFilter(o -> !(o instanceof CellRendererPane));
        if (jBTreeTraverser == null) {
            UIUtil.$$$reportNull$$$0(228);
        }
        return jBTreeTraverser;
    }

    public static void scrollListToVisibleIfNeeded(@NotNull JList list) {
        if (list == null) {
            UIUtil.$$$reportNull$$$0(229);
        }
        SwingUtilities.invokeLater(() -> {
            Rectangle cellBounds;
            Rectangle visibleRect;
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex >= 0 && !(visibleRect = list.getVisibleRect()).contains(cellBounds = list.getCellBounds(selectedIndex, selectedIndex))) {
                list.scrollRectToVisible(cellBounds);
            }
        });
    }

    @Nullable
    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isInstance(parent)) {
            return (T)((JComponent)cls.cast(parent));
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    @NotNull
    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent, @NotNull Class<? extends T> cls) {
        if (cls == null) {
            UIUtil.$$$reportNull$$$0(230);
        }
        ArrayList result = new ArrayList();
        UIUtil.findComponentsOfType(parent, cls, result);
        ArrayList arrayList = result;
        if (arrayList == null) {
            UIUtil.$$$reportNull$$$0(231);
        }
        return arrayList;
    }

    private static <T extends JComponent> void findComponentsOfType(JComponent parent, @NotNull Class<T> cls, @NotNull List<? super T> result) {
        if (cls == null) {
            UIUtil.$$$reportNull$$$0(232);
        }
        if (result == null) {
            UIUtil.$$$reportNull$$$0(233);
        }
        if (parent == null) {
            return;
        }
        if (cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            result.add(t);
        }
        for (Component c : parent.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            UIUtil.findComponentsOfType((JComponent)c, cls, result);
        }
    }

    @Nullable
    public static JRootPane getRootPane(Component c) {
        JRootPane root = ComponentUtil.getParentOfType(JRootPane.class, c);
        if (root != null) {
            return root;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            WeakReference pane;
            if (!(eachParent instanceof JComponent) || (pane = (WeakReference)((JComponent)eachParent).getClientProperty(ROOT_PANE)) == null) continue;
            return (JRootPane)pane.get();
        }
        return null;
    }

    public static void setFutureRootPane(@NotNull JComponent c, @NotNull JRootPane pane) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(234);
        }
        if (pane == null) {
            UIUtil.$$$reportNull$$$0(235);
        }
        c.putClientProperty(ROOT_PANE, new WeakReference<JRootPane>(pane));
    }

    public static boolean isMeaninglessFocusOwner(@Nullable Component c) {
        if (c == null || !c.isShowing()) {
            return true;
        }
        return c instanceof JFrame || c instanceof JDialog || c instanceof JWindow || c instanceof JRootPane || UIUtil.isFocusProxy(c);
    }

    @NotNull
    public static Timer createNamedTimer(final @NonNls @NotNull String name, int delay, @NotNull ActionListener listener) {
        if (name == null) {
            UIUtil.$$$reportNull$$$0(236);
        }
        if (listener == null) {
            UIUtil.$$$reportNull$$$0(237);
        }
        Timer timer = new Timer(delay, listener){

            public String toString() {
                return name;
            }
        };
        if (timer == null) {
            UIUtil.$$$reportNull$$$0(238);
        }
        return timer;
    }

    @NotNull
    public static Timer createNamedTimer(final @NonNls @NotNull String name, int delay) {
        if (name == null) {
            UIUtil.$$$reportNull$$$0(239);
        }
        Timer timer = new Timer(delay, null){

            public String toString() {
                return name;
            }
        };
        if (timer == null) {
            UIUtil.$$$reportNull$$$0(240);
        }
        return timer;
    }

    public static boolean isDialogRootPane(JRootPane rootPane) {
        if (rootPane != null) {
            Object isDialog = rootPane.getClientProperty("DIALOG_ROOT_PANE");
            return isDialog instanceof Boolean && (Boolean)isDialog != false;
        }
        return false;
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(PanelWithAnchor ... panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(241);
        }
        return UIUtil.mergeComponentsWithAnchor(Arrays.asList(panels));
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(@NotNull Collection<? extends PanelWithAnchor> panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(242);
        }
        JComponent maxWidthAnchor = null;
        int maxWidth = 0;
        for (PanelWithAnchor panelWithAnchor : panels) {
            int anchorWidth;
            JComponent anchor = panelWithAnchor != null ? panelWithAnchor.getAnchor() : null;
            if (anchor == null || maxWidth >= (anchorWidth = anchor.getPreferredSize().width)) continue;
            maxWidth = anchorWidth;
            maxWidthAnchor = anchor;
        }
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null) continue;
            panelWithAnchor.setAnchor(maxWidthAnchor);
        }
        return maxWidthAnchor;
    }

    public static void setNotOpaqueRecursively(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(243);
        }
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            return;
        }
        if (component.getBackground().equals(UIUtil.getPanelBackground()) || component instanceof JScrollPane || component instanceof JViewport || component instanceof JLayeredPane) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            if (component instanceof Container) {
                for (Component c : ((Container)component).getComponents()) {
                    UIUtil.setNotOpaqueRecursively(c);
                }
            }
        }
    }

    public static void setBackgroundRecursively(@NotNull Component component, @NotNull Color bg) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(244);
        }
        if (bg == null) {
            UIUtil.$$$reportNull$$$0(245);
        }
        component.setBackground(bg);
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                UIUtil.setBackgroundRecursively(c, bg);
            }
        }
    }

    public static void addInsets(@NotNull JComponent component, int top, int left, int bottom, int right) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(246);
        }
        UIUtil.addBorder(component, BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public static void addInsets(@NotNull JComponent component, @NotNull Insets insets) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(247);
        }
        if (insets == null) {
            UIUtil.$$$reportNull$$$0(248);
        }
        UIUtil.addInsets(component, insets.top, insets.left, insets.bottom, insets.right);
    }

    public static void adjustWindowToMinimumSize(Window window) {
        if (window == null) {
            return;
        }
        Dimension minSize = window.getMinimumSize();
        Dimension size = window.getSize();
        Dimension newSize = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(() -> {
                if (window.isShowing()) {
                    window.setSize(newSize);
                }
            });
        }
    }

    public static int getLcdContrastValue() {
        int lcdContrastValue = Registry.get((String)"lcd.contrast.value").asInteger();
        if (lcdContrastValue == 0) {
            if (SystemInfo.isMacIntel64) {
                lcdContrastValue = UIUtil.isUnderDarcula() ? 140 : 230;
            } else {
                Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                if (map == null) {
                    lcdContrastValue = 140;
                } else {
                    Object o = map.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                    int n = lcdContrastValue = o == null ? 140 : (Integer)o;
                }
            }
        }
        if (lcdContrastValue < 100 || lcdContrastValue > 250) {
            lcdContrastValue = 140;
        }
        return lcdContrastValue;
    }

    public static void addBorder(JComponent component, Border border) {
        if (component != null && border != null) {
            Border old = component.getBorder();
            if (old != null) {
                border = BorderFactory.createCompoundBorder(border, old);
            }
            component.setBorder(border);
        }
    }

    @NotNull
    public static Color getDecoratedRowColor() {
        JBColor jBColor = JBColor.namedColor("Table.stripeColor", DECORATED_ROW_BG_COLOR);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(249);
        }
        return jBColor;
    }

    @NotNull
    public static Paint getGradientPaint(float x1, float y1, @NotNull Color c1, float x2, float y2, @NotNull Color c2) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(250);
        }
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(251);
        }
        Paint paint = Registry.is((String)"ui.no.bangs.and.whistles") ? ColorUtil.mix(c1, c2, 0.5) : new GradientPaint(x1, y1, c1, x2, y2, c2);
        if (paint == null) {
            UIUtil.$$$reportNull$$$0(252);
        }
        return paint;
    }

    @Nullable
    public static Point getLocationOnScreen(@NotNull JComponent component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(253);
        }
        int dx = 0;
        int dy = 0;
        for (Container c = component; c != null; c = c.getParent()) {
            if (c.isShowing()) {
                Point locationOnScreen = c.getLocationOnScreen();
                locationOnScreen.translate(dx, dy);
                return locationOnScreen;
            }
            Point location = c.getLocation();
            dx += location.x;
            dy += location.y;
        }
        return null;
    }

    @NotNull
    public static Window getActiveWindow() {
        Window[] windows;
        for (Window each : windows = Window.getWindows()) {
            if (!each.isVisible() || !each.isActive()) continue;
            Window window = each;
            if (window == null) {
                UIUtil.$$$reportNull$$$0(254);
            }
            return window;
        }
        Frame frame = JOptionPane.getRootFrame();
        if (frame == null) {
            UIUtil.$$$reportNull$$$0(255);
        }
        return frame;
    }

    public static void suppressFocusStealing(@NotNull Window window) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(256);
        }
        if (SystemInfo.isMac) {
            return;
        }
        if (SUPPRESS_FOCUS_STEALING && Registry.is((String)"suppress.focus.stealing.auto.request.focus")) {
            UIUtil.setAutoRequestFocus(window, false);
        }
    }

    public static void setAutoRequestFocus(@NotNull Window onWindow, boolean set) {
        if (onWindow == null) {
            UIUtil.$$$reportNull$$$0(257);
        }
        if (!SystemInfo.isMac) {
            try {
                onWindow.getClass().getMethod("setAutoRequestFocus", Boolean.TYPE).invoke((Object)onWindow, set);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                UIUtil.getLogger().debug((Throwable)e);
            }
        }
    }

    public static void runWhenWindowOpened(@NotNull Window window, final @NotNull Runnable runnable) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(258);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(259);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    public static void runWhenWindowClosed(@NotNull Window window, final @NotNull Runnable runnable) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(260);
        }
        if (runnable == null) {
            UIUtil.$$$reportNull$$$0(261);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    @NotNull
    public static String getDebugText(Component c) {
        StringBuilder builder = new StringBuilder();
        UIUtil.getAllTextsRecursivelyImpl(c, builder);
        String string = builder.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(262);
        }
        return string;
    }

    private static void getAllTextsRecursivelyImpl(Component component, @NotNull StringBuilder builder) {
        if (builder == null) {
            UIUtil.$$$reportNull$$$0(263);
        }
        String candidate = "";
        if (component instanceof JLabel) {
            candidate = ((JLabel)component).getText();
        }
        if (component instanceof JTextComponent) {
            candidate = ((JTextComponent)component).getText();
        }
        if (component instanceof AbstractButton) {
            candidate = ((AbstractButton)component).getText();
        }
        if (StringUtil.isNotEmpty((String)candidate)) {
            candidate = candidate.replaceAll("<a href=\"#inspection/[^)]+\\)", "");
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(StringUtil.removeHtmlTags((String)candidate).trim());
        }
        if (component instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)component).getComponents()) {
                UIUtil.getAllTextsRecursivelyImpl(child, builder);
            }
        }
    }

    public static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        if (ancestor == null) {
            UIUtil.$$$reportNull$$$0(264);
        }
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    public static void resetUndoRedoActions(@NotNull JTextComponent textComponent) {
        UndoManager undoManager;
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(265);
        }
        if ((undoManager = UIUtil.getClientProperty((Object)textComponent, UNDO_MANAGER)) != null) {
            undoManager.discardAllEdits();
        }
    }

    public static void addUndoRedoActions(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(266);
        }
        if (textComponent.getClientProperty(UNDO_MANAGER) instanceof UndoManager) {
            return;
        }
        UndoManager undoManager = new UndoManager();
        textComponent.putClientProperty(UNDO_MANAGER, undoManager);
        textComponent.getDocument().addUndoableEditListener(undoManager);
        textComponent.getDocument().addDocumentListener(SET_TEXT_CHECKER);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, SystemInfo.isMac ? 4 : 2), "undoKeystroke");
        textComponent.getActionMap().put("undoKeystroke", UNDO_ACTION);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, (SystemInfo.isMac ? 4 : 2) | 1), "redoKeystroke");
        textComponent.getActionMap().put("redoKeystroke", REDO_ACTION);
    }

    @Nullable
    public static UndoManager getUndoManager(Component component) {
        Object o;
        if (component instanceof JTextComponent && (o = ((JTextComponent)component).getClientProperty(UNDO_MANAGER)) instanceof UndoManager) {
            return (UndoManager)o;
        }
        return null;
    }

    public static void playSoundFromResource(@NotNull String resourceName) {
        Class callerClass;
        if (resourceName == null) {
            UIUtil.$$$reportNull$$$0(267);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return;
        }
        UIUtil.playSoundFromStream((Factory<? extends InputStream>)((Factory)() -> callerClass.getResourceAsStream(resourceName)));
    }

    public static void playSoundFromStream(@NotNull Factory<? extends InputStream> streamProducer) {
        if (streamProducer == null) {
            UIUtil.$$$reportNull$$$0(268);
        }
        new Thread(() -> {
            try {
                Clip clip = AudioSystem.getClip();
                InputStream stream = (InputStream)streamProducer.create();
                if (!stream.markSupported()) {
                    stream = new BufferedInputStream(stream);
                }
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
                clip.open(inputStream);
                clip.start();
            }
            catch (Exception e) {
                UIUtil.getLogger().info((Throwable)e);
            }
        }, "play sound").start();
    }

    @NotNull
    public static String rightArrow() {
        String string = FontUtil.rightArrow(UIUtil.getLabelFont());
        if (string == null) {
            UIUtil.$$$reportNull$$$0(269);
        }
        return string;
    }

    @NotNull
    public static String upArrow(@NotNull String defaultValue) {
        if (defaultValue == null) {
            UIUtil.$$$reportNull$$$0(270);
        }
        String string = FontUtil.upArrow(UIUtil.getLabelFont(), defaultValue);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(271);
        }
        return string;
    }

    public static void configureNumericFormattedTextField(@NotNull JFormattedTextField textField) {
        if (textField == null) {
            UIUtil.$$$reportNull$$$0(272);
        }
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(format);
        numberFormatter.setMinimum(Integer.valueOf(0));
        textField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        textField.setHorizontalAlignment(11);
        textField.setColumns(4);
    }

    @Nullable
    public static Window getWindow(@Nullable Component component) {
        return ComponentUtil.getWindow(component);
    }

    public static void toFront(@Nullable Window window) {
        if (window instanceof Frame) {
            ((Frame)window).setState(0);
        }
        if (window != null) {
            window.toFront();
        }
    }

    public static boolean hasScrollPane(@NotNull Component component) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(273);
        }
        return UIUtil.hasComponentOfType(component, JScrollPane.class);
    }

    public static boolean hasComponentOfType(@NotNull Component component, Class<?> ... types) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(274);
        }
        if (types == null) {
            UIUtil.$$$reportNull$$$0(275);
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!UIUtil.hasComponentOfType(container.getComponent(i), types)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumns(JTextComponent textComponent, int columns) {
        if (textComponent instanceof JTextField) {
            ((JTextField)textComponent).setColumns(columns);
        }
        if (textComponent instanceof JTextArea) {
            ((JTextArea)textComponent).setColumns(columns);
        }
    }

    public static int getLineHeight(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(276);
        }
        return textComponent.getFontMetrics(textComponent.getFont()).getHeight();
    }

    public static JComponent getPreferredFocusedComponent(Container container) {
        Container parent = container;
        if (parent == null) {
            return null;
        }
        FocusTraversalPolicy policy = parent.getFocusTraversalPolicy();
        while (policy == null) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            policy = parent.getFocusTraversalPolicy();
        }
        Component component = policy.getFirstComponent(container);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    @NotNull
    public static ComponentStyle getComponentStyle(Component component) {
        if (component instanceof JComponent) {
            Object property = ((JComponent)component).getClientProperty("JComponent.sizeVariant");
            if ("large".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.LARGE;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(277);
                }
                return componentStyle;
            }
            if ("small".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.SMALL;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(278);
                }
                return componentStyle;
            }
            if ("mini".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.MINI;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(279);
                }
                return componentStyle;
            }
        }
        ComponentStyle componentStyle = ComponentStyle.REGULAR;
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(280);
        }
        return componentStyle;
    }

    public static void repaintViewport(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(281);
        }
        if (!c.isDisplayable() || !c.isVisible()) {
            return;
        }
        Container p = c.getParent();
        if (p instanceof JViewport) {
            p.repaint();
        }
    }

    public static void setCursor(@NotNull Component component, Cursor cursor) {
        if (component == null) {
            UIUtil.$$$reportNull$$$0(282);
        }
        if (component.isCursorSet() && component.getCursor() == cursor) {
            return;
        }
        component.setCursor(cursor);
    }

    public static boolean haveCommonOwner(Component c1, Component c2) {
        Window owner;
        if (c1 == null || c2 == null) {
            return false;
        }
        Window c1Ancestor = UIUtil.findWindowAncestor(c1);
        Window c2Ancestor = UIUtil.findWindowAncestor(c2);
        HashSet<Window> ownerSet = new HashSet<Window>();
        for (owner = c1Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            ownerSet.add(owner);
        }
        for (owner = c2Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            if (!ownerSet.contains(owner)) continue;
            return true;
        }
        return false;
    }

    private static Window findWindowAncestor(@NotNull Component c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(283);
        }
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static boolean isHelpButton(Component button) {
        return button instanceof JButton && "help".equals(((JComponent)button).getClientProperty("JButton.buttonType"));
    }

    public static boolean isRetina(@NotNull GraphicsDevice device) {
        if (device == null) {
            UIUtil.$$$reportNull$$$0(284);
        }
        return DetectRetinaKit.isOracleMacRetinaDevice(device);
    }

    public static void useSafely(@NotNull Graphics originGraphics, @NotNull Consumer<? super Graphics2D> drawingConsumer) {
        if (originGraphics == null) {
            UIUtil.$$$reportNull$$$0(285);
        }
        if (drawingConsumer == null) {
            UIUtil.$$$reportNull$$$0(286);
        }
        Graphics2D graphics = (Graphics2D)originGraphics.create();
        try {
            drawingConsumer.consume((Object)graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    @NotNull
    public static Font getListFont() {
        Font font = UIManager.getFont("List.font");
        Font font2 = font != null ? font : UIUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(287);
        }
        return font2;
    }

    @NotNull
    public static Color getListBackground() {
        Color color = LIST_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(288);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionBackground(boolean focused) {
        if (!focused) {
            Color color = UnfocusedSelection.LIST_BACKGROUND;
            if (color == null) {
                UIUtil.$$$reportNull$$$0(289);
            }
            return color;
        }
        Color color = UIManager.getColor("List.selectionBackground");
        double alpha = (double)SELECTED_ITEM_ALPHA.getFloat() / 100.0;
        Color color2 = UIUtil.isUnderDefaultMacTheme() && alpha >= 0.0 && alpha <= 1.0 ? ColorUtil.mix(Color.WHITE, color, alpha) : color;
        if (color2 == null) {
            UIUtil.$$$reportNull$$$0(290);
        }
        return color2;
    }

    @NotNull
    public static Dimension updateListRowHeight(@NotNull Dimension size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(291);
        }
        size.height = Math.max(size.height, UIManager.getInt("List.rowHeight"));
        Dimension dimension = size;
        if (dimension == null) {
            UIUtil.$$$reportNull$$$0(292);
        }
        return dimension;
    }

    @NotNull
    public static Color getListBackground(boolean selected, boolean focused) {
        Color color = !selected ? UIUtil.getListBackground() : UIUtil.getListSelectionBackground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(293);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getListBackground(boolean selected) {
        Color color = UIUtil.getListBackground(selected, true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(294);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionBackground() {
        Color color = UIUtil.getListSelectionBackground(true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(295);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getListUnfocusedSelectionBackground() {
        Color color = UIUtil.getListSelectionBackground(false);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(296);
        }
        return color;
    }

    @NotNull
    public static Color getListForeground() {
        Color color = UIManager.getColor("List.foreground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(297);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "List.selectionForeground" : "List.selectionInactiveForeground");
        if (focused && foreground == null) {
            foreground = UIManager.getColor("List[Selected].textForeground");
        }
        Color color = foreground != null ? foreground : UIUtil.getListForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(298);
        }
        return color;
    }

    @NotNull
    public static Color getListForeground(boolean selected, boolean focused) {
        Color color = !selected ? UIUtil.getListForeground() : UIUtil.getListSelectionForeground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(299);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getListForeground(boolean selected) {
        Color color = UIUtil.getListForeground(selected, true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(300);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionForeground() {
        Color color = UIUtil.getListSelectionForeground(true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(301);
        }
        return color;
    }

    @NotNull
    public static Font getTreeFont() {
        Font font = UIManager.getFont("Tree.font");
        Font font2 = font != null ? font : UIUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(302);
        }
        return font2;
    }

    @NotNull
    public static Color getTreeBackground() {
        Color color = TREE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(303);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionBackground(boolean focused) {
        Color color = focused ? FocusedSelection.TREE_BACKGROUND : UnfocusedSelection.TREE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(304);
        }
        return color;
    }

    @NotNull
    public static Color getTreeBackground(boolean selected, boolean focused) {
        Color color = !selected ? UIUtil.getTreeBackground() : UIUtil.getTreeSelectionBackground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(305);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionBackground() {
        Color color = UIUtil.getTreeSelectionBackground(true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(306);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTreeUnfocusedSelectionBackground() {
        Color color = UIUtil.getTreeSelectionBackground(false);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(307);
        }
        return color;
    }

    @NotNull
    public static Color getTreeForeground() {
        Color color = UIManager.getColor("Tree.foreground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(308);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "Tree.selectionForeground" : "Tree.selectionInactiveForeground");
        Color color = foreground != null ? foreground : UIUtil.getTreeForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(309);
        }
        return color;
    }

    @NotNull
    public static Color getTreeForeground(boolean selected, boolean focused) {
        Color color = !selected ? UIUtil.getTreeForeground() : UIUtil.getTreeSelectionForeground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(310);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionForeground() {
        Color color = UIUtil.getTreeSelectionForeground(true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(311);
        }
        return color;
    }

    @NotNull
    public static Color getTableBackground() {
        Color color = TABLE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(312);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionBackground(boolean focused) {
        Color color = focused ? FocusedSelection.TABLE_BACKGROUND : UnfocusedSelection.TABLE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(313);
        }
        return color;
    }

    @NotNull
    public static Color getTableBackground(boolean selected, boolean focused) {
        Color color = !selected ? UIUtil.getTableBackground() : UIUtil.getTableSelectionBackground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(314);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTableBackground(boolean selected) {
        Color color = UIUtil.getTableBackground(selected, true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(315);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionBackground() {
        Color color = UIUtil.getTableSelectionBackground(true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(316);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTableUnfocusedSelectionBackground() {
        Color color = UIUtil.getTableSelectionBackground(false);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(317);
        }
        return color;
    }

    @NotNull
    public static Color getTableForeground() {
        Color color = UIManager.getColor("Table.foreground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(318);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "Table.selectionForeground" : "Table.selectionInactiveForeground");
        Color color = foreground != null ? foreground : UIUtil.getTreeForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(319);
        }
        return color;
    }

    @NotNull
    public static Color getTableForeground(boolean selected, boolean focused) {
        Color color = !selected ? UIUtil.getTableForeground() : UIUtil.getTableSelectionForeground(focused);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(320);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTableForeground(boolean selected) {
        Color color = UIUtil.getTableForeground(selected, true);
        if (color == null) {
            UIUtil.$$$reportNull$$$0(321);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionForeground() {
        Color color = UIManager.getColor("Table.selectionForeground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(322);
        }
        return color;
    }

    @Deprecated
    public static Pair<String, Integer> getSystemFontData() {
        return JBUIScale.getSystemFontData();
    }

    @Deprecated
    public static boolean isJreHiDPIEnabled() {
        return JreHiDpiUtil.isJreHiDPIEnabled();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJreHiDPI(@Nullable Graphics2D g) {
        return JreHiDpiUtil.isJreHiDPI(g);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval
    public static Color getPanelBackgound() {
        Color color = UIUtil.getPanelBackground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(323);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 68: 
            case 70: 
            case 75: 
            case 76: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 100: 
            case 102: 
            case 106: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 131: 
            case 134: 
            case 138: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 179: 
            case 186: 
            case 187: 
            case 198: 
            case 201: 
            case 203: 
            case 205: 
            case 207: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 291: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 68: 
            case 70: 
            case 75: 
            case 76: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 100: 
            case 102: 
            case 106: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 131: 
            case 134: 
            case 138: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 179: 
            case 186: 
            case 187: 
            case 198: 
            case 201: 
            case 203: 
            case 205: 
            case 207: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 291: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 1: 
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColor";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 12: 
            case 41: 
            case 109: 
            case 177: 
            case 179: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 13: 
            case 29: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 43: 
            case 44: 
            case 86: 
            case 110: 
            case 151: 
            case 153: 
            case 166: 
            case 176: 
            case 214: 
            case 243: 
            case 244: 
            case 246: 
            case 247: 
            case 253: 
            case 273: 
            case 274: 
            case 282: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 23: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: 
            case 201: 
            case 203: 
            case 205: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 30: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 220: 
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 45: 
            case 46: 
            case 47: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 145: 
            case 147: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 56: 
            case 58: 
            case 60: 
            case 144: 
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontColor";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 68: 
            case 70: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyPrefix";
                break;
            }
            case 81: 
            case 100: 
            case 172: 
            case 186: 
            case 234: 
            case 281: 
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slider";
                break;
            }
            case 102: 
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 131: 
            case 134: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintRoutine";
                break;
            }
            case 149: 
            case 152: 
            case 154: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 150: 
            case 175: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 161: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 162: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 209: 
            case 210: 
            case 212: 
            case 259: 
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 218: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 230: 
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 236: 
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 241: 
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 256: 
            case 258: 
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onWindow";
                break;
            }
            case 263: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 265: 
            case 266: 
            case 276: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamProducer";
                break;
            }
            case 270: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 275: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 285: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originGraphics";
                break;
            }
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 68: 
            case 70: 
            case 75: 
            case 76: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 100: 
            case 102: 
            case 106: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 131: 
            case 134: 
            case 138: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 179: 
            case 186: 
            case 187: 
            case 198: 
            case 201: 
            case 203: 
            case 205: 
            case 207: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 291: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextCursor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrayFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextGrayFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellColors";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlBody";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelTextBounds";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelFont";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelFontColor";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelForeground";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelDisabledForeground";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextHelpForeground";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeTextForeground";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeTextBackground";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveTextColor";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextInactiveTextColor";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipBackground";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipActionBackground";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipForeground";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelBackground";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorForeground";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonInformationIcon";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonWarningIcon";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonErrorIcon";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeNodeIcon";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeCollapsedIcon";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeExpandedIcon";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectedCollapsedIcon";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectedExpandedIcon";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarFont";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "shade";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "mix";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellPadding";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getListViewportPadding";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidFontNames";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardFontSizes";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "displayPropertiesToCSS";
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageForGraphics";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventQueueThread";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 178: 
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssFontDeclaration";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedFillColor";
                break;
            }
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBoundsColor";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundsColor";
                break;
            }
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "toAlpha";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderActiveColor";
                break;
            }
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBorderColor";
                break;
            }
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderInactiveColor";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderColor";
                break;
            }
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitledBorderFont";
                break;
            }
            case 193: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderInactiveColor";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderActiveColor";
                break;
            }
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderSeparatorColor";
                break;
            }
            case 196: 
            case 197: {
                objectArray = objectArray2;
                objectArray2[1] = "getHTMLEditorKit";
                break;
            }
            case 199: 
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithFallback";
                break;
            }
            case 202: 
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "addPadding";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 225: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 228: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentsOfType";
                break;
            }
            case 238: 
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedTimer";
                break;
            }
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratedRowColor";
                break;
            }
            case 252: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientPaint";
                break;
            }
            case 254: 
            case 255: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 262: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugText";
                break;
            }
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 271: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
            case 277: 
            case 278: 
            case 279: 
            case 280: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStyle";
                break;
            }
            case 287: {
                objectArray = objectArray2;
                objectArray2[1] = "getListFont";
                break;
            }
            case 288: 
            case 293: 
            case 294: {
                objectArray = objectArray2;
                objectArray2[1] = "getListBackground";
                break;
            }
            case 289: 
            case 290: 
            case 295: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionBackground";
                break;
            }
            case 292: {
                objectArray = objectArray2;
                objectArray2[1] = "updateListRowHeight";
                break;
            }
            case 296: {
                objectArray = objectArray2;
                objectArray2[1] = "getListUnfocusedSelectionBackground";
                break;
            }
            case 297: 
            case 299: 
            case 300: {
                objectArray = objectArray2;
                objectArray2[1] = "getListForeground";
                break;
            }
            case 298: 
            case 301: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionForeground";
                break;
            }
            case 302: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeFont";
                break;
            }
            case 303: 
            case 305: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBackground";
                break;
            }
            case 304: 
            case 306: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionBackground";
                break;
            }
            case 307: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeUnfocusedSelectionBackground";
                break;
            }
            case 308: 
            case 310: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeForeground";
                break;
            }
            case 309: 
            case 311: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionForeground";
                break;
            }
            case 312: 
            case 314: 
            case 315: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableBackground";
                break;
            }
            case 313: 
            case 316: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionBackground";
                break;
            }
            case 317: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableUnfocusedSelectionBackground";
                break;
            }
            case 318: 
            case 320: 
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableForeground";
                break;
            }
            case 319: 
            case 322: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionForeground";
                break;
            }
            case 323: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelBackgound";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "decorateFrame";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleOwner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextCursor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCellColors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDialogFont";
                break;
            }
            case 13: 
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "isRetina";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWindowClientPropertyTrue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWindowClientProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putWindowClientProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 23: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "drawLinePickedOut";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isReallyTypedEvent";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "drawWave";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "splitText";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getFontSize";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFontColor";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "installPopupMenuColorAndFonts";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "installPopupMenuBorder";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMaxGutterIconWidth";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getTabbedPanePaintContentBorder";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "setSliderIsFilled";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "setLineStyleAngled";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "shade";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isControlKeyDown";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingDialogBounds";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "appendColor";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedRectangle";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "drawBoldDottedLine";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "drawSearchMatch";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "drawBoringDottedLine";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "drawGradientHToolbarBackground";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "drawHeader";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "drawDoubleSpaceDottedLine";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "drawAppleDottedLine";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "applyRenderingHints";
                break;
            }
            case 131: 
            case 134: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "paintWithXorOnRetina";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "addAwtListener";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "drawVDottedLine";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "drawHDottedLine";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedLine";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "drawStringWithHighlighting";
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "drawCenteredString";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "isCloseClick";
                break;
            }
            case 169: 
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "isActionClick";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "layoutRecursively";
                break;
            }
            case 177: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "disposeProgress";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 201: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "addPadding";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 210: 
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "maybeInstall";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "changeBackGround";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardShortcut";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "fixFormattedField";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedButton";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedButton";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "setComboBoxEditorBounds";
                break;
            }
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 230: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "findComponentsOfType";
                break;
            }
            case 234: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "setFutureRootPane";
                break;
            }
            case 236: 
            case 237: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "createNamedTimer";
                break;
            }
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "mergeComponentsWithAnchor";
                break;
            }
            case 243: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 244: 
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 246: 
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "suppressFocusStealing";
                break;
            }
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "setAutoRequestFocus";
                break;
            }
            case 258: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowOpened";
                break;
            }
            case 260: 
            case 261: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowClosed";
                break;
            }
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "getAllTextsRecursivelyImpl";
                break;
            }
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromResource";
                break;
            }
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromStream";
                break;
            }
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 273: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "hasComponentOfType";
                break;
            }
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "useSafely";
                break;
            }
            case 291: {
                objectArray = objectArray;
                objectArray[2] = "updateListRowHeight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 68: 
            case 70: 
            case 75: 
            case 76: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 100: 
            case 102: 
            case 106: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 131: 
            case 134: 
            case 138: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 179: 
            case 186: 
            case 187: 
            case 198: 
            case 201: 
            case 203: 
            case 205: 
            case 207: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 291: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UnfocusedSelection {
        private static final Color BACKGROUND = new JBColor(0xD4D4D4, 862526);
        private static final Color LIST_BACKGROUND = JBColor.namedColor("List.selectionInactiveBackground", BACKGROUND);
        private static final Color TREE_BACKGROUND = JBColor.namedColor("Tree.selectionInactiveBackground", BACKGROUND);
        private static final Color TABLE_BACKGROUND = JBColor.namedColor("Table.selectionInactiveBackground", BACKGROUND);

        private UnfocusedSelection() {
        }
    }

    private static final class FocusedSelection {
        private static final Color BACKGROUND = new JBColor(3700182, 3106250);
        private static final Color LIST_BACKGROUND = JBColor.namedColor("List.selectionBackground", BACKGROUND);
        private static final Color TREE_BACKGROUND = JBColor.namedColor("Tree.selectionBackground", BACKGROUND);
        private static final Color TABLE_BACKGROUND = JBColor.namedColor("Table.selectionBackground", BACKGROUND);

        private FocusedSelection() {
        }
    }

    public static class TextPainter {
        private final List<Pair<String, LineInfo>> myLines = new ArrayList<Pair<String, LineInfo>>();
        private boolean myDrawShadow = UIUtil.isUnderDarcula();
        private Color myShadowColor = UIUtil.isUnderDarcula() ? Gray._0.withAlpha(100) : Gray._220;
        private float myLineSpacing = 1.0f;
        private Font myFont;
        private Color myColor;

        @NotNull
        public TextPainter withShadow(boolean drawShadow, Color shadowColor) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(0);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(1);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withColor(Color color) {
            this.myColor = color;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(2);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withFont(Font font) {
            this.myFont = font;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(3);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter appendLine(String text) {
            if (text == null || text.isEmpty()) {
                TextPainter textPainter = this;
                if (textPainter == null) {
                    TextPainter.$$$reportNull$$$0(4);
                }
                return textPainter;
            }
            this.myLines.add((Pair<String, LineInfo>)Pair.create((Object)text, (Object)new LineInfo()));
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(5);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter underlined(@Nullable Color color) {
            if (!this.myLines.isEmpty()) {
                LineInfo info = (LineInfo)this.myLines.get(this.myLines.size() - 1).getSecond();
                info.underlined = true;
                info.underlineColor = color;
            }
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(6);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter underlined() {
            TextPainter textPainter = this.underlined(null);
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(7);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter smaller() {
            if (!this.myLines.isEmpty()) {
                ((LineInfo)this.myLines.get(this.myLines.size() - 1).getSecond()).smaller = true;
            }
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(8);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter center() {
            if (!this.myLines.isEmpty()) {
                ((LineInfo)this.myLines.get(this.myLines.size() - 1).getSecond()).center = true;
            }
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(9);
            }
            return textPainter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(@NotNull Graphics g, @NotNull PairFunction<? super Integer, ? super Integer, ? extends Couple<Integer>> _position) {
            if (g == null) {
                TextPainter.$$$reportNull$$$0(10);
            }
            if (_position == null) {
                TextPainter.$$$reportNull$$$0(11);
            }
            GraphicsUtil.setupAntialiasing(g, true, true);
            Font oldFont = null;
            if (this.myFont != null) {
                oldFont = g.getFont();
                g.setFont(this.myFont);
            }
            Color oldColor = null;
            if (this.myColor != null) {
                oldColor = g.getColor();
                g.setColor(this.myColor);
            }
            try {
                int[] maxWidth = new int[]{0};
                int[] height = new int[]{0};
                ContainerUtil.process(this.myLines, pair -> {
                    LineInfo info = (LineInfo)pair.getSecond();
                    Font old = null;
                    if (info.smaller) {
                        old = g.getFont();
                        g.setFont(old.deriveFont((float)old.getSize() * 0.7f));
                    }
                    FontMetrics fm = g.getFontMetrics();
                    maxWidth[0] = Math.max(fm.stringWidth(((String)pair.getFirst()).replace("<shortcut>", "").replace("</shortcut>", "")), maxWidth[0]);
                    height[0] = (int)((float)height[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    if (old != null) {
                        g.setFont(old);
                    }
                    return true;
                });
                Couple position = (Couple)_position.fun((Object)(maxWidth[0] + 20), (Object)height[0]);
                assert (position != null);
                int[] yOffset = new int[]{(Integer)position.getSecond()};
                ContainerUtil.process(this.myLines, pair -> {
                    LineInfo info = (LineInfo)pair.getSecond();
                    String text = (String)pair.first;
                    String shortcut = "";
                    if (((String)pair.first).contains("<shortcut>")) {
                        shortcut = text.substring(text.indexOf("<shortcut>") + "<shortcut>".length(), text.indexOf("</shortcut>"));
                        text = text.substring(0, text.indexOf("<shortcut>"));
                    }
                    Font old = null;
                    if (info.smaller) {
                        old = g.getFont();
                        g.setFont(old.deriveFont((float)old.getSize() * 0.7f));
                    }
                    int x = (Integer)position.getFirst() + 10;
                    FontMetrics fm = g.getFontMetrics();
                    int xOffset = x;
                    if (info.center) {
                        xOffset = x + (maxWidth[0] - fm.stringWidth(text)) / 2;
                    }
                    if (this.myDrawShadow) {
                        int xOff = UIUtil.isUnderDarcula() ? 1 : 0;
                        Color oldColor1 = g.getColor();
                        g.setColor(this.myShadowColor);
                        int yOff = 1;
                        g.drawString(text, xOffset + xOff, yOffset[0] + yOff);
                        g.setColor(oldColor1);
                    }
                    g.drawString(text, xOffset, yOffset[0]);
                    if (!StringUtil.isEmpty((String)shortcut)) {
                        Color oldColor1 = g.getColor();
                        g.setColor(JBColor.namedColor("Editor.shortcutForeground", new JBColor(new Color(82, 99, 155), new Color(88, 157, 246))));
                        g.drawString(shortcut, xOffset + fm.stringWidth(text + (UIUtil.isUnderDarcula() ? " " : "")), yOffset[0]);
                        g.setColor(oldColor1);
                    }
                    if (info.underlined) {
                        Color c = null;
                        if (info.underlineColor != null) {
                            c = g.getColor();
                            g.setColor(info.underlineColor);
                        }
                        UIUtil.drawLine(g, x - 10, yOffset[0] + fm.getDescent(), x + maxWidth[0] + 10, yOffset[0] + fm.getDescent());
                        if (c != null) {
                            g.setColor(c);
                        }
                        if (this.myDrawShadow) {
                            c = g.getColor();
                            g.setColor(this.myShadowColor);
                            UIUtil.drawLine(g, x - 10, yOffset[0] + fm.getDescent() + 1, x + maxWidth[0] + 10, yOffset[0] + fm.getDescent() + 1);
                            g.setColor(c);
                        }
                    }
                    yOffset[0] = (int)((float)yOffset[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    if (old != null) {
                        g.setFont(old);
                    }
                    return true;
                });
            }
            finally {
                if (oldFont != null) {
                    g.setFont(oldFont);
                }
                if (oldColor != null) {
                    g.setColor(oldColor);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 10: 
                case 11: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 10: 
                case 11: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShadow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLineSpacing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFont";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendLine";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "underlined";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "smaller";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "center";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "draw";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 10: 
                case 11: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class LineInfo {
            private boolean underlined;
            private Color underlineColor;
            private boolean smaller;
            private boolean center;

            private LineInfo() {
            }
        }
    }

    public static final class JBWordWrapHtmlEditorKit
    extends JBHtmlEditorKit {
        private final HTMLEditorKit.HTMLFactory myFactory = new HTMLEditorKit.HTMLFactory(){

            @Override
            public View create(Element e) {
                View view = super.create(e);
                if (view instanceof ParagraphView) {
                    return new ParagraphView(e){

                        @Override
                        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                            if (r == null) {
                                r = new SizeRequirements();
                            }
                            r.minimum = (int)this.layoutPool.getMinimumSpan(axis);
                            r.preferred = Math.max(r.minimum, (int)this.layoutPool.getPreferredSpan(axis));
                            r.maximum = Integer.MAX_VALUE;
                            r.alignment = 0.5f;
                            return r;
                        }
                    };
                }
                return view;
            }
        };

        @Override
        public ViewFactory getViewFactory() {
            return this.myFactory;
        }
    }

    public static enum FontColor {
        NORMAL,
        BRIGHTER;

    }

    public static enum ComponentStyle {
        LARGE,
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }

    @ApiStatus.Experimental
    public static class GrayFilter
    extends RGBImageFilter {
        private float brightness;
        private float contrast;
        private int alpha;
        private int origContrast;
        private int origBrightness;

        public GrayFilter(int brightness, int contrast, int alpha) {
            this.setBrightness(brightness);
            this.setContrast(contrast);
            this.setAlpha(alpha);
        }

        public GrayFilter() {
            this(0, 0, 100);
        }

        private void setBrightness(int brightness) {
            this.origBrightness = Math.max(-100, Math.min(100, brightness));
            this.brightness = (float)(Math.pow(this.origBrightness, 3.0) / 10000.0);
        }

        public int getBrightness() {
            return this.origBrightness;
        }

        private void setContrast(int contrast) {
            this.origContrast = Math.max(-100, Math.min(100, contrast));
            this.contrast = (float)this.origContrast / 100.0f;
        }

        public int getContrast() {
            return this.origContrast;
        }

        private void setAlpha(int alpha) {
            this.alpha = Math.max(0, Math.min(100, alpha));
        }

        public int getAlpha() {
            return this.alpha;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)(0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF));
            gray = this.brightness >= 0.0f ? (int)(((float)gray + this.brightness * 255.0f) / (1.0f + this.brightness)) : (int)((float)gray / (1.0f - this.brightness));
            gray = this.contrast >= 0.0f ? (gray >= 127 ? (int)((float)gray + (float)(255 - gray) * this.contrast) : (int)((float)gray - (float)gray * this.contrast)) : (int)(127.0f + (float)(gray - 127) * (this.contrast + 1.0f));
            int a = (rgb >> 24 & 0xFF) * this.alpha / 100;
            return a << 24 | gray << 16 | gray << 8 | gray;
        }

        @NotNull
        public GrayFilterUIResource asUIResource() {
            GrayFilterUIResource grayFilterUIResource = new GrayFilterUIResource(this);
            if (grayFilterUIResource == null) {
                GrayFilter.$$$reportNull$$$0(0);
            }
            return grayFilterUIResource;
        }

        @NotNull
        public static GrayFilter namedFilter(@NotNull String resourceName, @NotNull GrayFilter defaultFilter) {
            if (resourceName == null) {
                GrayFilter.$$$reportNull$$$0(1);
            }
            if (defaultFilter == null) {
                GrayFilter.$$$reportNull$$$0(2);
            }
            GrayFilter grayFilter = (GrayFilter)ObjectUtils.notNull((Object)((GrayFilter)UIManager.get(resourceName)), (Object)defaultFilter);
            if (grayFilter == null) {
                GrayFilter.$$$reportNull$$$0(3);
            }
            return grayFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asUIResource";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namedFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "namedFilter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class GrayFilterUIResource
        extends GrayFilter
        implements UIResource {
            public GrayFilterUIResource(@NotNull GrayFilter filter) {
                if (filter == null) {
                    GrayFilterUIResource.$$$reportNull$$$0(0);
                }
                super(filter.origBrightness, filter.origContrast, filter.alpha);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/UIUtil$GrayFilter$GrayFilterUIResource", "<init>"));
            }
        }
    }
}

