/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.protege.editor.owl.ui.renderer.layout.LinkSpan;
import org.protege.editor.owl.ui.renderer.layout.PageLayoutState;
import org.protege.editor.owl.ui.renderer.layout.PageObject;
import org.protege.editor.owl.ui.renderer.layout.Paragraph;

public class Page
extends PageObject {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    private PageLayoutState layoutState = PageLayoutState.INVALID;
    private LinkSpan activeLinkSpan;

    public Paragraph addParagraph(String paragraph) {
        return this.addParagraph(paragraph, DEFAULT_FOREGROUND);
    }

    public Paragraph addParagraph(String paragraph, Color foreground) {
        Paragraph para = new Paragraph(paragraph);
        para.setForeground(foreground);
        this.add(para);
        return para;
    }

    public Paragraph addParagraph(String paragraph, Link link) {
        Paragraph para = new Paragraph(paragraph, link);
        this.add(para);
        return para;
    }

    @Override
    public void invalidateLayout() {
        this.layoutState = PageLayoutState.INVALID;
    }

    @Override
    public void layout(FontRenderContext fontRenderContext) {
        if (this.layoutState.equals((Object)PageLayoutState.VALID)) {
            return;
        }
        int verticalOffset = this.getInsetsTop();
        for (PageObject childPageObject : this.getChildren()) {
            int insetsLeft = this.getInsetsLeft();
            childPageObject.setX(insetsLeft);
            childPageObject.setY(verticalOffset);
            childPageObject.setWidth(this.getWidth() - this.getInsetsLeft() - this.getInsetsRight());
            childPageObject.layout(fontRenderContext);
            verticalOffset += childPageObject.getHeight();
        }
        int height = verticalOffset + this.getInsetsBottom();
        this.setHeight(height);
        this.layoutState = PageLayoutState.VALID;
    }

    @Override
    public void paintContent(Graphics2D g) {
    }

    public void setLocation(int x, int y) {
        this.setX(x);
        this.setY(y);
    }
}

