/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.splitbybookmarks;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.module.RequiredPdfData;
import org.pdfsam.splitbybookmarks.SplitByOutlineLevelParametersBuilder;
import org.pdfsam.splitbybookmarks.SplitOptionsPane;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.module.Footer;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.RunButton;
import org.pdfsam.ui.prefix.PrefixPane;
import org.pdfsam.ui.selection.single.TaskParametersBuilderSingleSelectionPane;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.injector.Auto;
import org.sejda.injector.Components;
import org.sejda.injector.Provides;
import org.sejda.model.parameter.SplitByOutlineLevelParameters;
import org.sejda.model.prefix.Prefix;

@Auto
public class SplitByBookmarksModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "split.bybookmarks";
    private TaskParametersBuilderSingleSelectionPane selectionPane;
    private BrowsableOutputDirectoryField destinationDirectoryField;
    private PdfDestinationPane destinationPane;
    private SplitOptionsPane splitOptions = new SplitOptionsPane();
    private PrefixPane prefix = new PrefixPane();
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.SPLIT).inputTypes(new ModuleInputOutputType[]{ModuleInputOutputType.SINGLE_PDF}).name(DefaultI18nContext.getInstance().i18n("Split by bookmarks")).description(DefaultI18nContext.getInstance().i18n("Split a PDF document at bookmarked pages by specifying a bookmark level.")).priority(ModulePriority.DEFAULT.getPriority()).supportURL("http://www.pdfsam.org/pdf-split-by-bookmark").build();

    @Inject
    public SplitByBookmarksModule(@Named(value="split.bybookmarksfield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="split.bybookmarkspane") PdfDestinationPane destinationPane, @Named(value="split.bybookmarksfooter") Footer footer) {
        super(footer);
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.selectionPane = new TaskParametersBuilderSingleSelectionPane(this.id());
        this.selectionPane.setPromptText(DefaultI18nContext.getInstance().i18n("Select or drag and drop the PDF you want to split"));
        this.selectionPane.addOnLoaded(d -> this.splitOptions.setValidBookmarkLevels(d.getValidBookmarksLevels()));
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.splitOptions.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.splitOptions.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    protected Builder<SplitByOutlineLevelParameters> getBuilder(Consumer<String> onError) {
        SplitByOutlineLevelParametersBuilder builder = new SplitByOutlineLevelParametersBuilder();
        this.splitOptions.apply(builder, onError);
        this.selectionPane.apply((SinglePdfSourceTaskParametersBuilder)builder, onError);
        this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        this.prefix.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        return builder;
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        TitledPane prefixTitled = Views.titledPane((String)DefaultI18nContext.getInstance().i18n("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.CURRENTPAGE});
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.FILENUMBER});
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.BOOKMARK});
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.BOOKMARK_STRICT});
        this.prefix.addMenuItemFor(new String[]{"[TOTAL_FILESNUMBER]"});
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Split settings"), (Node)this.splitOptions), Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Output settings"), (Node)this.destinationPane), prefixTitled});
        return pane;
    }

    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @EventListener
    public void onClearModule(ClearModuleEvent e) {
        if (e.clearEverything) {
            this.splitOptions.resetView();
            this.prefix.resetView();
            this.destinationPane.resetView();
        }
    }

    public RequiredPdfData[] requires() {
        return new RequiredPdfData[]{RequiredPdfData.DEFAULT, RequiredPdfData.BOOMARKS};
    }

    public Node graphic() {
        return new ImageView("split_by_bookmarks.png");
    }

    @Components(value={SplitByBookmarksModule.class})
    public static class ModuleConfig {
        @Provides
        @Named(value="split.bybookmarksfield")
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Provides
        @Named(value="split.bybookmarkspane")
        public PdfDestinationPane destinationPane(@Named(value="split.bybookmarksfield") BrowsableOutputDirectoryField outputField, UserContext userContext) {
            PdfDestinationPane panel = new PdfDestinationPane((BrowsableField)outputField, SplitByBookmarksModule.MODULE_ID, userContext, new PdfDestinationPane.DestinationPanelFields[]{PdfDestinationPane.DestinationPanelFields.DISCARD_BOOKMARKS});
            panel.enableSameAsSourceItem();
            return panel;
        }

        @Provides
        @Named(value="split.bybookmarksfooter")
        public Footer footer(RunButton runButton, @Named(value="split.bybookmarksopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, SplitByBookmarksModule.MODULE_ID);
        }

        @Provides
        @Named(value="split.bybookmarksopenButton")
        public OpenButton openButton() {
            return new OpenButton(SplitByBookmarksModule.MODULE_ID, ModuleInputOutputType.MULTIPLE_PDF);
        }
    }
}

