/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.excel;

import java.util.ArrayList;
import java.util.List;
import org.sejda.impl.sambox.component.excel.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DataTableUtils.class);

    private DataTableUtils() {
    }

    public static List<DataTable> mergeTablesSpanningMultiplePages(List<DataTable> dataTables) {
        ArrayList<DataTable> results = new ArrayList<DataTable>();
        DataTable current = null;
        for (DataTable dt : dataTables) {
            if (current != null) {
                if (current.hasSameColumnsAs(dt)) {
                    current = current.mergeWith(dt);
                    continue;
                }
                results.add(current);
                current = dt;
                continue;
            }
            current = dt;
        }
        if (current != null) {
            results.add(current);
        }
        return results;
    }

    public static List<DataTable> mergeComplementaryColumns(List<DataTable> dataTables) {
        ArrayList<DataTable> results = new ArrayList<DataTable>();
        for (DataTable dt : dataTables) {
            results.add(DataTableUtils.mergeComplementaryColumns(dt));
        }
        return results;
    }

    static DataTable mergeComplementaryColumns(DataTable dataTable) {
        DataTable result = dataTable;
        boolean again = true;
        block0: while (again) {
            again = false;
            for (int c = 0; c < result.getColumnsCount() - 1; ++c) {
                List<String> column2;
                List<String> column1 = result.getColumn(c);
                if (!DataTableUtils.areComplementary(column1, column2 = result.getColumn(c + 1))) continue;
                LOG.debug("Merging complementary columns {} and {}", (Object)c, (Object)(c + 1));
                result = result.mergeColumns(c, c + 1);
                again = true;
                continue block0;
            }
        }
        return result;
    }

    static boolean areComplementary(List<String> column1, List<String> column2) {
        if (column1.size() != column2.size()) {
            return false;
        }
        for (int i = 0; i < column1.size(); ++i) {
            String v1 = column1.get(i);
            String v2 = column2.get(i);
            if (v1.trim().isEmpty() || v2.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

