/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.resources.RegionAddressRepository;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import net.sourceforge.offroad.data.QuadRectExtendable;
import net.sourceforge.offroad.data.RegionAsMapObject;
import net.sourceforge.offroad.data.TrivialResultMatcher;
import net.sourceforge.offroad.ui.FilteredListModel;

public class SearchAddressAction
extends OffRoadAction {
    MapObjectStore<RegionAsMapObject> mRegionStore;

    public SearchAddressAction(OsmWindow ctx) {
        super(ctx);
    }

    protected Comparator<? super RegionAddressRepository> createComparator() {
        return new Comparator<RegionAddressRepository>(){
            Collator col = Collator.getInstance();

            @Override
            public int compare(RegionAddressRepository lhs, RegionAddressRepository rhs) {
                return this.col.compare(lhs.getName(), rhs.getName());
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.createDialog();
        this.setWaitingCursor();
        this.mDialog.setTitle(this.getResourceString("search"));
        Container contentPane = this.mDialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        int y = 0;
        this.mRegionStore = new MapObjectStore<RegionAsMapObject>(){

            @Override
            public Collection<City> getSubObjects(RegionAsMapObject pObj) {
                RegionAddressRepository region;
                this.mRegion = region = pObj.getRegion();
                if (region != null) {
                    region.preloadCities(new TrivialResultMatcher<City>());
                    return region.getLoadedCities();
                }
                return Collections.emptyList();
            }

            @Override
            public String loadSetting(OsmandSettings pSettings) {
                return pSettings.getLastSearchedRegion();
            }

            @Override
            public void saveSetting(OsmandSettings pSettings, String pValue) {
                pSettings.setLastSearchedRegion(pValue, SearchAddressAction.this.getLatLon());
            }
        };
        y = this.mRegionStore.addMapObject(contentPane, y, "region");
        if (!this.mContext.getResourceManager().getAddressRepositories().isEmpty()) {
            ArrayList<RegionAddressRepository> initialListToFilter = new ArrayList<RegionAddressRepository>(this.mContext.getResourceManager().getAddressRepositories());
            for (RegionAddressRepository regionAddressRepository : initialListToFilter) {
                this.mRegionStore.mSourceModel.addElement(new RegionAsMapObject(regionAddressRepository));
            }
        }
        MapObjectStore<City> cityStore = new MapObjectStore<City>(){

            @Override
            public Collection<Street> getSubObjects(City pObj) {
                this.mRegion.preloadStreets(pObj, new TrivialResultMatcher<Street>());
                return pObj.getStreets();
            }

            @Override
            public String loadSetting(OsmandSettings pSettings) {
                return pSettings.getLastSearchedCityName();
            }

            @Override
            public void saveSetting(OsmandSettings pSettings, String pValue) {
                City selectedCity = (City)this.mList.getSelectedValue();
                Long id2 = 0L;
                if (selectedCity != null) {
                    id2 = selectedCity.getId();
                }
                pSettings.setLastSearchedCity(id2, pValue, SearchAddressAction.this.getLatLon());
            }

            @Override
            protected void addBoundingObjects(City pSelected, Vector<MapObject> pMoreObjects) {
                super.addBoundingObjects(pSelected, pMoreObjects);
                pMoreObjects.add(pSelected.getClosestCity());
            }
        };
        y = cityStore.addMapObject(contentPane, y, "city");
        MapObjectStore<Street> streetStore = new MapObjectStore<Street>(){

            @Override
            public Collection<Building> getSubObjects(Street pObj) {
                this.mRegion.preloadBuildings(pObj, new TrivialResultMatcher<Building>());
                return pObj.getBuildings();
            }

            @Override
            public String loadSetting(OsmandSettings pSettings) {
                return pSettings.getLastSearchedStreet();
            }

            @Override
            public void saveSetting(OsmandSettings pSettings, String pValue) {
                pSettings.setLastSearchedStreet(pValue, SearchAddressAction.this.getLatLon());
            }

            @Override
            protected void addBoundingObjects(Street pSelected, Vector<MapObject> pMoreObjects) {
                super.addBoundingObjects(pSelected, pMoreObjects);
                pMoreObjects.addAll(pSelected.getIntersectedStreets());
            }
        };
        y = streetStore.addMapObject(contentPane, y, "street");
        MapObjectStore<Building> buildingStore = new MapObjectStore<Building>(){

            @Override
            public Collection<MapObject> getSubObjects(Building pObj) {
                return Collections.emptyList();
            }

            @Override
            public String loadSetting(OsmandSettings pSettings) {
                return pSettings.getLastSearchedBuilding();
            }

            @Override
            public void saveSetting(OsmandSettings pSettings, String pValue) {
                pSettings.setLastSearchedBuilding(pValue, SearchAddressAction.this.getLatLon());
            }
        };
        y = buildingStore.addMapObject(contentPane, y, "building");
        this.mRegionStore.setNextStore(cityStore).setNextStore(streetStore).setNextStore(buildingStore);
        this.mRegionStore.load(this.mContext.getSettings());
        this.mRegionStore.mTextField.selectAll();
        this.mRegionStore.addSelectionListener();
        this.mDialog.pack();
        this.removeWaitingCursor();
        this.decorateDialog();
        this.mDialog.setVisible(true);
    }

    @Override
    public void save() {
        super.save();
        this.mRegionStore.save(this.mContext.getSettings());
    }

    protected LatLon getLatLon() {
        return this.mContext.getDrawPanel().copyCurrentTileBox().getCenterLatLon();
    }

    private final class FilterTextDocumentListener<T extends MapObject>
    implements DocumentListener {
        private static final int TYPE_DELAY_TIME = 500;
        private MapObjectStore<T> mMapObjectStore;
        private Timer mTypeDelayTimer = null;

        public FilterTextDocumentListener(MapObjectStore<T> pMapObjectStore) {
            this.mMapObjectStore = pMapObjectStore;
        }

        private synchronized void change(DocumentEvent event) {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.cancel();
                this.mTypeDelayTimer = null;
            }
            this.mTypeDelayTimer = new Timer();
            this.mTypeDelayTimer.schedule((TimerTask)new DelayedTextEntry(event), 500L);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.change(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.change(event);
        }

        protected class DelayedTextEntry
        extends TimerTask {
            private final DocumentEvent event;

            DelayedTextEntry(DocumentEvent event) {
                this.event = event;
            }

            private String getText(Document document) throws BadLocationException {
                String text = document.getText(0, document.getLength());
                return text;
            }

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            List selectedValuesList = ((FilterTextDocumentListener)FilterTextDocumentListener.this).mMapObjectStore.mList.getSelectedValuesList();
                            Document document = DelayedTextEntry.this.event.getDocument();
                            String text = DelayedTextEntry.this.getText(document);
                            FilterTextDocumentListener.this.mMapObjectStore.mTextFilter.setText(text);
                            boolean filterAccepted = true;
                            for (MapObject obj : selectedValuesList) {
                                if (FilterTextDocumentListener.this.mMapObjectStore.mTextFilter.accept(obj)) continue;
                                filterAccepted = false;
                            }
                            if (!filterAccepted) {
                                ((FilterTextDocumentListener)FilterTextDocumentListener.this).mMapObjectStore.mList.clearSelection();
                            }
                            ((FilterTextDocumentListener)FilterTextDocumentListener.this).mMapObjectStore.mFilteredSourceModel.setFilter(FilterTextDocumentListener.this.mMapObjectStore.mTextFilter);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    abstract class MapObjectStore<T extends MapObject> {
        RegionAddressRepository mRegion;
        JTextField mTextField;
        DefaultListModel<T> mSourceModel;
        FilteredListModel mFilteredSourceModel;
        JList<T> mList;
        ListSelectionListener mSelectionListener;
        KeyListener mKeyListener;
        MouseListener mMouseListener;
        private MapObjectStore mNextStore;
        private T selected;
        private T previousSelected;
        private FilteredListModel.Filter<T> mTextFilter;
        private String mName;

        MapObjectStore() {
        }

        public abstract Collection<? extends MapObject> getSubObjects(T var1);

        public MapObjectStore setNextStore(MapObjectStore pNextStore) {
            this.mNextStore = pNextStore;
            return this.mNextStore;
        }

        public abstract String loadSetting(OsmandSettings var1);

        public abstract void saveSetting(OsmandSettings var1, String var2);

        public void load(OsmandSettings pSettings) {
            String lastText = this.loadSetting(pSettings);
            this.mTextField.setText(lastText);
            this.mTextFilter.setText(lastText);
            this.mFilteredSourceModel.setFilter(this.mTextFilter);
            if (this.mFilteredSourceModel.getSize() >= 1) {
                this.mList.setSelectedIndex(0);
            }
            if (this.mNextStore != null) {
                this.setSelectedItem((MapObject)this.mList.getSelectedValue());
                this.mNextStore.load(pSettings);
            }
        }

        public void save(OsmandSettings pSettings) {
            String text = this.mTextField.getText();
            if (!this.mList.isSelectionEmpty()) {
                text = ((MapObject)this.mList.getSelectedValue()).getName();
            }
            this.saveSetting(pSettings, text);
            if (this.mNextStore != null) {
                this.mNextStore.save(pSettings);
            }
        }

        public int addMapObject(Container contentPane, int y, String pName) {
            this.mName = pName;
            contentPane.add((Component)new JLabel(SearchAddressAction.this.getResourceString(pName)), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.mTextField = new JTextField();
            contentPane.add((Component)this.mTextField, new GridBagConstraints(1, y++, 1, 1, 4.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.mSourceModel = new DefaultListModel();
            this.mFilteredSourceModel = new FilteredListModel(this.mSourceModel);
            this.mList = new JList(this.mFilteredSourceModel);
            this.mList.setCellRenderer(new MyRenderer());
            this.mTextFilter = new FilteredListModel.Filter<T>(){

                @Override
                public boolean accept(T pElement) {
                    String text = this.getText().toLowerCase();
                    String elementText = ((MapObject)pElement).getName().toLowerCase();
                    return elementText.contains(text);
                }
            };
            this.mTextField.getDocument().addDocumentListener(new FilterTextDocumentListener(this));
            this.mTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent pE) {
                    if (pE.getKeyCode() == 40) {
                        pE.consume();
                        MapObjectStore.this.mList.requestFocus();
                        MapObjectStore.this.selectFirstElementIfNecessary();
                    }
                    if (pE.getKeyCode() == 10) {
                        pE.consume();
                        if (MapObjectStore.this.mNextStore != null) {
                            MapObjectStore.this.selectFirstElementIfNecessary();
                            MapObjectStore.this.mNextStore.requestFocusToTextField();
                        } else {
                            MapObjectStore.this.selectFirstElementIfNecessary();
                            MapObjectStore.this.moveToEntity((MapObject)MapObjectStore.this.mList.getSelectedValue());
                        }
                    }
                }
            });
            this.mKeyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent pE) {
                    if (pE.getKeyCode() == 10) {
                        pE.consume();
                        MapObjectStore.this.moveToEntity((MapObject)MapObjectStore.this.mList.getSelectedValue());
                    }
                    if (pE.getKeyCode() == 38 && MapObjectStore.this.mList.getSelectedIndex() == 0) {
                        pE.consume();
                        MapObjectStore.this.requestFocusToTextField();
                    }
                    super.keyTyped(pE);
                }
            };
            this.mList.addKeyListener(this.mKeyListener);
            this.mMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() >= 2) {
                        evt.consume();
                        MapObjectStore.this.moveToEntity((MapObject)MapObjectStore.this.mList.getSelectedValue());
                    }
                }
            };
            this.mList.addMouseListener(this.mMouseListener);
            contentPane.add((Component)new JScrollPane(this.mList), new GridBagConstraints(0, y++, 2, 1, 1.0, 4.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return y;
        }

        public void selectFirstElementIfNecessary() {
            if (this.mList.isSelectionEmpty() && this.mList.getModel().getSize() > 0) {
                this.mList.setSelectedIndex(0);
            }
        }

        public void requestFocusToTextField() {
            this.mTextField.selectAll();
            this.mTextField.requestFocus();
        }

        public void addSelectionListener() {
            if (this.mNextStore == null) {
                return;
            }
            this.mSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent pE) {
                    if (MapObjectStore.this.mList.isSelectionEmpty()) {
                        MapObjectStore.this.previousSelected = null;
                        MapObjectStore.this.selected = null;
                        MapObjectStore.this.mNextStore.clear();
                        return;
                    }
                    MapObjectStore.this.selected = (MapObject)MapObjectStore.this.mList.getSelectedValue();
                    if (MapObjectStore.this.selected != null) {
                        SearchAddressAction.this.setWaitingCursor();
                        if (!MapObjectStore.this.selected.equals(MapObjectStore.this.previousSelected)) {
                            MapObjectStore.this.mNextStore.clear();
                        }
                        MapObjectStore.this.previousSelected = MapObjectStore.this.selected;
                        MapObjectStore.this.setSelectedItem(MapObjectStore.this.selected);
                        SearchAddressAction.this.removeWaitingCursor();
                    }
                }
            };
            this.mList.addListSelectionListener(this.mSelectionListener);
            if (this.mNextStore != null) {
                this.mNextStore.addSelectionListener();
            }
        }

        public void setSelectedItem(T pSelected) {
            if (pSelected == null) {
                return;
            }
            this.selected = pSelected;
            Collection<MapObject> subObjects = this.getSubObjects(this.selected);
            this.mNextStore.insertList(subObjects, this.mRegion);
        }

        public void insertList(Collection<T> subObjects, RegionAddressRepository pRegion) {
            this.mRegion = pRegion;
            this.mFilteredSourceModel.setFilter(null);
            this.mSourceModel.clear();
            for (MapObject sub : subObjects) {
                this.mSourceModel.addElement(sub);
            }
        }

        public void moveToEntity(MapObject obj) {
            if (obj != null) {
                SearchAddressAction.this.disposeDialog();
                QuadRectExtendable rect = null;
                if (this.selected != null) {
                    Collection<MapObject> subObjects = this.getSubObjects(this.selected);
                    Vector<MapObject> moreObjects = new Vector<MapObject>(subObjects);
                    this.addBoundingObjects(this.selected, moreObjects);
                    rect = new QuadRectExtendable(((MapObject)this.selected).getLocation());
                    for (MapObject sub : subObjects) {
                        rect.insert(sub.getLocation());
                    }
                }
                SearchAddressAction.this.mContext.move(obj.getLocation(), rect);
            }
        }

        protected void addBoundingObjects(T pSelected, Vector<MapObject> pMoreObjects) {
        }

        public void clear() {
            this.mList.clearSelection();
            this.mSourceModel.clear();
            this.mTextField.setText("");
            this.mTextFilter.setText("");
            this.mFilteredSourceModel.setFilter(null);
            if (this.mNextStore != null) {
                this.mNextStore.clear();
            }
        }

        class MyRenderer
        extends DefaultListCellRenderer {
            MyRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((MapObject)value).getName());
                return c;
            }
        }
    }
}

