# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.volume import Volume


class MultiVolume(Volume):
    """
    MultiVolume - Represents a world axis-aligned bounding-box
    containing a set of volumes in a rendered scene.
    
    Superclass: Volume
    
    Volume instances registered in this class can be overlapping. They
    are intended to be all rendered simultaneously by a
    GPUVolumeRayCastMapper (inputs should be set directly in the
    mapper).
    
    This class holds the full transformation of a bounding-box containing
    all of the registered volumes.
    
    
         + tex_to_b_box : Texture-to-Data (scaling)
         + Matrix : Data-to-World (translation)
    
    ote This class is intended to be used only by mappers supporting
    multiple inputs.
    
    @sa Volume AbstractVolumeMapper GPUVolumeRayCastMapper
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMultiVolume, obj, update, **traits)
    
    def _get_property(self):
        return wrap_vtk(self._vtk_obj.GetProperty())
    def _set_property(self, arg):
        old_val = self._get_property()
        self._wrap_call(self._vtk_obj.SetProperty,
                        deref_vtk(arg))
        self.trait_property_changed('property', old_val, arg)
    property = traits.Property(_get_property, _set_property, desc=\
        """
        Given that this class represents a bounding-box only there is no
        property directly associated with it (a cannot be set directly).
        This instance will return the property of the volume registered
        in the 0th port (or nullptr if no volume has been set).
        \sa Volume
        """
    )

    def get_volume(self, *args):
        """
        V.get_volume(int) -> Volume
        C++: Volume *GetVolume(int port=0)
        Add / Remove a Volume instance.
        """
        ret = self._wrap_call(self._vtk_obj.GetVolume, *args)
        return wrap_vtk(ret)

    def set_volume(self, *args):
        """
        V.set_volume(Volume, int)
        C++: void SetVolume(Volume *volume, int port=0)
        Add / Remove a Volume instance.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVolume, *my_args)
        return ret

    def _get_bounds_time(self):
        return self._vtk_obj.GetBoundsTime()
    bounds_time = traits.Property(_get_bounds_time, desc=\
        """
        
        """
    )

    def _get_data_bounds(self):
        return self._vtk_obj.GetDataBounds()
    data_bounds = traits.Property(_get_data_bounds, desc=\
        """
        Total bounds in data coordinates.
        """
    )

    def _get_texture_matrix(self):
        return wrap_vtk(self._vtk_obj.GetTextureMatrix())
    texture_matrix = traits.Property(_get_texture_matrix, desc=\
        """
        Returns the transformation from texture coordinates to data
        cooridinates of the bounding-box. Since this class represents an
        axis-aligned bounding
        -box_this, this transformation only contains a scaling diagonal.
        """
    )

    def remove_volume(self, *args):
        """
        V.remove_volume(int)
        C++: void RemoveVolume(int port)
        Add / Remove a Volume instance.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveVolume, *args)
        return ret

    _updateable_traits_ = \
    (('dragable', 'GetDragable'), ('pickable', 'GetPickable'),
    ('use_bounds', 'GetUseBounds'), ('visibility', 'GetVisibility'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('orientation', 'GetOrientation'),
    ('origin', 'GetOrigin'), ('position', 'GetPosition'), ('scale',
    'GetScale'), ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'global_warning_display', 'pickable',
    'use_bounds', 'visibility', 'estimated_render_time', 'orientation',
    'origin', 'position', 'render_time_multiplier', 'scale'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MultiVolume, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MultiVolume properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_bounds', 'visibility'], [], ['estimated_render_time',
            'orientation', 'origin', 'position', 'render_time_multiplier',
            'scale']),
            title='Edit MultiVolume properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MultiVolume properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

