# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.selection_algorithm import SelectionAlgorithm


class BoostKruskalMinimumSpanningTree(SelectionAlgorithm):
    """
    BoostKruskalMinimumSpanningTree - Constructs a minimum spanning
       tree from a graph and the weighting array
    
    Superclass: SelectionAlgorithm
    
    This vtk class uses the Boost Kruskal Minimum Spanning Tree generic
    algorithm to perform a minimum spanning tree creation given a
    weighting value for each of the edges in the input graph.
    
    @sa
    Graph BoostGraphAdapter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostKruskalMinimumSpanningTree, obj, update, **traits)
    
    negate_edge_weights = tvtk_base.false_bool_trait(desc=\
        """
        Whether to negate the edge weights. By negating the edge weights
        this algorithm will give you the 'maximal' spanning tree (i.e.
        the algorithm will try to create a spanning tree with the highest
        weighted edges). Defaulted to Off. FIXME: put a real definition
        in...
        """
    )

    def _negate_edge_weights_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNegateEdgeWeights,
                        self.negate_edge_weights_)

    def set_edge_weight_array_name(self, *args):
        """
        V.set_edge_weight_array_name(string)
        C++: virtual void SetEdgeWeightArrayName(const char *_arg)
        Set the name of the edge-weight input array, which must name an
        array that is part of the edge data of the input graph and
        contains numeric data. If the edge-weight array is not of type
        DoubleArray, the array will be copied into a temporary
        DoubleArray.
        """
        ret = self._wrap_call(self._vtk_obj.SetEdgeWeightArrayName, *args)
        return ret

    def set_output_selection_type(self, *args):
        """
        V.set_output_selection_type(string)
        C++: virtual void SetOutputSelectionType(const char *_arg)
        Set the output selection type. The default is to use the the set
        of minimum spanning tree edges "MINIMUM_SPANNING_TREE_EDGES". No
        other options are defined.
        """
        ret = self._wrap_call(self._vtk_obj.SetOutputSelectionType, *args)
        return ret

    _updateable_traits_ = \
    (('negate_edge_weights', 'GetNegateEdgeWeights'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'negate_edge_weights', 'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostKruskalMinimumSpanningTree, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostKruskalMinimumSpanningTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['negate_edge_weights'], [], []),
            title='Edit BoostKruskalMinimumSpanningTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostKruskalMinimumSpanningTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

