/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

public final class ExceptionReceivedEventArgs {
    public static final String NO_ASSOCIATED_PARTITION = "N/A";
    private final String hostname;
    private final Exception exception;
    private final String action;
    private final String partitionId;

    ExceptionReceivedEventArgs(String hostname, Exception exception, String action) {
        this(hostname, exception, action, NO_ASSOCIATED_PARTITION);
    }

    ExceptionReceivedEventArgs(String hostname, Exception exception, String action, String partitionId) {
        this.hostname = hostname;
        this.exception = exception;
        this.action = action;
        if (partitionId == null || partitionId.isEmpty()) {
            throw new IllegalArgumentException("PartitionId must not be null or empty");
        }
        this.partitionId = partitionId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getAction() {
        return this.action;
    }

    public String getPartitionId() {
        return this.partitionId;
    }
}

