/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.AbstractMastersSlavesListener;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.thread.FailoverLoop;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.ReconnectDuringTransactionException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class MastersSlavesListener
extends AbstractMastersSlavesListener {
    private static final DynamicSizedSchedulerInterface dynamicSizedScheduler;
    private static final AtomicInteger listenerCount;
    private static final Logger logger;
    protected Protocol masterProtocol;
    protected Protocol secondaryProtocol;

    public MastersSlavesListener(UrlParser urlParser, GlobalStateInfo globalInfo) {
        super(urlParser, globalInfo);
        listenerCount.incrementAndGet();
        this.masterProtocol = null;
        this.secondaryProtocol = null;
        this.setMasterHostFail();
        this.setSecondaryHostFail();
    }

    @Override
    protected void removeListenerFromSchedulers() {
        super.removeListenerFromSchedulers();
        FailoverLoop.removeListener(this);
        listenerCount.addAndGet(-1);
    }

    @Override
    public void initializeConnection() throws SQLException {
        super.initializeConnection();
        try {
            this.reconnectFailedConnection(new SearchFilter(true));
        }
        catch (SQLException e) {
            this.checkInitialConnection(e);
        }
    }

    protected void checkInitialConnection(SQLException queryException) throws SQLException {
        if (this.secondaryProtocol == null || !this.secondaryProtocol.isConnected()) {
            this.setSecondaryHostFail();
        } else {
            this.resetSecondaryFailoverData();
        }
        if (this.masterProtocol == null || !this.masterProtocol.isConnected()) {
            this.setMasterHostFail();
            if (!this.urlParser.getOptions().allowMasterDownConnection || this.secondaryProtocol == null) {
                this.throwFailoverMessage(this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null, true, queryException, false);
            }
        } else {
            this.resetMasterFailoverData();
            if (this.isSecondaryHostFail()) {
                this.handleFailLoop();
            }
        }
    }

    @Override
    public void preClose() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                this.closeConnection(this.waitNewSecondaryProtocol.getAndSet(null));
                this.closeConnection(this.waitNewMasterProtocol.getAndSet(null));
                this.closeConnection(this.masterProtocol);
                this.closeConnection(this.secondaryProtocol);
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void preExecute() throws SQLException {
        this.lastQueryNanos = System.nanoTime();
        this.checkWaitingConnection();
        if (this.currentProtocol != null && (this.currentProtocol.isClosed() || !this.currentReadOnlyAsked && !this.currentProtocol.isMasterConnection())) {
            this.preAutoReconnect();
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.currentProtocol != null) {
            if (this.currentProtocol.isMasterConnection()) {
                boolean valid = this.currentProtocol.isValid(timeout);
                if (this.secondaryProtocol != null) {
                    try {
                        this.secondaryProtocol.isValid(timeout);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return valid;
            }
            boolean valid = this.currentProtocol.isValid(timeout);
            if (this.masterProtocol != null) {
                try {
                    this.masterProtocol.isValid(timeout);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return valid;
        }
        return false;
    }

    public void checkWaitingConnection() throws SQLException {
        Protocol waitingProtocol;
        if (this.isSecondaryHostFail()) {
            this.proxy.lock.lock();
            try {
                waitingProtocol = this.waitNewSecondaryProtocol.getAndSet(null);
                if (waitingProtocol != null && this.pingSecondaryProtocol(waitingProtocol)) {
                    this.lockAndSwitchSecondary(waitingProtocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
        if (this.isMasterHostFail()) {
            this.proxy.lock.lock();
            try {
                waitingProtocol = this.waitNewMasterProtocol.getAndSet(null);
                if (waitingProtocol != null && this.pingMasterProtocol(waitingProtocol)) {
                    this.lockAndSwitchMaster(waitingProtocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws SQLException {
        if (!searchFilter.isInitialConnection() && (this.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail())) {
            return;
        }
        if (!searchFilter.isFailoverLoop()) {
            try {
                this.checkWaitingConnection();
                if (searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail()) {
                    return;
                }
            }
            catch (ReconnectDuringTransactionException e) {
                return;
            }
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
        loopAddress.removeAll(this.getBlacklistKeys());
        Collections.shuffle(loopAddress);
        LinkedList<HostAddress> blacklistShuffle = new LinkedList<HostAddress>(this.getBlacklistKeys());
        blacklistShuffle.retainAll(this.urlParser.getHostAddresses());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
            loopAddress.add(this.masterProtocol.getHostAddress());
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            loopAddress.remove(this.secondaryProtocol.getHostAddress());
            loopAddress.add(this.secondaryProtocol.getHostAddress());
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            do {
                MastersSlavesProtocol.loop(this, this.globalInfo, loopAddress, searchFilter);
                if (searchFilter.isFailoverLoop()) continue;
                try {
                    this.checkWaitingConnection();
                }
                catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {
                    // empty catch block
                }
            } while (searchFilter.isInitialConnection() && this.masterProtocol == null && (!this.urlParser.getOptions().allowMasterDownConnection || this.secondaryProtocol == null));
            if (searchFilter.isInitialConnection() && this.masterProtocol == null && !this.currentReadOnlyAsked) {
                this.currentProtocol = this.secondaryProtocol;
                this.currentReadOnlyAsked = true;
            }
        }
    }

    @Override
    public void foundActiveMaster(Protocol newMasterProtocol) {
        if (this.isMasterHostFail()) {
            if (this.isExplicitClosed()) {
                newMasterProtocol.close();
                return;
            }
            if (!this.waitNewMasterProtocol.compareAndSet(null, newMasterProtocol)) {
                newMasterProtocol.close();
            }
        } else {
            newMasterProtocol.close();
        }
    }

    public void lockAndSwitchMaster(Protocol newMasterProtocol) throws ReconnectDuringTransactionException {
        if (this.masterProtocol != null && !this.masterProtocol.isClosed()) {
            this.masterProtocol.close();
        }
        if (!this.currentReadOnlyAsked || this.isSecondaryHostFail()) {
            try {
                this.syncConnection(this.currentProtocol, newMasterProtocol);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentProtocol = newMasterProtocol;
        }
        boolean inTransaction = this.masterProtocol != null && this.masterProtocol.inTransaction();
        this.masterProtocol = newMasterProtocol;
        this.resetMasterFailoverData();
        if (inTransaction) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    @Override
    public void foundActiveSecondary(Protocol newSecondaryProtocol) throws SQLException {
        if (this.isSecondaryHostFail()) {
            if (this.isExplicitClosed()) {
                newSecondaryProtocol.close();
                return;
            }
            if (this.proxy.lock.tryLock()) {
                try {
                    this.lockAndSwitchSecondary(newSecondaryProtocol);
                }
                finally {
                    this.proxy.lock.unlock();
                }
            } else if (!this.waitNewSecondaryProtocol.compareAndSet(null, newSecondaryProtocol)) {
                newSecondaryProtocol.close();
            }
        } else {
            newSecondaryProtocol.close();
        }
    }

    public void lockAndSwitchSecondary(Protocol newSecondaryProtocol) throws SQLException {
        if (this.secondaryProtocol != null && !this.secondaryProtocol.isClosed()) {
            this.secondaryProtocol.close();
        }
        if (this.currentReadOnlyAsked || this.urlParser.getOptions().failOnReadOnly && !this.currentReadOnlyAsked && this.isMasterHostFail()) {
            try {
                this.syncConnection(this.currentProtocol, newSecondaryProtocol);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentProtocol = newSecondaryProtocol;
        }
        this.secondaryProtocol = newSecondaryProtocol;
        if (this.urlParser.getOptions().assureReadOnly) {
            this.setSessionReadOnly(true, this.secondaryProtocol);
        }
        this.resetSecondaryFailoverData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws SQLException {
        block23: {
            block24: {
                this.checkWaitingConnection();
                if (this.currentReadOnlyAsked == mustBeReadOnly) break block23;
                this.proxy.lock.lock();
                if (this.currentReadOnlyAsked == mustBeReadOnly) {
                    return;
                }
                this.currentReadOnlyAsked = mustBeReadOnly;
                if (!this.currentReadOnlyAsked) break block24;
                if (!this.currentProtocol.isMasterConnection()) break block23;
                if (this.isSecondaryHostFail()) ** GOTO lbl-1000
                this.proxy.lock.lock();
                try {
                    this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                    this.currentProtocol = this.secondaryProtocol;
                    return;
                }
                catch (SQLException e) {
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                }
                finally {
                    this.proxy.lock.unlock();
                }
lbl-1000:
                // 2 sources

                {
                    FailoverLoop.addListener(this);
                    break block23;
                }
            }
            if (this.currentProtocol.isMasterConnection()) break block23;
            if (this.isMasterHostFail()) ** GOTO lbl37
            try {
                this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                this.currentProtocol = this.masterProtocol;
                return;
            }
            catch (SQLException e) {
                if (this.setMasterHostFail()) {
                    this.addToBlacklist(this.masterProtocol.getHostAddress());
                }
lbl37:
                // 4 sources

                try {
                    this.reconnectFailedConnection(new SearchFilter(true, false));
                    this.handleFailLoop();
                }
                catch (SQLException e) {
                    FailoverLoop.removeListener(this);
                    failHost = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
                    this.throwFailoverMessage(failHost, true, new SQLException("master connection failed"), false);
                }
                if (!this.isMasterHostFail()) {
                    try {
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                    }
                    catch (SQLException e) {
                        if (this.setMasterHostFail()) {
                            this.addToBlacklist(this.masterProtocol.getHostAddress());
                        }
                    }
                } else {
                    this.currentReadOnlyAsked = mustBeReadOnly == false;
                    failHost = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
                    this.throwFailoverMessage(failHost, true, new SQLException("master connection failed"), false);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args, boolean killCmd) throws Throwable {
        boolean inTransaction;
        boolean alreadyClosed;
        block14: {
            alreadyClosed = !this.masterProtocol.isConnected();
            boolean bl = inTransaction = this.masterProtocol != null && this.masterProtocol.inTransaction();
            if (this.masterProtocol.isConnected()) {
                this.masterProtocol.close();
            }
            if (this.urlParser.getOptions().failOnReadOnly && !this.isSecondaryHostFail()) {
                try {
                    if (this.secondaryProtocol == null || !this.secondaryProtocol.ping()) break block14;
                    this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                    this.proxy.lock.lock();
                    try {
                        this.currentProtocol = this.secondaryProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    FailoverLoop.addListener(this);
                    try {
                        return this.relaunchOperation(method, args);
                    }
                    catch (Exception exception) {
                        return new HandleErrorResult();
                    }
                }
                catch (Exception e) {
                    if (!this.setSecondaryHostFail()) break block14;
                    this.blackListAndCloseConnection(this.secondaryProtocol);
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly));
            this.handleFailLoop();
            if (killCmd) {
                return new HandleErrorResult(true, false);
            }
            if (this.currentReadOnlyAsked || alreadyClosed || !inTransaction && this.isQueryRelaunchable(method, args)) {
                logger.info("Connection to master lost, new master {}, conn={} found, query type permit to be re-execute on new server without throwing exception", (Object)this.currentProtocol.getHostAddress(), (Object)this.currentProtocol.getServerThreadId());
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            if (e.getCause() != null && this.proxy.hasToHandleFailover((SQLException)e.getCause()) && this.currentProtocol.isConnected()) {
                this.currentProtocol.close();
            }
            this.setMasterHostFail();
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    private void blackListAndCloseConnection(Protocol protocol) {
        this.addToBlacklist(protocol.getHostAddress());
        if (protocol.isConnected()) {
            this.proxy.lock.lock();
            try {
                protocol.close();
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void reconnect() throws SQLException {
        SearchFilter filter;
        boolean inTransaction = false;
        if (this.currentReadOnlyAsked) {
            filter = new SearchFilter(true, true);
        } else {
            inTransaction = this.masterProtocol != null && this.masterProtocol.inTransaction();
            filter = new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly);
        }
        this.reconnectFailedConnection(filter);
        this.handleFailLoop();
        if (inTransaction) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    private boolean pingSecondaryProtocol(Protocol protocol) {
        block3: {
            try {
                if (protocol != null && protocol.isConnected() && protocol.ping()) {
                    return true;
                }
            }
            catch (Exception e) {
                protocol.close();
                if (!this.setSecondaryHostFail()) break block3;
                this.addToBlacklist(protocol.getHostAddress());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult secondaryFail(Method method, Object[] args, boolean killCmd) throws Throwable {
        block18: {
            this.proxy.lock.lock();
            try {
                if (this.pingSecondaryProtocol(this.secondaryProtocol)) {
                    HandleErrorResult handleErrorResult = this.relaunchOperation(method, args);
                    return handleErrorResult;
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
            if (!this.isMasterHostFail()) {
                try {
                    if (this.masterProtocol == null || !this.masterProtocol.isValid(1000)) break block18;
                    this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                    this.proxy.lock.lock();
                    try {
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    FailoverLoop.addListener(this);
                    logger.info("Connection to slave lost, using master connection, query is re-execute on master server without throwing exception");
                    return this.relaunchOperation(method, args);
                }
                catch (Exception e) {
                    if (!this.setMasterHostFail()) break block18;
                    this.blackListAndCloseConnection(this.masterProtocol);
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true));
            this.handleFailLoop();
            if (this.isSecondaryHostFail()) {
                this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                this.proxy.lock.lock();
                try {
                    this.currentProtocol = this.masterProtocol;
                }
                finally {
                    this.proxy.lock.unlock();
                }
            }
            if (killCmd) {
                return new HandleErrorResult(true, false);
            }
            logger.info("Connection to slave lost, new slave {}, conn={} found, query is re-execute on new server without throwing exception", (Object)this.currentProtocol.getHostAddress(), (Object)this.currentProtocol.getServerThreadId());
            return this.relaunchOperation(method, args);
        }
        catch (Exception ee) {
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    @Override
    public void handleFailLoop() {
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            if (!this.isExplicitClosed()) {
                FailoverLoop.addListener(this);
            }
        } else {
            FailoverLoop.removeListener(this);
        }
    }

    @Override
    public boolean isMasterConnected() {
        return this.masterProtocol != null && this.masterProtocol.isConnected();
    }

    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (this.masterProtocol != null) {
            this.pingMasterProtocol(this.masterProtocol);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rePrepareOnSlave(ServerPrepareResult oldServerPrepareResult, boolean mustBeOnMaster) throws SQLException {
        Protocol waitingProtocol;
        if (this.isSecondaryHostFail() && (waitingProtocol = (Protocol)this.waitNewSecondaryProtocol.getAndSet(null)) != null) {
            this.proxy.lock.lock();
            try {
                if (this.pingSecondaryProtocol(waitingProtocol)) {
                    this.lockAndSwitchSecondary(waitingProtocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            ServerPrepareResult serverPrepareResult = this.secondaryProtocol.prepare(oldServerPrepareResult.getSql(), mustBeOnMaster);
            try {
                serverPrepareResult.getUnProxiedProtocol().releasePrepareStatement(serverPrepareResult);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            oldServerPrepareResult.failover(serverPrepareResult.getStatementId(), this.secondaryProtocol);
        }
    }

    public List<HostAddress> connectedHosts() {
        ArrayList<HostAddress> usedHost = new ArrayList<HostAddress>();
        if (this.isMasterHostFail()) {
            Protocol masterProtocol = (Protocol)this.waitNewMasterProtocol.get();
            if (masterProtocol != null) {
                usedHost.add(masterProtocol.getHostAddress());
            }
        } else {
            usedHost.add(this.masterProtocol.getHostAddress());
        }
        if (this.isSecondaryHostFail()) {
            Protocol secondProtocol = (Protocol)this.waitNewSecondaryProtocol.get();
            if (secondProtocol != null) {
                usedHost.add(secondProtocol.getHostAddress());
            }
        } else {
            usedHost.add(this.secondaryProtocol.getHostAddress());
        }
        return usedHost;
    }

    @Override
    public void reset() throws SQLException {
        if (!this.isMasterHostFail()) {
            this.masterProtocol.reset();
        }
        if (!this.isSecondaryHostFail()) {
            this.secondaryProtocol.reset();
        }
    }

    static {
        listenerCount = new AtomicInteger();
        logger = LoggerFactory.getLogger(MastersSlavesListener.class);
        dynamicSizedScheduler = SchedulerServiceProviderHolder.getScheduler(1, "MariaDb-failover", 8);
        dynamicSizedScheduler.scheduleWithFixedDelay(new Runnable(){
            private final ArrayDeque<FailoverLoop> failoverLoops = new ArrayDeque(8);

            @Override
            public void run() {
                block5: {
                    int desiredFailCount = Math.min(8, listenerCount.get() / 5 + 1);
                    int countChange = desiredFailCount - this.failoverLoops.size();
                    if (countChange == 0) break block5;
                    dynamicSizedScheduler.setPoolSize(desiredFailCount);
                    if (countChange > 0) {
                        while (countChange > 0) {
                            this.failoverLoops.add(new FailoverLoop(dynamicSizedScheduler));
                            --countChange;
                        }
                    } else {
                        ArrayList<FailoverLoop> removedLoops = new ArrayList<FailoverLoop>(-countChange);
                        while (countChange < 0) {
                            FailoverLoop failoverLoop = this.failoverLoops.remove();
                            failoverLoop.unscheduleTask();
                            removedLoops.add(failoverLoop);
                            ++countChange;
                        }
                        for (FailoverLoop failoverLoop : removedLoops) {
                            failoverLoop.blockTillTerminated();
                        }
                    }
                }
            }
        }, 1L, 2L, TimeUnit.MINUTES);
    }
}

