/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import org.jetbrains.annotations.NotNull;

public class CharArrayCharSequence
implements CharSequenceWithStringHash,
CharSequenceBackedByArray {
    protected final char[] myChars;
    protected final int myStart;
    protected final int myEnd;
    private transient int hash;

    public CharArrayCharSequence(char ... chars) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(@NotNull char[] chars, int start, int end) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(1);
        }
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index2) {
        return this.myChars[index2 + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        CharArrayCharSequence charArrayCharSequence = start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
        if (charArrayCharSequence == null) {
            CharArrayCharSequence.$$$reportNull$$$0(2);
        }
        return charArrayCharSequence;
    }

    @Override
    @NotNull
    public String toString() {
        String string = new String(this.myChars, this.myStart, this.myEnd - this.myStart);
        if (string == null) {
            CharArrayCharSequence.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public char[] getChars() {
        if (this.myStart == 0) {
            if (this.myChars == null) {
                CharArrayCharSequence.$$$reportNull$$$0(4);
            }
            return this.myChars;
        }
        char[] chars = new char[this.length()];
        this.getChars(chars, 0);
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(5);
        }
        return chars;
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        if (dst == null) {
            CharArrayCharSequence.$$$reportNull$$$0(6);
        }
        System.arraycopy(this.myChars, this.myStart, dst, dstOffset, this.length());
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass() || this.length() != ((CharSequence)anObject).length()) {
            return false;
        }
        return CharArrayUtil.regionMatches(this.myChars, this.myStart, this.myEnd, (CharSequence)anObject);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/CharArrayCharSequence";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/CharArrayCharSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

