/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class JBColor
extends Color {
    public static final Color PanelBackground = JBColor.namedColor("Panel.background", 0xFFFFFF);
    private final Color darkColor;
    private final NotNullProducer<? extends Color> func;
    public static final JBColor red;
    public static final JBColor RED;
    public static final JBColor blue;
    public static final JBColor BLUE;
    public static final JBColor white;
    public static final JBColor WHITE;
    public static final JBColor black;
    public static final JBColor BLACK;
    public static final JBColor gray;
    public static final JBColor GRAY;
    public static final JBColor lightGray;
    public static final JBColor LIGHT_GRAY;
    public static final JBColor darkGray;
    public static final JBColor DARK_GRAY;
    public static final JBColor pink;
    public static final JBColor PINK;
    public static final JBColor orange;
    public static final JBColor ORANGE;
    public static final JBColor yellow;
    public static final JBColor YELLOW;
    public static final JBColor green;
    public static final JBColor GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    private static final Map<String, Color> defaultThemeColors;

    public JBColor(int rgb, int darkRGB) {
        this(new Color(rgb), new Color(darkRGB));
    }

    public JBColor(@NotNull Color regular, @NotNull Color dark) {
        if (regular == null) {
            JBColor.$$$reportNull$$$0(0);
        }
        if (dark == null) {
            JBColor.$$$reportNull$$$0(1);
        }
        super(regular.getRGB(), regular.getAlpha() != 255);
        this.darkColor = dark;
        this.func = null;
    }

    public JBColor(@NotNull NotNullProducer<? extends Color> function2) {
        if (function2 == null) {
            JBColor.$$$reportNull$$$0(2);
        }
        super(0);
        this.darkColor = null;
        this.func = function2;
    }

    @NotNull
    public static JBColor namedColor(@NotNull String propertyName, int defaultValueRGB) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(3);
        }
        JBColor jBColor = JBColor.namedColor(propertyName, new Color(defaultValueRGB));
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(4);
        }
        return jBColor;
    }

    @NotNull
    public static JBColor namedColor(@NotNull String propertyName, @NotNull Color defaultColor) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(5);
        }
        if (defaultColor == null) {
            JBColor.$$$reportNull$$$0(6);
        }
        JBColor jBColor = new JBColor(() -> {
            Color color = ObjectUtils.notNull(UIManager.getColor(propertyName), ObjectUtils.notNull(JBColor.findPatternMatch(propertyName), defaultColor));
            if (UIManager.get(propertyName) == null) {
                UIManager.put(propertyName, color);
            }
            return color;
        });
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(7);
        }
        return jBColor;
    }

    private static Color findPatternMatch(@NotNull String name) {
        Object value;
        if (name == null) {
            JBColor.$$$reportNull$$$0(8);
        }
        if ((value = UIManager.get("*")) instanceof Map) {
            Map cache2;
            Map map2 = (Map)value;
            HashMap o = UIManager.get("*cache");
            if (!(o instanceof Map)) {
                o = new HashMap();
                UIManager.put("*cache", o);
            }
            if ((cache2 = (Map)o).containsKey(name)) {
                return (Color)cache2.get(name);
            }
            Color color = null;
            for (Map.Entry entry : map2.entrySet()) {
                Object result2;
                if (!(entry.getKey() instanceof String) || !name.endsWith((String)entry.getKey()) || !((result2 = map2.get(entry.getKey())) instanceof Color)) continue;
                color = (Color)result2;
                break;
            }
            cache2.put(name, color);
            return color;
        }
        return null;
    }

    private Color getDarkVariant() {
        return this.darkColor;
    }

    @NotNull
    Color getColor() {
        Color color = this.func != null ? this.func.produce() : (Lazy.DARK ? this.getDarkVariant() : this);
        if (color == null) {
            JBColor.$$$reportNull$$$0(13);
        }
        return color;
    }

    @Override
    public int getRed() {
        Color c = this.getColor();
        return c == this ? super.getRed() : c.getRed();
    }

    @Override
    public int getGreen() {
        Color c = this.getColor();
        return c == this ? super.getGreen() : c.getGreen();
    }

    @Override
    public int getBlue() {
        Color c = this.getColor();
        return c == this ? super.getBlue() : c.getBlue();
    }

    @Override
    public int getAlpha() {
        Color c = this.getColor();
        return c == this ? super.getAlpha() : c.getAlpha();
    }

    @Override
    public int getRGB() {
        Color c = this.getColor();
        return c == this ? super.getRGB() : c.getRGB();
    }

    @Override
    @NotNull
    public Color brighter() {
        if (this.func != null) {
            JBColor jBColor = new JBColor(() -> this.func.produce().brighter());
            if (jBColor == null) {
                JBColor.$$$reportNull$$$0(14);
            }
            return jBColor;
        }
        JBColor jBColor = new JBColor(super.brighter(), this.getDarkVariant().brighter());
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(15);
        }
        return jBColor;
    }

    @Override
    @NotNull
    public Color darker() {
        if (this.func != null) {
            JBColor jBColor = new JBColor(() -> this.func.produce().darker());
            if (jBColor == null) {
                JBColor.$$$reportNull$$$0(16);
            }
            return jBColor;
        }
        JBColor jBColor = new JBColor(super.darker(), this.getDarkVariant().darker());
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(17);
        }
        return jBColor;
    }

    @Override
    public int hashCode() {
        Color c = this.getColor();
        return c == this ? super.hashCode() : c.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        Color c = this.getColor();
        return c == this ? super.equals(obj) : c.equals(obj);
    }

    @Override
    public String toString() {
        Color c = this.getColor();
        return c == this ? super.toString() : c.toString();
    }

    @Override
    @NotNull
    public float[] getRGBComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getRGBComponents(compArray) : c.getRGBComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(18);
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getRGBColorComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getRGBComponents(compArray) : c.getRGBColorComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(19);
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getComponents(compArray) : c.getComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(20);
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getColorComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getColorComponents(compArray) : c.getColorComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(21);
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getComponents(@NotNull ColorSpace cspace, float[] compArray) {
        Color c;
        if (cspace == null) {
            JBColor.$$$reportNull$$$0(22);
        }
        float[] fArray = (c = this.getColor()) == this ? super.getComponents(cspace, compArray) : c.getComponents(cspace, compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(23);
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getColorComponents(@NotNull ColorSpace cspace, float[] compArray) {
        Color c;
        if (cspace == null) {
            JBColor.$$$reportNull$$$0(24);
        }
        float[] fArray = (c = this.getColor()) == this ? super.getColorComponents(cspace, compArray) : c.getColorComponents(cspace, compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(25);
        }
        return fArray;
    }

    @Override
    @NotNull
    public ColorSpace getColorSpace() {
        Color c = this.getColor();
        ColorSpace colorSpace = c == this ? super.getColorSpace() : c.getColorSpace();
        if (colorSpace == null) {
            JBColor.$$$reportNull$$$0(26);
        }
        return colorSpace;
    }

    @Override
    @NotNull
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        Color c = this.getColor();
        PaintContext paintContext = c == this ? super.createContext(cm, r, r2d, xform, hints) : c.createContext(cm, r, r2d, xform, hints);
        if (paintContext == null) {
            JBColor.$$$reportNull$$$0(27);
        }
        return paintContext;
    }

    @Override
    public int getTransparency() {
        Color c = this.getColor();
        return c == this ? super.getTransparency() : c.getTransparency();
    }

    @NotNull
    public static Color foreground() {
        JBColor jBColor = new JBColor(UIUtil::getLabelForeground);
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(28);
        }
        return jBColor;
    }

    @NotNull
    public static Color background() {
        JBColor jBColor = new JBColor(UIUtil::getListBackground);
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(29);
        }
        return jBColor;
    }

    static {
        RED = red = new JBColor(Color.red, DarculaColors.RED);
        BLUE = blue = new JBColor(Color.blue, DarculaColors.BLUE);
        WHITE = white = new JBColor(Color.white, JBColor.background());
        BLACK = black = new JBColor(Color.black, JBColor.foreground());
        GRAY = gray = new JBColor(Gray._128, Gray._128);
        LIGHT_GRAY = lightGray = new JBColor(Gray._192, Gray._64);
        DARK_GRAY = darkGray = new JBColor(Gray._64, Gray._192);
        PINK = pink = new JBColor(Color.pink, Color.pink);
        ORANGE = orange = new JBColor(Color.orange, new Color(159, 107, 0));
        YELLOW = yellow = new JBColor(Color.yellow, new Color(138, 138, 0));
        GREEN = green = new JBColor(Color.green, new Color(98, 150, 85));
        MAGENTA = magenta = new JBColor(Color.magenta, new Color(151, 118, 169));
        CYAN = cyan = new JBColor(Color.cyan, new Color(0, 137, 137));
        defaultThemeColors = new com.intellij.util.containers.hash.HashMap<String, Color>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regular";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dark";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/JBColor";
                break;
            }
            case 6: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultColor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cspace";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/JBColor";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "namedColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "link";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "linkHover";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "linkPressed";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "linkVisited";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "brighter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "darker";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRGBComponents";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRGBColorComponents";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 21: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorComponents";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorSpace";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "foreground";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "background";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "border";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "namedColor";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPatternMatch";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getColorComponents";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Lazy {
        private static volatile boolean DARK = UIUtil.isUnderDarcula();
    }
}

