import { none, option } from './Option';
import { sequence } from './Traversable';
export function replicate(U) {
    return (a, n) => {
        function step(n) {
            return n <= 0 ? none : option.of([a, n - 1]);
        }
        return U.unfoldr(n, step);
    };
}
export function empty(U) {
    return U.unfoldr(undefined, () => none);
}
export function singleton(U) {
    const replicateU = replicate(U);
    return a => replicateU(a, 1);
}
export function replicateA(F, 
// tslint:disable-next-line: deprecation
UT) {
    const sequenceFUT = sequence(F, UT);
    const replicateUT = replicate(UT);
    return (n, ma) => sequenceFUT(replicateUT(ma, n));
}
