"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var mobx_react_1 = require("mobx-react");
var reactive_chart_1 = require("./reactive_chart");
var ChartContainerComponent = /** @class */ (function (_super) {
    __extends(ChartContainerComponent, _super);
    function ChartContainerComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChartContainerComponent.prototype.render = function () {
        var _this = this;
        var chartInitialized = this.props.chartStore.chartInitialized;
        if (!chartInitialized.get()) {
            return null;
        }
        var _a = this.props.chartStore, setCursorPosition = _a.setCursorPosition, isChartEmpty = _a.isChartEmpty;
        return (react_1.default.createElement("div", { className: "echChartCursorContainer", style: {
                cursor: this.props.chartStore.chartCursor.get(),
            }, onMouseMove: function (_a) {
                var _b = _a.nativeEvent, offsetX = _b.offsetX, offsetY = _b.offsetY;
                if (!isChartEmpty.get()) {
                    setCursorPosition(offsetX, offsetY);
                }
            }, onMouseLeave: function () {
                setCursorPosition(-1, -1);
            }, onMouseUp: function () {
                if (_this.props.chartStore.isBrushing.get()) {
                    return;
                }
                _this.props.chartStore.handleChartClick();
            } },
            react_1.default.createElement(reactive_chart_1.ReactiveChart, null)));
    };
    ChartContainerComponent.displayName = 'ChartContainer';
    return ChartContainerComponent;
}(react_1.default.Component));
exports.ChartContainer = mobx_react_1.inject('chartStore')(mobx_react_1.observer(ChartContainerComponent));
//# sourceMappingURL=chart_container.js.map