"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importStar(require("react"));
var axis_utils_1 = require("../../chart_types/xy_chart/utils/axis_utils");
var legend_item_1 = require("./legend_item");
var LegendComponent = /** @class */ (function (_super) {
    __extends(LegendComponent, _super);
    function LegendComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            width: undefined,
        };
        _this.echLegend = react_1.createRef();
        _this.getLegendListStyle = function (position, _a) {
            var chartMargins = _a.chartMargins, legend = _a.legend;
            var paddingTop = chartMargins.top, paddingBottom = chartMargins.bottom, paddingLeft = chartMargins.left, paddingRight = chartMargins.right;
            if (axis_utils_1.isHorizontalAxis(position)) {
                return {
                    paddingLeft: paddingLeft,
                    paddingRight: paddingRight,
                    gridTemplateColumns: "repeat(auto-fill, minmax(" + legend.verticalWidth + "px, 1fr))",
                };
            }
            return {
                paddingTop: paddingTop,
                paddingBottom: paddingBottom,
            };
        };
        _this.getLegendStyle = function (position, _a) {
            var legend = _a.legend;
            if (axis_utils_1.isVerticalAxis(position)) {
                if (_this.state.width !== undefined) {
                    var threshold = Math.min(_this.state.width, legend.verticalWidth);
                    var width = threshold + "px";
                    return {
                        width: width,
                        maxWidth: width,
                    };
                }
                return {
                    maxWidth: legend.verticalWidth + "px",
                };
            }
            return {
                maxHeight: legend.horizontalHeight + "px",
            };
        };
        _this.onLegendItemMouseover = function (legendItemKey) { return function () {
            _this.props.chartStore.onLegendItemOver(legendItemKey);
        }; };
        _this.onLegendItemMouseout = function () {
            _this.props.chartStore.onLegendItemOut();
        };
        _this.renderLegendElement = function (item) {
            var key = item.key, displayValue = item.displayValue;
            var _a = _this.props.chartStore, legendPosition = _a.legendPosition, legendItemTooltipValues = _a.legendItemTooltipValues, isCursorOnChart = _a.isCursorOnChart;
            var tooltipValues = legendItemTooltipValues.get();
            var tooltipValue;
            if (tooltipValues && tooltipValues.get(key)) {
                tooltipValue = tooltipValues.get(key);
            }
            var newDisplayValue = tooltipValue != null ? tooltipValue : '';
            return (react_1.default.createElement(legend_item_1.LegendItem, __assign({}, item, { key: key, legendItemKey: key, legendPosition: legendPosition.get(), displayValue: isCursorOnChart.get() ? newDisplayValue : displayValue.formatted, onMouseEnter: _this.onLegendItemMouseover(key), onMouseLeave: _this.onLegendItemMouseout })));
        };
        return _this;
    }
    LegendComponent.prototype.componentDidUpdate = function () {
        var _a = this.props.chartStore, chartInitialized = _a.chartInitialized, chartTheme = _a.chartTheme, legendPosition = _a.legendPosition;
        if (this.echLegend.current &&
            axis_utils_1.isVerticalAxis(legendPosition.get()) &&
            this.state.width === undefined &&
            !chartInitialized.get()) {
            var buffer = chartTheme.legend.spacingBuffer;
            this.setState({
                width: this.echLegend.current.offsetWidth + buffer,
            });
        }
    };
    LegendComponent.prototype.render = function () {
        var _a = this.props.chartStore, legendInitialized = _a.legendInitialized, chartInitialized = _a.chartInitialized, legendItems = _a.legendItems, legendPosition = _a.legendPosition, showLegend = _a.showLegend, debug = _a.debug, chartTheme = _a.chartTheme;
        var position = legendPosition.get();
        if (!showLegend.get() || !legendInitialized.get() || legendItems.size === 0) {
            return null;
        }
        var legendContainerStyle = this.getLegendStyle(position, chartTheme);
        var legendListStyle = this.getLegendListStyle(position, chartTheme);
        var legendClasses = classnames_1.default('echLegend', "echLegend--" + position, {
            'echLegend--debug': debug,
            invisible: !chartInitialized.get(),
        });
        return (react_1.default.createElement("div", { ref: this.echLegend, className: legendClasses },
            react_1.default.createElement("div", { style: legendContainerStyle, className: "echLegendListContainer" },
                react_1.default.createElement("div", { style: legendListStyle, className: "echLegendList" }, __spread(legendItems.values()).map(this.renderLegendElement)))));
    };
    LegendComponent.displayName = 'Legend';
    return LegendComponent;
}(react_1.default.Component));
exports.Legend = mobx_react_1.inject('chartStore')(mobx_react_1.observer(LegendComponent));
//# sourceMappingURL=legend.js.map