"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Map each y value from a RawDataSeries on it's specific x value into,
 * ordering the stack based on the dataseries index.
 * @param dataseries
 */
function getYValueStackMap(dataseries) {
    var stackMap = new Map();
    dataseries.forEach(function (ds, index) {
        ds.data.forEach(function (datum) {
            var stack = stackMap.get(datum.x) || new Array(dataseries.length).fill(0);
            stack[index] = datum.y1;
            stackMap.set(datum.x, stack);
        });
    });
    return stackMap;
}
exports.getYValueStackMap = getYValueStackMap;
/**
 * For each key of the yValueStackMap, it stacks the values one after the other,
 * summing the previous value to the next one.
 * @param yValueStackMap
 * @param scaleToExtent
 */
function computeYStackedMapValues(yValueStackMap, scaleToExtent) {
    var stackedValues = new Map();
    yValueStackMap.forEach(function (yStackArray, xValue) {
        var stackArray = yStackArray.reduce(function (acc, currentValue, index) {
            if (acc.values.length === 0) {
                if (scaleToExtent) {
                    return {
                        values: [currentValue, currentValue],
                        total: currentValue,
                    };
                }
                return {
                    values: [0, currentValue],
                    total: currentValue,
                };
            }
            return {
                values: __spread(acc.values, [acc.values[index] + currentValue]),
                total: acc.total + currentValue,
            };
        }, {
            values: [],
            total: 0,
        });
        var percent = stackArray.values.map(function (value) {
            return value / stackArray.total;
        });
        stackedValues.set(xValue, {
            values: stackArray.values,
            percent: percent,
            total: stackArray.total,
        });
    });
    return stackedValues;
}
exports.computeYStackedMapValues = computeYStackedMapValues;
function formatStackedDataSeriesValues(dataseries, scaleToExtent, isPercentageMode) {
    if (isPercentageMode === void 0) { isPercentageMode = false; }
    var yValueStackMap = getYValueStackMap(dataseries);
    var stackedValues = computeYStackedMapValues(yValueStackMap, scaleToExtent);
    var stackedDataSeries = dataseries.map(function (ds, seriesIndex) {
        var newData = [];
        ds.data.forEach(function (data) {
            var x = data.x, datum = data.datum;
            var stack = stackedValues.get(x);
            if (!stack) {
                return;
            }
            var y1 = null;
            if (isPercentageMode) {
                y1 = data.y1 != null ? data.y1 / stack.total : null;
            }
            else {
                y1 = data.y1;
            }
            var y0 = isPercentageMode && data.y0 != null ? data.y0 / stack.total : data.y0;
            var computedY0;
            if (scaleToExtent) {
                computedY0 = y0 ? y0 : y1;
            }
            else {
                computedY0 = y0 ? y0 : 0;
            }
            var initialY0 = y0 == null ? null : y0;
            if (seriesIndex === 0) {
                newData.push({
                    x: x,
                    y1: y1,
                    y0: computedY0,
                    initialY1: y1,
                    initialY0: initialY0,
                    datum: datum,
                });
            }
            else {
                var stackY = isPercentageMode ? stack.percent[seriesIndex] : stack.values[seriesIndex];
                var stackedY1 = null;
                var stackedY0 = null;
                if (isPercentageMode) {
                    stackedY1 = y1 !== null ? stackY + y1 : null;
                    stackedY0 = y0 != null ? stackY + y0 : stackY;
                }
                else {
                    stackedY1 = y1 !== null ? stackY + y1 : null;
                    stackedY0 = y0 != null ? stackY + y0 : stackY;
                    // configure null y0 if y1 is null
                    // it's semantically right to say y0 is null if y1 is null
                    if (stackedY1 === null) {
                        stackedY0 = null;
                    }
                }
                newData.push({
                    x: x,
                    y1: stackedY1,
                    y0: stackedY0,
                    initialY1: y1,
                    initialY0: initialY0,
                    datum: datum,
                });
            }
        });
        return {
            specId: ds.specId,
            key: ds.key,
            seriesColorKey: ds.seriesColorKey,
            data: newData,
        };
    });
    return stackedDataSeries;
}
exports.formatStackedDataSeriesValues = formatStackedDataSeriesValues;
//# sourceMappingURL=stacked_series_utils.js.map