"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function isEqualSeriesKey(a, b) {
    if (a.length !== b.length) {
        return false;
    }
    for (var i = 0, l = a.length; i < l; i++) {
        if (a[i] !== b[i]) {
            return false;
        }
    }
    return true;
}
exports.isEqualSeriesKey = isEqualSeriesKey;
function belongsToDataSeries(geometryValue, dataSeriesValues) {
    var legendItemSeriesKey = dataSeriesValues.colorValues;
    var legendItemSpecId = dataSeriesValues.specId;
    var geometrySeriesKey = geometryValue.seriesKey;
    var geometrySpecId = geometryValue.specId;
    var hasSameSpecId = legendItemSpecId === geometrySpecId;
    var hasSameSeriesKey = isEqualSeriesKey(legendItemSeriesKey, geometrySeriesKey);
    return hasSameSpecId && hasSameSeriesKey;
}
exports.belongsToDataSeries = belongsToDataSeries;
//# sourceMappingURL=series_utils.js.map