/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability;

import com.openshift.internal.restclient.api.capabilities.PodExec;
import com.openshift.internal.restclient.api.capabilities.ScaleCapability;
import com.openshift.internal.restclient.apis.TypeMetaFactory;
import com.openshift.internal.restclient.capability.resources.BinaryBuildTrigger;
import com.openshift.internal.restclient.capability.resources.BuildCanceller;
import com.openshift.internal.restclient.capability.resources.BuildTrigger;
import com.openshift.internal.restclient.capability.resources.ClientCapability;
import com.openshift.internal.restclient.capability.resources.DeployCapability;
import com.openshift.internal.restclient.capability.resources.DeploymentConfigTraceability;
import com.openshift.internal.restclient.capability.resources.DeploymentTraceability;
import com.openshift.internal.restclient.capability.resources.DeploymentTrigger;
import com.openshift.internal.restclient.capability.resources.ImageStreamImportCapability;
import com.openshift.internal.restclient.capability.resources.OpenShiftBinaryPodLogRetrieval;
import com.openshift.internal.restclient.capability.resources.OpenShiftBinaryPortForwarding;
import com.openshift.internal.restclient.capability.resources.OpenShiftBinaryRSync;
import com.openshift.internal.restclient.capability.resources.PodLogRetrievalAsync;
import com.openshift.internal.restclient.capability.resources.ProjectTemplateListCapability;
import com.openshift.internal.restclient.capability.resources.ProjectTemplateProcessing;
import com.openshift.internal.restclient.capability.resources.PropertyAccessCapability;
import com.openshift.internal.restclient.capability.resources.TagCapability;
import com.openshift.internal.restclient.capability.resources.TemplateTraceability;
import com.openshift.internal.restclient.capability.resources.UpdateableCapability;
import com.openshift.internal.restclient.capability.server.ServerTemplateProcessing;
import com.openshift.internal.restclient.model.Service;
import com.openshift.internal.restclient.model.build.BuildConfigBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.api.capabilities.IPodExec;
import com.openshift.restclient.api.capabilities.IScalable;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.capability.resources.IBinaryBuildTriggerable;
import com.openshift.restclient.capability.resources.IBuildCancelable;
import com.openshift.restclient.capability.resources.IBuildTriggerable;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.capability.resources.IDeployCapability;
import com.openshift.restclient.capability.resources.IDeploymentConfigTraceability;
import com.openshift.restclient.capability.resources.IDeploymentTraceability;
import com.openshift.restclient.capability.resources.IDeploymentTriggerable;
import com.openshift.restclient.capability.resources.IImageStreamImportCapability;
import com.openshift.restclient.capability.resources.IPodLogRetrieval;
import com.openshift.restclient.capability.resources.IPodLogRetrievalAsync;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.capability.resources.IProjectTemplateList;
import com.openshift.restclient.capability.resources.IProjectTemplateProcessing;
import com.openshift.restclient.capability.resources.IPropertyAccessCapability;
import com.openshift.restclient.capability.resources.IRSyncable;
import com.openshift.restclient.capability.resources.ITags;
import com.openshift.restclient.capability.resources.ITemplateTraceability;
import com.openshift.restclient.capability.resources.IUpdatable;
import com.openshift.restclient.capability.server.ITemplateProcessing;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.build.IBuildConfigBuilder;
import java.util.Map;

public class CapabilityInitializer {
    private static void initializeCapability(Map<Class<? extends ICapability>, ICapability> capabilities, Class<? extends ICapability> capability, ICapability impl) {
        if (impl.isSupported()) {
            capabilities.put(capability, impl);
        }
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IBuild build, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, IBuildTriggerable.class, new BuildTrigger(build, client));
        CapabilityInitializer.initializeCapability(capabilities, IBuildCancelable.class, new BuildCanceller(build, client));
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IBuildConfig buildConfig, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, IBuildTriggerable.class, new BuildTrigger(buildConfig, client));
        CapabilityInitializer.initializeCapability(capabilities, IBinaryBuildTriggerable.class, new BinaryBuildTrigger(buildConfig, client));
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IPod pod, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, IPortForwardable.class, new OpenShiftBinaryPortForwarding(pod, client));
        CapabilityInitializer.initializeCapability(capabilities, IPodLogRetrieval.class, new OpenShiftBinaryPodLogRetrieval(pod, client));
        CapabilityInitializer.initializeCapability(capabilities, IPodLogRetrievalAsync.class, new PodLogRetrievalAsync(pod, client));
        CapabilityInitializer.initializeCapability(capabilities, IPodExec.class, new PodExec(pod, client));
        CapabilityInitializer.initializeCapability(capabilities, IRSyncable.class, new OpenShiftBinaryRSync(client));
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IProject project, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, IProjectTemplateProcessing.class, new ProjectTemplateProcessing(project, client));
        CapabilityInitializer.initializeCapability(capabilities, IProjectTemplateList.class, new ProjectTemplateListCapability(project, client));
        CapabilityInitializer.initializeCapability(capabilities, IImageStreamImportCapability.class, new ImageStreamImportCapability(project, client));
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, Service service, IClient client) {
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IDeploymentConfig config, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, IDeployCapability.class, new DeployCapability(config, client));
        CapabilityInitializer.initializeCapability(capabilities, IDeploymentTriggerable.class, new DeploymentTrigger(config, client, new TypeMetaFactory()));
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IReplicationController rc, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, IScalable.class, new ScaleCapability(rc, client, new TypeMetaFactory()));
    }

    public static void initializeCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IResource resource, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, ITemplateTraceability.class, new TemplateTraceability(resource));
        CapabilityInitializer.initializeCapability(capabilities, IDeploymentConfigTraceability.class, new DeploymentConfigTraceability(resource, client));
        CapabilityInitializer.initializeCapability(capabilities, IDeploymentTraceability.class, new DeploymentTraceability(resource, client));
        CapabilityInitializer.initializeCapability(capabilities, ITags.class, new TagCapability(resource));
        CapabilityInitializer.initializeCapability(capabilities, IClientCapability.class, new ClientCapability(client));
        CapabilityInitializer.initializeCapability(capabilities, IUpdatable.class, new UpdateableCapability(resource));
        CapabilityInitializer.initializeCapability(capabilities, IPropertyAccessCapability.class, new PropertyAccessCapability(resource));
    }

    public static void initializeClientCapabilities(Map<Class<? extends ICapability>, ICapability> capabilities, IClient client) {
        CapabilityInitializer.initializeCapability(capabilities, ITemplateProcessing.class, new ServerTemplateProcessing(client));
        CapabilityInitializer.initializeCapability(capabilities, IBuildConfigBuilder.class, new BuildConfigBuilder(client));
    }
}

