/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;

public class DBusConnection
extends AbstractConnection {
    public static final int SYSTEM = 0;
    public static final int SESSION = 1;
    public static final String DEFAULT_SYSTEM_BUS_ADDRESS = "unix:path=/var/run/dbus/system_bus_socket";
    private List<String> busnames;
    private static final Map<Object, DBusConnection> conn = new HashMap<Object, DBusConnection>();
    private int _refcount = 0;
    private Object _reflock = new Object();
    private DBus _dbus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(String address) throws DBusException {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            DBusConnection c = conn.get(address);
            if (null != c) {
                Object object = c._reflock;
                synchronized (object) {
                    ++c._refcount;
                }
                return c;
            }
            c = new DBusConnection(address);
            conn.put(address, c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(int bustype) throws DBusException {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            DBusConnection c;
            String s = null;
            switch (bustype) {
                case 0: {
                    s = System.getenv("DBUS_SYSTEM_BUS_ADDRESS");
                    if (null != s) break;
                    s = DEFAULT_SYSTEM_BUS_ADDRESS;
                    break;
                }
                case 1: {
                    s = System.getenv("DBUS_SESSION_BUS_ADDRESS");
                    if (null != s) break;
                    String display = System.getenv("DISPLAY");
                    if (null == display) {
                        throw new DBusException(Gettext.getString("cannotResolveSessionBusAddress"));
                    }
                    File uuidfile = new File("/var/lib/dbus/machine-id");
                    if (!uuidfile.exists()) {
                        throw new DBusException(Gettext.getString("cannotResolveSessionBusAddress"));
                    }
                    try {
                        String l;
                        BufferedReader r = new BufferedReader(new FileReader(uuidfile));
                        String uuid = r.readLine();
                        String homedir = System.getProperty("user.home");
                        File addressfile = new File(homedir + "/.dbus/session-bus", uuid + "-" + display.replaceAll(":([0-9]*)\\..*", "$1"));
                        if (!addressfile.exists()) {
                            throw new DBusException(Gettext.getString("cannotResolveSessionBusAddress"));
                        }
                        r = new BufferedReader(new FileReader(addressfile));
                        while (null != (l = r.readLine())) {
                            if (!l.matches("DBUS_SESSION_BUS_ADDRESS.*")) continue;
                            s = l.replaceAll("^[^=]*=", "");
                        }
                        if (null == s || "".equals(s)) {
                            throw new DBusException(Gettext.getString("cannotResolveSessionBusAddress"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw new DBusException(Gettext.getString("cannotResolveSessionBusAddress"));
                    }
                }
                default: {
                    throw new DBusException(Gettext.getString("invalidBusType") + bustype);
                }
            }
            if (null != (c = conn.get(s))) {
                Object object = c._reflock;
                synchronized (object) {
                    ++c._refcount;
                }
                return c;
            }
            c = new DBusConnection(s);
            conn.put(s, c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBusConnection(String address) throws DBusException {
        super(address);
        this.busnames = new Vector<String>();
        Object object = this._reflock;
        synchronized (object) {
            this._refcount = 1;
        }
        try {
            this.transport = new Transport(this.addr, 100000);
            this.connected = true;
        }
        catch (IOException IOe) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            this.disconnect();
            throw new DBusException(Gettext.getString("connectionFailure") + IOe.getMessage());
        }
        catch (ParseException Pe) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            this.disconnect();
            throw new DBusException(Gettext.getString("connectionFailure") + Pe.getMessage());
        }
        this.listen();
        _sighandler h = new _sighandler();
        this.addSigHandlerWithoutMatch(DBus.Local.Disconnected.class, h);
        this.addSigHandlerWithoutMatch(DBus.NameAcquired.class, h);
        this._dbus = this.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        try {
            this.busnames.add(this._dbus.Hello());
        }
        catch (DBusExecutionException DBEe) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(DBEe.getMessage());
        }
    }

    DBusInterface dynamicProxy(String source, String path) throws DBusException {
        try {
            DBus.Introspectable intro = this.getRemoteObject(source, path, DBus.Introspectable.class);
            String data = intro.Introspect();
            String[] tags = data.split("[<>]");
            Vector<String> ifaces = new Vector<String>();
            for (String tag : tags) {
                if (!tag.startsWith("interface")) continue;
                ifaces.add(tag.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
            }
            Vector ifcs = new Vector();
            block5: for (String iface : ifaces) {
                int j = 0;
                while (j >= 0) {
                    try {
                        Class<?> ifclass = Class.forName(iface);
                        if (ifcs.contains(ifclass)) continue block5;
                        ifcs.add(ifclass);
                        continue block5;
                    }
                    catch (Exception ifclass) {
                        j = iface.lastIndexOf(".");
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
            if (ifcs.size() == 0) {
                throw new DBusException(Gettext.getString("interfaceToCastNotFound"));
            }
            RemoteObject ro = new RemoteObject(source, path, null, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(((Class)ifcs.get(0)).getClassLoader(), ifcs.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.importedObjects.put(newi, ro);
            return newi;
        }
        catch (Exception e) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(MessageFormat.format(Gettext.getString("createProxyExportFailure"), path, source, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DBusInterface getExportedObject(String source, String path) throws DBusException {
        ExportedObject o = null;
        Map map = this.exportedObjects;
        synchronized (map) {
            o = (ExportedObject)this.exportedObjects.get(path);
        }
        if (null != o && null == o.object.get()) {
            this.unExportObject(path);
            o = null;
        }
        if (null != o) {
            return o.object.get();
        }
        if (null == source) {
            throw new DBusException(Gettext.getString("objectNotExportedNoRemoteSpecified"));
        }
        return this.dynamicProxy(source, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBusName(String busname) throws DBusException {
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || busname.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName"));
        }
        List<String> list = this.busnames;
        synchronized (list) {
            try {
                UInt32 rv = this._dbus.ReleaseName(busname);
            }
            catch (DBusExecutionException DBEe) {
                if (EXCEPTION_DEBUG) {
                    // empty if block
                }
                throw new DBusException(DBEe.getMessage());
            }
            this.busnames.remove(busname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBusName(String busname) throws DBusException {
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || busname.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName"));
        }
        List<String> list = this.busnames;
        synchronized (list) {
            UInt32 rv;
            try {
                rv = this._dbus.RequestName(busname, new UInt32(6L));
            }
            catch (DBusExecutionException DBEe) {
                if (EXCEPTION_DEBUG) {
                    // empty if block
                }
                throw new DBusException(DBEe.getMessage());
            }
            switch (rv.intValue()) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new DBusException(Gettext.getString("dbusRegistrationFailure"));
                }
                case 3: {
                    throw new DBusException(Gettext.getString("dbusRegistrationFailure"));
                }
                case 4: {
                    break;
                }
            }
            this.busnames.add(busname);
        }
    }

    public String getUniqueName() {
        return this.busnames.get(0);
    }

    public String[] getNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.busnames);
        return names.toArray(new String[0]);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String busname, String objectpath, Class<I> type) throws DBusException {
        return this.getPeerRemoteObject(busname, objectpath, type, true);
    }

    public DBusInterface getPeerRemoteObject(String busname, String objectpath) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.getString("nullBusName"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + busname);
        }
        String unique = this._dbus.GetNameOwner(busname);
        return this.dynamicProxy(unique, objectpath);
    }

    public DBusInterface getRemoteObject(String busname, String objectpath) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.getString("nullBusName"));
        }
        if (null == objectpath) {
            throw new DBusException(Gettext.getString("nullObjectPath"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + busname);
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.getString("invalidObjectPath") + objectpath);
        }
        return this.dynamicProxy(busname, objectpath);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String busname, String objectpath, Class<I> type, boolean autostart) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.getString("nullBusName"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + busname);
        }
        String unique = this._dbus.GetNameOwner(busname);
        return this.getRemoteObject(unique, objectpath, type, autostart);
    }

    public <I extends DBusInterface> I getRemoteObject(String busname, String objectpath, Class<I> type) throws DBusException {
        return this.getRemoteObject(busname, objectpath, type, true);
    }

    public <I extends DBusInterface> I getRemoteObject(String busname, String objectpath, Class<I> type, boolean autostart) throws DBusException {
        if (null == busname) {
            throw new DBusException(Gettext.getString("nullBusName"));
        }
        if (null == objectpath) {
            throw new DBusException(Gettext.getString("nullObjectPath"));
        }
        if (null == type) {
            throw new ClassCastException(Gettext.getString("notDBusInterface"));
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + busname);
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.getString("invalidObjectPath") + objectpath);
        }
        if (!DBusInterface.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.getString("notDBusInterface"));
        }
        if (type.getName().equals(type.getSimpleName())) {
            throw new DBusException(Gettext.getString("interfaceNotAllowedOutsidePackage"));
        }
        RemoteObject ro = new RemoteObject(busname, objectpath, type, autostart);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.importedObjects.put(i, ro);
        return (I)i;
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, String source, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.getString("notDBusSignal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.getString("cannotWatchSignalsWellKnownBussName"));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + source);
        }
        this.removeSigHandler(new DBusMatchRule(type, source, null), handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, String source, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.getString("notDBusSignal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.getString("cannotWatchSignalsWellKnownBussName"));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + source);
        }
        String objectpath = ((RemoteObject)this.importedObjects.get((Object)object)).objectpath;
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.getString("invalidObjectPath") + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(type, source, objectpath), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector v = (Vector)this.handledSignals.get(key);
            if (null == v) return;
            v.remove(handler);
            if (0 != v.size()) return;
            this.handledSignals.remove(key);
            try {
                this._dbus.RemoveMatch(rule.toString());
            }
            catch (NotConnected NC) {
                if (!EXCEPTION_DEBUG) return;
            }
            catch (DBusExecutionException DBEe) {
                if (!EXCEPTION_DEBUG) throw new DBusException(DBEe.getMessage());
                throw new DBusException(DBEe.getMessage());
            }
            {
                // empty if block
            }
            return;
        }
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, String source, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.getString("notDBusSignal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.getString("cannotWatchSignalsWellKnownBussName"));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + source);
        }
        this.addSigHandler(new DBusMatchRule(type, source, null), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, String source, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext.getString("notDBusSignal"));
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException(Gettext.getString("cannotWatchSignalsWellKnownBussName"));
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException(Gettext.getString("invalidBusName") + source);
        }
        String objectpath = ((RemoteObject)this.importedObjects.get((Object)object)).objectpath;
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException(Gettext.getString("invalidObjectPath") + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(type, source, objectpath), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        try {
            this._dbus.AddMatch(rule.toString());
        }
        catch (DBusExecutionException DBEe) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(DBEe.getMessage());
        }
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<T>> v = (Vector<DBusSigHandler<T>>)this.handledSignals.get(key);
            if (null == v) {
                v = new Vector<DBusSigHandler<T>>();
                v.add(handler);
                this.handledSignals.put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            Object object = this._reflock;
            synchronized (object) {
                if (0 == --this._refcount) {
                    try {
                        Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.disconnected", 0L, "s", Gettext.getString("disconnected"));
                        Object object2 = this.pendingCalls;
                        synchronized (object2) {
                            long[] set;
                            for (long l : set = this.pendingCalls.getKeys()) {
                                MethodCall m;
                                if (-1L == l || null == (m = this.pendingCalls.remove(l))) continue;
                                m.setReply(err);
                            }
                            this.pendingCalls = null;
                        }
                        object2 = this.pendingErrors;
                        synchronized (object2) {
                            this.pendingErrors.add(err);
                        }
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                    conn.remove(this.addr);
                    super.disconnect();
                }
            }
        }
    }

    private class _sighandler
    implements DBusSigHandler<DBusSignal> {
        private _sighandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(DBusSignal s) {
            if (s instanceof DBus.Local.Disconnected) {
                try {
                    Object object;
                    Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.disconnected", 0L, "s", Gettext.getString("disconnected"));
                    if (null != DBusConnection.this.pendingCalls) {
                        object = DBusConnection.this.pendingCalls;
                        synchronized (object) {
                            long[] set;
                            for (long l : set = DBusConnection.this.pendingCalls.getKeys()) {
                                MethodCall m;
                                if (-1L == l || null == (m = DBusConnection.this.pendingCalls.remove(l))) continue;
                                m.setReply(err);
                            }
                        }
                    }
                    object = DBusConnection.this.pendingErrors;
                    synchronized (object) {
                        DBusConnection.this.pendingErrors.add(err);
                    }
                }
                catch (DBusException dBusException) {}
            } else if (s instanceof DBus.NameAcquired) {
                DBusConnection.this.busnames.add(((DBus.NameAcquired)s).name);
            }
        }
    }

    public class PeerSet
    implements Set<String>,
    DBusSigHandler<DBus.NameOwnerChanged> {
        private Set<String> addresses = new TreeSet<String>();

        public PeerSet() {
            try {
                DBusConnection.this.addSigHandler(new DBusMatchRule(DBus.NameOwnerChanged.class, null, null), this);
            }
            catch (DBusException DBe) {
                if (AbstractConnection.EXCEPTION_DEBUG) {
                    // empty if block
                }
            }
        }

        @Override
        public void handle(DBus.NameOwnerChanged noc) {
            if ("".equals(noc.new_owner) && this.addresses.contains(noc.name)) {
                this.remove(noc.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(String address) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.add(address);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends String> addresses) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.addAll(addresses);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Set<String> set = this.addresses;
            synchronized (set) {
                this.addresses.clear();
            }
        }

        @Override
        public boolean contains(Object o) {
            return this.addresses.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> os) {
            return this.addresses.containsAll(os);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PeerSet) {
                return ((PeerSet)o).addresses.equals(this.addresses);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.addresses.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.addresses.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return this.addresses.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> os) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.removeAll(os);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> os) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.retainAll(os);
            }
        }

        @Override
        public int size() {
            return this.addresses.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray(a);
            }
        }
    }
}

