/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.exceptions;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.MessageUtils;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import java.util.Optional;

public class DependencyInjectionException
extends BeanContextException {
    public DependencyInjectionException(BeanResolutionContext resolutionContext, Argument argument, Throwable cause) {
        super(MessageUtils.buildMessage(resolutionContext, argument, !(cause instanceof BeanInstantiationException) ? cause.getMessage() : null, false), cause);
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, Argument argument, String message) {
        super(MessageUtils.buildMessage(resolutionContext, argument, message, false));
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, FieldInjectionPoint fieldInjectionPoint, Throwable cause) {
        super(MessageUtils.buildMessage(resolutionContext, fieldInjectionPoint, null, false), cause);
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, FieldInjectionPoint fieldInjectionPoint, String message) {
        super(MessageUtils.buildMessage(resolutionContext, fieldInjectionPoint, message, false));
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, FieldInjectionPoint fieldInjectionPoint, String message, Throwable cause) {
        super(MessageUtils.buildMessage(resolutionContext, fieldInjectionPoint, message, false), cause);
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, MethodInjectionPoint methodInjectionPoint, Argument argument, Throwable cause) {
        super(MessageUtils.buildMessage(resolutionContext, methodInjectionPoint, argument, null, false), cause);
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, MethodInjectionPoint methodInjectionPoint, Argument argument, String message) {
        super(MessageUtils.buildMessage(resolutionContext, methodInjectionPoint, argument, message, false));
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, ArgumentConversionContext argumentConversionContext, String property) {
        super(MessageUtils.buildMessage(resolutionContext, argumentConversionContext.getArgument(), DependencyInjectionException.buildConversionMessage(property, argumentConversionContext), false));
    }

    public DependencyInjectionException(BeanResolutionContext resolutionContext, MethodInjectionPoint methodInjectionPoint, ArgumentConversionContext conversionContext, String property) {
        super(MessageUtils.buildMessage(resolutionContext, methodInjectionPoint, conversionContext.getArgument(), DependencyInjectionException.buildConversionMessage(property, conversionContext), false));
    }

    protected DependencyInjectionException(BeanResolutionContext resolutionContext, MethodInjectionPoint methodInjectionPoint, Argument argument, String message, boolean circular) {
        super(MessageUtils.buildMessage(resolutionContext, methodInjectionPoint, argument, message, circular));
    }

    protected DependencyInjectionException(BeanResolutionContext resolutionContext, FieldInjectionPoint fieldInjectionPoint, String message, boolean circular) {
        super(MessageUtils.buildMessage(resolutionContext, fieldInjectionPoint, message, circular));
    }

    protected DependencyInjectionException(BeanResolutionContext resolutionContext, Argument argument, String message, boolean circular) {
        super(MessageUtils.buildMessage(resolutionContext, argument, message, circular));
    }

    private static String buildConversionMessage(String property, ArgumentConversionContext conversionContext) {
        Optional lastError = conversionContext.getLastError();
        if (lastError.isPresent()) {
            ConversionError conversionError = (ConversionError)lastError.get();
            return "Error resolving property value [" + property + "]. Unable to convert value " + conversionError.getOriginalValue().map(o -> "[" + o + "]").orElse("") + " to target type [" + conversionContext.getArgument().getTypeString(true) + "] due to: " + conversionError.getCause().getMessage();
        }
        return "Error resolving property value [" + property + "]. Property doesn't exist";
    }
}

