/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;

public class MethodChecks {
    private MethodChecks() {
    }

    public static boolean isVirtual(IFunction method) throws JavaScriptModelException {
        if (method.isConstructor()) {
            return false;
        }
        if (JdtFlags.isPrivate((IMember)method)) {
            return false;
        }
        if (JdtFlags.isStatic((IMember)method)) {
            return false;
        }
        return method.getDeclaringType() != null;
    }

    public static boolean isVirtual(IFunctionBinding methodBinding) {
        if (methodBinding.isConstructor()) {
            return false;
        }
        if (Modifier.isPrivate((int)methodBinding.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic((int)methodBinding.getModifiers());
    }

    public static RefactoringStatus checkIfOverridesAnother(IFunction method, ITypeHierarchy hierarchy) throws JavaScriptModelException {
        IFunction overrides = MethodChecks.overridesAnotherMethod(method, hierarchy);
        if (overrides == null) {
            return null;
        }
        RefactoringStatusContext context = JavaStatusContext.create((IMember)overrides);
        String message = Messages.format(RefactoringCoreMessages.MethodChecks_overrides, new String[]{JavaElementUtil.createMethodSignature(overrides), JavaModelUtil.getFullyQualifiedName(overrides.getDeclaringType())});
        return RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)1, (Object)overrides);
    }

    public static IFunction overridesAnotherMethod(IFunction method, ITypeHierarchy hierarchy) throws JavaScriptModelException {
        boolean overrides;
        MethodOverrideTester tester = new MethodOverrideTester(method.getDeclaringType(), hierarchy);
        IFunction found = tester.findDeclaringMethod(method, true);
        boolean bl = overrides = found != null && !found.equals(method) && !JdtFlags.isStatic((IMember)found) && !JdtFlags.isPrivate((IMember)found);
        if (overrides) {
            return found;
        }
        return null;
    }

    public static IFunction getTopmostMethod(IFunction method, ITypeHierarchy typeHierarchy, IProgressMonitor monitor) throws JavaScriptModelException {
        IFunction overrides;
        Assert.isNotNull((Object)method);
        ITypeHierarchy hierarchy = typeHierarchy;
        IFunction topmostMethod = null;
        IType declaringType = method.getDeclaringType();
        if (declaringType == null) {
            return method;
        }
        if (hierarchy == null || !declaringType.equals(hierarchy.getType())) {
            hierarchy = declaringType.newTypeHierarchy(monitor);
        }
        if (hierarchy == null) {
            hierarchy = declaringType.newSupertypeHierarchy(monitor);
        }
        if ((overrides = MethodChecks.overridesAnotherMethod(method, hierarchy)) != null && !overrides.equals(method)) {
            topmostMethod = overrides;
        }
        return topmostMethod;
    }

    public static IFunction[] getOverriddenMethods(IFunction method, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)method);
        return RippleMethodFinder2.getRelatedMethods(method, monitor, null);
    }
}

